/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.util.actions.components.implementations;

import java.util.SplittableRandom;
import me.gabytm.util.actions.actions.Context;
import me.gabytm.util.actions.components.Component;
import me.gabytm.util.actions.placeholders.PlaceholderManager;
import me.gabytm.util.actions.utils.Numbers;
import org.jetbrains.annotations.NotNull;

public class RandomLongComponent<T>
extends Component<T, Long> {
    private static final SplittableRandom RANDOM = new SplittableRandom();
    public static final String ID = "randomL";
    private final String minString;
    private final String maxString;
    private final Long minLong;
    private final Long maxLong;

    public RandomLongComponent(@NotNull String stringValue, @NotNull PlaceholderManager placeholderManager) {
        super(stringValue, placeholderManager);
        String[] parts = stringValue.split(",");
        this.minString = parts[0];
        this.maxString = parts[1];
        this.minLong = Numbers.tryParseLong(this.minString);
        this.maxLong = Numbers.tryParseLong(this.maxString);
    }

    @Override
    @NotNull
    public Long parse(@NotNull T t, @NotNull Context<T> context) {
        long max;
        if (this.minLong != null && this.maxLong != null) {
            return this.minLong.equals(this.maxLong) ? this.minLong.longValue() : RANDOM.nextLong(this.minLong, this.maxLong + 1L);
        }
        long min = Numbers.tryParse(this.placeholderManager.replace(t, this.minString, context), 0L);
        return min == (max = Numbers.tryParse(this.placeholderManager.replace(t, this.maxString, context), 0L)) ? min : RANDOM.nextLong(min, max + 1L);
    }
}

