/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SnapshotVersion
implements Comparable<SnapshotVersion>,
Serializable {
    private static final long serialVersionUID = 2778655372579322310L;
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("(\\d{2}w\\d{2})([a-z])");
    private final Date snapshotDate;
    private final int snapshotWeekVersion;
    private transient String rawString;

    public SnapshotVersion(String version) {
        Matcher matcher = SNAPSHOT_PATTERN.matcher(version.trim());
        if (matcher.matches()) {
            try {
                this.snapshotDate = SnapshotVersion.getDateFormat().parse(matcher.group(1));
                this.snapshotWeekVersion = matcher.group(2).charAt(0) - 97;
                this.rawString = version;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Date implied by snapshot version is invalid.", e);
            }
        } else {
            throw new IllegalArgumentException("Cannot parse " + version + " as a snapshot version.");
        }
    }

    private static SimpleDateFormat getDateFormat() {
        SimpleDateFormat format = new SimpleDateFormat("yy'w'ww", Locale.US);
        format.setLenient(false);
        return format;
    }

    public int getSnapshotWeekVersion() {
        return this.snapshotWeekVersion;
    }

    public Date getSnapshotDate() {
        return this.snapshotDate;
    }

    public String getSnapshotString() {
        if (this.rawString == null) {
            Calendar current = Calendar.getInstance(Locale.US);
            current.setTime(this.snapshotDate);
            this.rawString = String.format("%02dw%02d%s", current.get(1) % 100, current.get(3), Character.valueOf((char)(97 + this.snapshotWeekVersion)));
        }
        return this.rawString;
    }

    @Override
    public int compareTo(SnapshotVersion o) {
        if (o == null) {
            return 1;
        }
        return ComparisonChain.start().compare((Comparable)this.snapshotDate, (Comparable)o.getSnapshotDate()).compare(this.snapshotWeekVersion, o.getSnapshotWeekVersion()).result();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SnapshotVersion) {
            SnapshotVersion other = (SnapshotVersion)obj;
            return Objects.equals(this.snapshotDate, other.getSnapshotDate()) && this.snapshotWeekVersion == other.getSnapshotWeekVersion();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.snapshotDate, this.snapshotWeekVersion);
    }

    public String toString() {
        return this.getSnapshotString();
    }
}

