/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.upload;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.events.OraxenPackPreUploadEvent;
import io.th0rgal.oraxen.api.events.OraxenPackUploadEvent;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.pack.dispatch.BukkitPackSender;
import io.th0rgal.oraxen.pack.dispatch.PackSender;
import io.th0rgal.oraxen.pack.generation.ResourcePack;
import io.th0rgal.oraxen.pack.receive.PackReceiver;
import io.th0rgal.oraxen.pack.upload.hosts.HostingProvider;
import io.th0rgal.oraxen.pack.upload.hosts.Polymath;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.nio.file.ProviderNotFoundException;
import java.util.Locale;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class UploadManager {
    private static String url;
    private final Plugin plugin;
    private final boolean enabled;
    private final HostingProvider hostingProvider;
    private PackSender packSender;
    private PackReceiver receiver;

    public UploadManager(Plugin plugin) {
        this.plugin = plugin;
        this.enabled = Settings.UPLOAD.toBool();
        this.hostingProvider = this.createHostingProvider();
    }

    public HostingProvider getHostingProvider() {
        return this.hostingProvider;
    }

    public PackSender getSender() {
        return this.packSender;
    }

    public void uploadAsyncAndSendToPlayers(ResourcePack resourcePack, boolean updatePackSender, boolean isReload) {
        if (!this.enabled) {
            return;
        }
        if (Settings.RECEIVE_ENABLED.toBool().booleanValue() && this.receiver == null) {
            this.receiver = new PackReceiver();
            Bukkit.getPluginManager().registerEvents((Listener)this.receiver, this.plugin);
        }
        long time = System.currentTimeMillis();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)OraxenPlugin.get(), () -> {
            EventUtils.callEvent(new OraxenPackPreUploadEvent());
            Message.PACK_UPLOADING.log(new TagResolver[0]);
            if (!this.hostingProvider.uploadPack(resourcePack.getFile())) {
                Message.PACK_NOT_UPLOADED.log(new TagResolver[0]);
                return;
            }
            OraxenPackUploadEvent uploadEvent = new OraxenPackUploadEvent(this.hostingProvider);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OraxenPlugin.get(), () -> Bukkit.getPluginManager().callEvent((Event)uploadEvent));
            Message.PACK_UPLOADED.log(AdventureUtils.tagResolver("url", this.hostingProvider.getPackURL()), AdventureUtils.tagResolver("delay", String.valueOf(System.currentTimeMillis() - time)));
            if (this.packSender == null) {
                this.packSender = new BukkitPackSender(this.hostingProvider);
            } else if (updatePackSender) {
                this.packSender.unregister();
                this.packSender = new BukkitPackSender(this.hostingProvider);
            }
            if (isReload && !Settings.SEND_ON_RELOAD.toBool().booleanValue() && this.packSender != null) {
                this.packSender.unregister();
            } else if (Settings.SEND_PACK.toBool().booleanValue() || Settings.SEND_JOIN_MESSAGE.toBool().booleanValue()) {
                this.packSender.register();
                if (!this.hostingProvider.getPackURL().equals(url)) {
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        this.packSender.sendPack(player);
                    }
                }
                url = this.hostingProvider.getPackURL();
            } else if (this.packSender != null) {
                this.packSender.unregister();
            }
        });
    }

    private HostingProvider createHostingProvider() {
        HostingProvider provider;
        switch (Settings.UPLOAD_TYPE.toString().toLowerCase(Locale.ENGLISH)) {
            case "polymath": {
                HostingProvider hostingProvider = new Polymath(Settings.POLYMATH_SERVER.toString());
                break;
            }
            case "external": {
                HostingProvider hostingProvider = this.createExternalProvider();
                break;
            }
            default: {
                HostingProvider hostingProvider = provider = null;
            }
        }
        if (provider == null) {
            Logs.logError("Unknown Hosting-Provider type: " + String.valueOf((Object)Settings.UPLOAD_TYPE));
            Logs.logError("Polymath will be used instead.");
            provider = new Polymath(Settings.POLYMATH_SERVER.toString());
        }
        return provider;
    }

    private HostingProvider createExternalProvider() {
        Class<?> target;
        ConfigurationSection options = (ConfigurationSection)Settings.UPLOAD_OPTIONS.getValue();
        String klass = options.getString("class");
        if (klass == null) {
            throw new ProviderNotFoundException("No provider set.");
        }
        try {
            target = Class.forName(klass);
        }
        catch (Exception any) {
            ProviderNotFoundException error = new ProviderNotFoundException("Provider not found: " + klass);
            error.addSuppressed(any);
            throw error;
        }
        if (!HostingProvider.class.isAssignableFrom(target)) {
            throw new ProviderNotFoundException(String.valueOf(target) + " is not a valid HostingProvider.");
        }
        return this.constructExternalHostingProvider(target, options);
    }

    private HostingProvider constructExternalHostingProvider(Class<?> target, ConfigurationSection options) {
        Constructor<? extends HostingProvider> constructor = UploadManager.getConstructor(target);
        try {
            return constructor.getParameterCount() == 0 ? constructor.newInstance(new Object[0]) : constructor.newInstance(options);
        }
        catch (InstantiationException e) {
            throw (ProviderNotFoundException)new ProviderNotFoundException("Cannot alloc instance for " + String.valueOf(target)).initCause(e);
        }
        catch (IllegalAccessException e) {
            throw (ProviderNotFoundException)new ProviderNotFoundException("Failed to access " + String.valueOf(target)).initCause(e);
        }
        catch (InvocationTargetException e) {
            throw (ProviderNotFoundException)new ProviderNotFoundException("Exception in allocating instance.").initCause(e.getCause());
        }
    }

    @NotNull
    private static Constructor<? extends HostingProvider> getConstructor(Class<?> target) {
        Class<HostingProvider> implement = target.asSubclass(HostingProvider.class);
        Constructor<?> constructor = null;
        for (Constructor<?> implementConstructor : implement.getConstructors()) {
            Parameter[] parameters = implementConstructor.getParameters();
            if (parameters.length != 0 && (parameters.length != 1 || !parameters[0].getType().equals(ConfigurationSection.class))) continue;
            constructor = implementConstructor;
            break;
        }
        if (constructor == null) {
            throw new ProviderNotFoundException("Invalid provider: " + String.valueOf(target));
        }
        return constructor;
    }
}

