/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.nms;

import io.th0rgal.oraxen.items.helpers.EmptyItemPropertyHandler;
import io.th0rgal.oraxen.items.helpers.ItemPropertyHandler;
import io.th0rgal.oraxen.nms.GlyphHandler;
import java.util.Set;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NMSHandler {
    public static final Set<String> vanillaKeys = Set.of("PublicBukkitValues", "display", "CustomModelData", "Damage", "AttributeModifiers", "Unbreakable", "CanDestroy", "slot", "count", "HideFlags", "CanPlaceOn", "Enchantments", "StoredEnchantments", "RepairCost", "CustomPotionEffects", "Potion", "CustomPotionColor", "Trim", "EntityTag", "pages", "filtered_pages", "filtered_title", "resolved", "generation", "author", "title", "BucketVariantTag", "Items", "LodestoneTracked", "LodestoneDimension", "LodestonePos", "ChargedProjectiles", "Charged", "DebugProperty", "Fireworks", "Explosion", "Flight", "map", "map_scale_direction", "map_to_lock", "Decorations", "SkullOwner", "Effects", "BlockEntityTag", "BlockStateTag");

    default public ItemPropertyHandler itemPropertyHandler() {
        return new EmptyItemPropertyHandler();
    }

    public GlyphHandler glyphHandler();

    public boolean noteblockUpdatesDisabled();

    public boolean tripwireUpdatesDisabled();

    public ItemStack copyItemNBTTags(@NotNull ItemStack var1, @NotNull ItemStack var2);

    @Nullable
    public BlockData correctBlockStates(Player var1, EquipmentSlot var2, ItemStack var3);

    public void customBlockDefaultTools(Player var1);

    default public boolean getSupported() {
        return false;
    }

    public static class EmptyNMSHandler
    implements NMSHandler {
        @Override
        public GlyphHandler glyphHandler() {
            return new GlyphHandler.EmptyGlyphHandler();
        }

        @Override
        public boolean noteblockUpdatesDisabled() {
            return false;
        }

        @Override
        public boolean tripwireUpdatesDisabled() {
            return false;
        }

        @Override
        public ItemStack copyItemNBTTags(@NotNull ItemStack oldItem, @NotNull ItemStack newItem) {
            return newItem;
        }

        @Override
        @Nullable
        public BlockData correctBlockStates(Player player, EquipmentSlot slot, ItemStack itemStack) {
            return null;
        }

        @Override
        public void customBlockDefaultTools(Player player) {
        }
    }
}

