/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.food;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.api.events.OraxenItemsLoadedEvent;
import io.th0rgal.oraxen.mechanics.provided.misc.food.FoodMechanic;
import io.th0rgal.oraxen.mechanics.provided.misc.food.FoodMechanicFactory;
import io.th0rgal.oraxen.utils.ItemUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import org.bukkit.GameMode;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class FoodMechanicListener
implements Listener {
    private final FoodMechanicFactory factory;

    public FoodMechanicListener(FoodMechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    private void registerReplacements(OraxenItemsLoadedEvent event) {
        for (String itemID : this.factory.getItems()) {
            FoodMechanic foodMechanic = (FoodMechanic)this.factory.getMechanic(itemID);
            ConfigurationSection replacementSection = foodMechanic.getSection().getConfigurationSection("replacement");
            if (replacementSection == null) continue;
            foodMechanic.registerReplacement(replacementSection);
        }
    }

    @EventHandler
    public void onEatingFood(PlayerItemConsumeEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack itemStack = event.getItem();
        String itemID = OraxenItems.getIdByItem(itemStack);
        if (itemID == null || this.factory.isNotImplementedIn(itemID)) {
            return;
        }
        FoodMechanic mechanic = (FoodMechanic)this.factory.getMechanic(itemID);
        if (!VersionUtil.atOrAbove("1.20.5")) {
            event.setCancelled(true);
            if (player.getGameMode() != GameMode.CREATIVE) {
                ItemStack itemInHand = event.getHand() == EquipmentSlot.HAND ? inventory.getItemInMainHand() : inventory.getItemInOffHand();
                ItemUtils.subtract(itemInHand, 1);
                if (mechanic.hasEffects() && Math.random() <= mechanic.getEffectProbability()) {
                    player.addPotionEffects(mechanic.getEffects());
                }
            }
            player.setFoodLevel(player.getFoodLevel() + Math.min(mechanic.getHunger(), 20));
            player.setSaturation(player.getSaturation() + (float)Math.min(mechanic.getSaturation(), 20));
        }
    }
}

