/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.commands;

import dev.jorel.commandapi.CommandAPICommand;
import dev.jorel.commandapi.arguments.Argument;
import dev.jorel.commandapi.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.arguments.TextArgument;
import dev.jorel.commandapi.executors.ExecutorType;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.mechanics.provided.gameplay.durability.DurabilityMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.durability.DurabilityMechanicFactory;
import io.th0rgal.oraxen.utils.AdventureUtils;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class RepairCommand {
    CommandAPICommand getRepairCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("repair").withPermission("oraxen.command.repair")).withArguments(new Argument[]{(Argument)new TextArgument("type").replaceSuggestions(ArgumentSuggestions.strings("hand", "all"))})).executes((sender, args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (args.get("type").equals("hand")) {
                    ItemStack item = player.getInventory().getItemInMainHand();
                    if (item.getType() == Material.AIR) {
                        Message.CANNOT_BE_REPAIRED_INVALID.send(sender, new TagResolver[0]);
                        return;
                    }
                    if (RepairCommand.repairPlayerItem(item)) {
                        Message.CANNOT_BE_REPAIRED.send(sender, new TagResolver[0]);
                    }
                } else if (player.hasPermission("oraxen.command.repair.all")) {
                    ItemStack[] items = (ItemStack[])ArrayUtils.addAll((Object[])player.getInventory().getStorageContents(), (Object[])player.getInventory().getArmorContents());
                    int failed = 0;
                    for (ItemStack item : items) {
                        if (item == null || item.getType() == Material.AIR || !RepairCommand.repairPlayerItem(item)) continue;
                        Message.CANNOT_BE_REPAIRED.send(sender, new TagResolver[0]);
                        ++failed;
                    }
                    Message.REPAIRED_ITEMS.send(sender, AdventureUtils.tagResolver("amount", String.valueOf(items.length - failed)));
                } else {
                    Message.NO_PERMISSION.send(sender, AdventureUtils.tagResolver("permission", "oraxen.command.repair.all"));
                }
            } else {
                Message.NOT_PLAYER.send(sender, new TagResolver[0]);
            }
        }, new ExecutorType[0]);
    }

    private static boolean repairPlayerItem(ItemStack itemStack) {
        String itemId = OraxenItems.getIdByItem(itemStack);
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof Damageable)) {
            return true;
        }
        Damageable damageable = (Damageable)itemMeta;
        DurabilityMechanicFactory durabilityFactory = DurabilityMechanicFactory.get();
        if (durabilityFactory.isNotImplementedIn(itemId)) {
            if (((Boolean)Settings.REPAIR_COMMAND_ORAXEN_DURABILITY.getValue()).booleanValue()) {
                return true;
            }
            if (damageable.getDamage() == 0) {
                return true;
            }
        } else {
            DurabilityMechanic durabilityMechanic = durabilityFactory.getMechanic(itemId);
            PersistentDataContainer pdc = itemMeta.getPersistentDataContainer();
            int realMaxDurability = durabilityMechanic.getItemMaxDurability();
            int damage = realMaxDurability - (Integer)pdc.get(DurabilityMechanic.DURABILITY_KEY, PersistentDataType.INTEGER);
            if (damage == 0) {
                return true;
            }
            pdc.set(DurabilityMechanic.DURABILITY_KEY, PersistentDataType.INTEGER, (Object)realMaxDurability);
        }
        damageable.setDamage(0);
        itemStack.setItemMeta((ItemMeta)damageable);
        return false;
    }
}

