/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import com.ticxo.playeranimator.PlayerAnimatorImpl;
import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkitConfig;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.api.events.OraxenItemsLoadedEvent;
import io.th0rgal.oraxen.commands.CommandsManager;
import io.th0rgal.oraxen.compatibilities.CompatibilitiesManager;
import io.th0rgal.oraxen.config.ConfigsManager;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.ResourcesManager;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.config.SettingsUpdater;
import io.th0rgal.oraxen.font.FontManager;
import io.th0rgal.oraxen.font.packets.InventoryPacketListener;
import io.th0rgal.oraxen.font.packets.TitlePacketListener;
import io.th0rgal.oraxen.gestures.GestureManager;
import io.th0rgal.oraxen.hud.HudManager;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureFactory;
import io.th0rgal.oraxen.nms.GlyphHandlers;
import io.th0rgal.oraxen.nms.NMSHandlers;
import io.th0rgal.oraxen.pack.generation.ResourcePack;
import io.th0rgal.oraxen.pack.upload.UploadManager;
import io.th0rgal.oraxen.recipes.RecipesManager;
import io.th0rgal.oraxen.sound.SoundManager;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.LU;
import io.th0rgal.oraxen.utils.NoticeUtils;
import io.th0rgal.oraxen.utils.OS;
import io.th0rgal.oraxen.utils.PluginUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.actions.ClickActionManager;
import io.th0rgal.oraxen.utils.armorequipevent.ArmorEquipEvent;
import io.th0rgal.oraxen.utils.breaker.BreakerSystem;
import io.th0rgal.oraxen.utils.customarmor.CustomArmorListener;
import io.th0rgal.oraxen.utils.inventories.InvManager;
import io.th0rgal.oraxen.utils.logs.Logs;
import io.th0rgal.protectionlib.ProtectionLib;
import java.io.IOException;
import java.util.jar.JarFile;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class OraxenPlugin
extends JavaPlugin {
    private static OraxenPlugin oraxen;
    private static GestureManager gestureManager;
    private ConfigsManager configsManager;
    private ResourcesManager resourceManager;
    private BukkitAudiences audience;
    private UploadManager uploadManager;
    private FontManager fontManager;
    private HudManager hudManager;
    private SoundManager soundManager;
    private InvManager invManager;
    private ResourcePack resourcePack;
    private ClickActionManager clickActionManager;
    public static boolean supportsDisplayEntities;

    public OraxenPlugin() {
        oraxen = this;
    }

    public static OraxenPlugin get() {
        return oraxen;
    }

    @Nullable
    public static JarFile getJarFile() {
        try {
            return new JarFile(oraxen.getFile());
        }
        catch (IOException e) {
            return null;
        }
    }

    public void onLoad() {
        CommandAPI.onLoad(new CommandAPIBukkitConfig(this).silentLogs(true));
    }

    public void onEnable() {
        CommandAPI.onEnable();
        ProtectionLib.init(this);
        if (!VersionUtil.atOrAbove("1.20.3")) {
            PlayerAnimatorImpl.initialize(this);
        }
        this.audience = BukkitAudiences.create((Plugin)this);
        this.clickActionManager = new ClickActionManager(this);
        supportsDisplayEntities = VersionUtil.atOrAbove("1.19.4");
        this.reloadConfigs();
        ProtectionLib.setDebug(Settings.DEBUG.toBool());
        if (Settings.KEEP_UP_TO_DATE.toBool().booleanValue()) {
            new SettingsUpdater().handleSettingsUpdate();
        }
        if (PluginUtils.isEnabled("ProtocolLib")) {
            new BreakerSystem().registerListener();
            if (Settings.FORMAT_INVENTORY_TITLES.toBool().booleanValue()) {
                ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new InventoryPacketListener());
            }
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)new TitlePacketListener());
        } else {
            Logs.logWarning("ProtocolLib is not on your server, some features will not work");
        }
        Bukkit.getPluginManager().registerEvents((Listener)new CustomArmorListener(), (Plugin)this);
        NMSHandlers.setup();
        this.resourcePack = new ResourcePack();
        MechanicsManager.registerNativeMechanics();
        this.hudManager = new HudManager(this.configsManager);
        this.fontManager = new FontManager(this.configsManager);
        this.soundManager = new SoundManager(this.configsManager.getSound());
        if (!VersionUtil.atOrAbove("1.20.3")) {
            gestureManager = new GestureManager();
        }
        OraxenItems.loadItems();
        this.fontManager.registerEvents();
        this.fontManager.verifyRequired();
        this.hudManager.registerEvents();
        this.hudManager.registerTask();
        this.hudManager.parsedHudDisplays = this.hudManager.generateHudDisplays();
        Bukkit.getPluginManager().registerEvents((Listener)new ItemUpdater(), (Plugin)this);
        this.resourcePack.generate();
        RecipesManager.load(this);
        this.invManager = new InvManager();
        ArmorEquipEvent.registerListener(this);
        new CommandsManager().loadCommands();
        this.postLoading();
        try {
            Message.PLUGIN_LOADED.log(AdventureUtils.tagResolver("os", OS.getOs().getPlatformName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        CompatibilitiesManager.enableNativeCompatibilities();
        if (VersionUtil.isCompiled()) {
            NoticeUtils.compileNotice();
        }
        if (VersionUtil.isLeaked()) {
            NoticeUtils.leakNotice();
        }
    }

    private void postLoading() {
        new Metrics(this, 5371);
        new LU().l();
        Bukkit.getScheduler().runTask((Plugin)this, () -> Bukkit.getPluginManager().callEvent((Event)new OraxenItemsLoadedEvent()));
    }

    public void onDisable() {
        HandlerList.unregisterAll((Plugin)this);
        FurnitureFactory.unregisterEvolution();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!GlyphHandlers.isNms()) continue;
            NMSHandlers.getHandler().glyphHandler().uninject(player);
        }
        CompatibilitiesManager.disableCompatibilities();
        CommandAPI.onDisable();
        Message.PLUGIN_UNLOADED.log(new TagResolver[0]);
    }

    public ResourcesManager getResourceManager() {
        return this.resourceManager;
    }

    public GestureManager getGesturesManager() {
        return gestureManager;
    }

    public BukkitAudiences getAudience() {
        return this.audience;
    }

    public void reloadConfigs() {
        this.configsManager = new ConfigsManager(this);
        this.configsManager.validatesConfig();
        this.resourceManager = new ResourcesManager(this);
    }

    public ConfigsManager getConfigsManager() {
        return this.configsManager;
    }

    public UploadManager getUploadManager() {
        return this.uploadManager;
    }

    public void setUploadManager(UploadManager uploadManager) {
        this.uploadManager = uploadManager;
    }

    public FontManager getFontManager() {
        return this.fontManager;
    }

    public void setFontManager(FontManager fontManager) {
        this.fontManager.unregisterEvents();
        this.fontManager = fontManager;
        fontManager.registerEvents();
    }

    public HudManager getHudManager() {
        return this.hudManager;
    }

    public void setHudManager(HudManager hudManager) {
        this.hudManager.unregisterEvents();
        this.hudManager = hudManager;
        hudManager.registerEvents();
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    public void setSoundManager(SoundManager soundManager) {
        this.soundManager = soundManager;
    }

    public InvManager getInvManager() {
        return this.invManager;
    }

    public ResourcePack getResourcePack() {
        return this.resourcePack;
    }

    public ClickActionManager getClickActionManager() {
        return this.clickActionManager;
    }
}

