/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.PlatformExecutable;
import dev.jorel.commandapi.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.executors.BukkitExecutionInfo;
import dev.jorel.commandapi.executors.CommandArguments;
import dev.jorel.commandapi.executors.CommandBlockCommandExecutor;
import dev.jorel.commandapi.executors.CommandBlockExecutionInfo;
import dev.jorel.commandapi.executors.CommandBlockResultingCommandExecutor;
import dev.jorel.commandapi.executors.CommandBlockResultingExecutionInfo;
import dev.jorel.commandapi.executors.CommandExecutionInfo;
import dev.jorel.commandapi.executors.CommandExecutor;
import dev.jorel.commandapi.executors.ConsoleCommandExecutor;
import dev.jorel.commandapi.executors.ConsoleExecutionInfo;
import dev.jorel.commandapi.executors.ConsoleResultingCommandExecutor;
import dev.jorel.commandapi.executors.ConsoleResultingExecutionInfo;
import dev.jorel.commandapi.executors.EntityCommandExecutor;
import dev.jorel.commandapi.executors.EntityExecutionInfo;
import dev.jorel.commandapi.executors.EntityResultingCommandExecutor;
import dev.jorel.commandapi.executors.EntityResultingExecutionInfo;
import dev.jorel.commandapi.executors.ExecutionInfo;
import dev.jorel.commandapi.executors.ExecutorType;
import dev.jorel.commandapi.executors.FeedbackForwardingCommandExecutor;
import dev.jorel.commandapi.executors.FeedbackForwardingExecutionInfo;
import dev.jorel.commandapi.executors.FeedbackForwardingResultingCommandExecutor;
import dev.jorel.commandapi.executors.FeedbackForwardingResultingExecutionInfo;
import dev.jorel.commandapi.executors.NativeCommandExecutor;
import dev.jorel.commandapi.executors.NativeExecutionInfo;
import dev.jorel.commandapi.executors.NativeResultingCommandExecutor;
import dev.jorel.commandapi.executors.NativeResultingExecutionInfo;
import dev.jorel.commandapi.executors.PlayerCommandExecutor;
import dev.jorel.commandapi.executors.PlayerExecutionInfo;
import dev.jorel.commandapi.executors.PlayerResultingCommandExecutor;
import dev.jorel.commandapi.executors.PlayerResultingExecutionInfo;
import dev.jorel.commandapi.executors.ProxyCommandExecutor;
import dev.jorel.commandapi.executors.ProxyExecutionInfo;
import dev.jorel.commandapi.executors.ProxyResultingCommandExecutor;
import dev.jorel.commandapi.executors.ProxyResultingExecutionInfo;
import dev.jorel.commandapi.executors.RemoteConsoleCommandExecutor;
import dev.jorel.commandapi.executors.RemoteConsoleExecutionInfo;
import dev.jorel.commandapi.executors.RemoteConsoleResultingCommandExecutor;
import dev.jorel.commandapi.executors.RemoteConsoleResultingExecutionInfo;
import dev.jorel.commandapi.executors.ResultingCommandExecutionInfo;
import dev.jorel.commandapi.executors.ResultingCommandExecutor;
import org.bukkit.command.CommandSender;

public interface BukkitExecutable<Impl extends BukkitExecutable<Impl>>
extends PlatformExecutable<Impl, CommandSender> {
    default public Impl executes(final CommandExecutor executor, ExecutorType ... types) {
        if (types == null || types.length == 0) {
            this.getExecutor().addNormalExecutor(executor);
        } else {
            for (final ExecutorType type : types) {
                this.getExecutor().addNormalExecutor(new CommandExecutor(){

                    @Override
                    public void run(CommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
                        executor.executeWith(new BukkitExecutionInfo<CommandSender>(sender, CommandAPIBukkit.get().wrapCommandSender(sender), args));
                    }

                    @Override
                    public ExecutorType getType() {
                        return type;
                    }
                });
            }
        }
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executes(final CommandExecutionInfo executor, ExecutorType ... types) {
        if (types == null || types.length == 0) {
            this.getExecutor().addNormalExecutor(executor);
        } else {
            for (final ExecutorType type : types) {
                this.getExecutor().addNormalExecutor(new CommandExecutionInfo(){

                    @Override
                    public void run(ExecutionInfo<CommandSender, BukkitCommandSender<? extends CommandSender>> info) throws WrapperCommandSyntaxException {
                        executor.executeWith(info);
                    }

                    @Override
                    public ExecutorType getType() {
                        return type;
                    }
                });
            }
        }
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executes(final ResultingCommandExecutor executor, ExecutorType ... types) {
        if (types == null || types.length == 0) {
            this.getExecutor().addResultingExecutor(executor);
        } else {
            for (final ExecutorType type : types) {
                this.getExecutor().addResultingExecutor(new ResultingCommandExecutor(){

                    @Override
                    public int run(CommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
                        executor.executeWith(new BukkitExecutionInfo<CommandSender>(sender, CommandAPIBukkit.get().wrapCommandSender(sender), args));
                        return 1;
                    }

                    @Override
                    public ExecutorType getType() {
                        return type;
                    }
                });
            }
        }
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executes(final ResultingCommandExecutionInfo executor, ExecutorType ... types) {
        if (types == null || types.length == 0) {
            this.getExecutor().addResultingExecutor(executor);
        } else {
            for (final ExecutorType type : types) {
                this.getExecutor().addResultingExecutor(new ResultingCommandExecutionInfo(){

                    @Override
                    public int run(ExecutionInfo<CommandSender, BukkitCommandSender<? extends CommandSender>> info) throws WrapperCommandSyntaxException {
                        executor.executeWith(info);
                        return 1;
                    }

                    @Override
                    public ExecutorType getType() {
                        return type;
                    }
                });
            }
        }
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesPlayer(PlayerCommandExecutor executor) {
        this.getExecutor().addNormalExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesPlayer(PlayerExecutionInfo info) {
        this.getExecutor().addNormalExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesPlayer(PlayerResultingCommandExecutor executor) {
        this.getExecutor().addResultingExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesPlayer(PlayerResultingExecutionInfo info) {
        this.getExecutor().addResultingExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesEntity(EntityCommandExecutor executor) {
        this.getExecutor().addNormalExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesEntity(EntityExecutionInfo info) {
        this.getExecutor().addNormalExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesEntity(EntityResultingCommandExecutor executor) {
        this.getExecutor().addResultingExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesEntity(EntityResultingExecutionInfo info) {
        this.getExecutor().addResultingExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesProxy(ProxyCommandExecutor executor) {
        this.getExecutor().addNormalExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesProxy(ProxyExecutionInfo info) {
        this.getExecutor().addNormalExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesProxy(ProxyResultingCommandExecutor executor) {
        this.getExecutor().addResultingExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesProxy(ProxyResultingExecutionInfo info) {
        this.getExecutor().addResultingExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesCommandBlock(CommandBlockCommandExecutor executor) {
        this.getExecutor().addNormalExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesCommandBlock(CommandBlockExecutionInfo info) {
        this.getExecutor().addNormalExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesCommandBlock(CommandBlockResultingCommandExecutor executor) {
        this.getExecutor().addResultingExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesCommandBlock(CommandBlockResultingExecutionInfo info) {
        this.getExecutor().addResultingExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesConsole(ConsoleCommandExecutor executor) {
        this.getExecutor().addNormalExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesConsole(ConsoleExecutionInfo info) {
        this.getExecutor().addNormalExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesConsole(ConsoleResultingCommandExecutor executor) {
        this.getExecutor().addResultingExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesConsole(ConsoleResultingExecutionInfo info) {
        this.getExecutor().addResultingExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesNative(NativeCommandExecutor executor) {
        this.getExecutor().addNormalExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesNative(NativeExecutionInfo info) {
        this.getExecutor().addNormalExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesNative(NativeResultingCommandExecutor executor) {
        this.getExecutor().addResultingExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesNative(NativeResultingExecutionInfo info) {
        this.getExecutor().addResultingExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesRemoteConsole(RemoteConsoleCommandExecutor executor) {
        this.getExecutor().addNormalExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesRemoteConsole(RemoteConsoleExecutionInfo info) {
        this.getExecutor().addNormalExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesRemoteConsole(RemoteConsoleResultingCommandExecutor executor) {
        this.getExecutor().addResultingExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesRemoteConsole(RemoteConsoleResultingExecutionInfo info) {
        this.getExecutor().addResultingExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesFeedbackForwarding(FeedbackForwardingCommandExecutor executor) {
        this.getExecutor().addNormalExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesFeedbackForwarding(FeedbackForwardingExecutionInfo info) {
        this.getExecutor().addNormalExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesFeedbackForwarding(FeedbackForwardingResultingCommandExecutor executor) {
        this.getExecutor().addResultingExecutor(executor);
        return (Impl)((BukkitExecutable)this.instance());
    }

    default public Impl executesFeedbackForwarding(FeedbackForwardingResultingExecutionInfo info) {
        this.getExecutor().addResultingExecutor(info);
        return (Impl)((BukkitExecutable)this.instance());
    }
}

