/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.utils.math;

import com.ticxo.playeranimator.api.utils.math.Quaternion;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class TMath {
    public static double clamp(double value, double min, double max) {
        return Math.min(Math.max(value, min), max);
    }

    public static float fastInvSqrt(float value) {
        float half = 0.5f * value;
        int rawBits = Float.floatToIntBits(value);
        rawBits = 1597463007 - (rawBits >> 1);
        value = Float.intBitsToFloat(rawBits);
        value = (float)((double)value * (1.5 - (double)(half * value * value)));
        return value;
    }

    public static double fastInvSqrt(double value) {
        double half = 0.5 * value;
        long rawBits = Double.doubleToRawLongBits(value);
        rawBits = 6910469410427058090L - (rawBits >> 1);
        value = Double.longBitsToDouble(rawBits);
        value *= 1.5 - half * value * value;
        return value;
    }

    public static EulerAngle makeAngle(double x, double y, double z) {
        return new EulerAngle(Math.toRadians(x), Math.toRadians(y), Math.toRadians(z));
    }

    public static EulerAngle globalRotate(EulerAngle origin, EulerAngle delta) {
        return Quaternion.globalRotate(Quaternion.fromEulerAngle(origin), Quaternion.fromEulerAngle(delta)).toEulerAngle();
    }

    public static EulerAngle localRotate(EulerAngle origin, EulerAngle delta) {
        return TMath.globalRotate(delta, origin);
    }

    public static double lerp(double a2, double b2, double t) {
        return (1.0 - t) * a2 + t * b2;
    }

    public static double lerp(double a2, double b2, double aT, double bT) {
        return aT * a2 + bT * b2;
    }

    public static Vector lerp(Vector a2, Vector b2, double t) {
        return new Vector(TMath.lerp(a2.getX(), b2.getX(), t), TMath.lerp(a2.getY(), b2.getY(), t), TMath.lerp(a2.getZ(), b2.getZ(), t));
    }

    public static Vector lerp(Vector a2, Vector b2, double aT, double bT) {
        return new Vector(TMath.lerp(a2.getX(), b2.getX(), aT, bT), TMath.lerp(a2.getY(), b2.getY(), aT, bT), TMath.lerp(a2.getZ(), b2.getZ(), aT, bT));
    }

    public static Vector smoothLerp(Vector a2, Vector b2, Vector c2, Vector d2, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        Vector a1 = TMath.lerp(a2, b2, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        Vector a22 = TMath.lerp(b2, c2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        Vector a3 = TMath.lerp(c2, d2, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        Vector b1 = TMath.lerp(a1, a22, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        Vector b22 = TMath.lerp(a22, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b22, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static EulerAngle lerp(EulerAngle a2, EulerAngle b2, double t) {
        return new EulerAngle(TMath.lerp(a2.getX(), b2.getX(), t), TMath.lerp(a2.getY(), b2.getY(), t), TMath.lerp(a2.getZ(), b2.getZ(), t));
    }

    public static EulerAngle lerp(EulerAngle a2, EulerAngle b2, double aT, double bT) {
        return new EulerAngle(TMath.lerp(a2.getX(), b2.getX(), aT, bT), TMath.lerp(a2.getY(), b2.getY(), aT, bT), TMath.lerp(a2.getZ(), b2.getZ(), aT, bT));
    }

    public static EulerAngle smoothLerp(EulerAngle a2, EulerAngle b2, EulerAngle c2, EulerAngle d2, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        EulerAngle a1 = TMath.lerp(a2, b2, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        EulerAngle a22 = TMath.lerp(b2, c2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        EulerAngle a3 = TMath.lerp(c2, d2, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        EulerAngle b1 = TMath.lerp(a1, a22, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        EulerAngle b22 = TMath.lerp(a22, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.lerp(b1, b22, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static EulerAngle slerp(EulerAngle a2, EulerAngle b2, double t) {
        return TMath.slerp(Quaternion.fromEulerAngle(a2), Quaternion.fromEulerAngle(b2), t).toEulerAngle();
    }

    public static Quaternion slerp(Quaternion a2, Quaternion b2, double t) {
        return TMath.slerp(a2, b2, 1.0 - t, t);
    }

    public static Quaternion slerp(Quaternion a2, Quaternion b2, double aT, double bT) {
        double diff = a2.dot(b2);
        double absDiff = Math.abs(diff);
        if (absDiff > 0.9995) {
            double theta = Math.acos(absDiff);
            double sinTheta = Math.sin(theta);
            aT = Math.sin(theta * aT) / sinTheta;
            bT = Math.sin(theta * bT) / sinTheta;
            if (diff < 0.0) {
                aT *= -1.0;
            }
        }
        return a2.altMul(aT).add(b2.altMul(bT)).normalize();
    }

    public static Quaternion smoothSlerp(Quaternion a2, Quaternion b2, Quaternion c2, Quaternion d2, double t) {
        double t0 = 0.0;
        double t1 = 1.0;
        double t2 = 2.0;
        double t3 = 3.0;
        t = (t2 - t1) * t + t1;
        Quaternion a1 = TMath.slerp(a2, b2, (t1 - t) / (t1 - t0), (t - t0) / (t1 - t0));
        Quaternion a22 = TMath.slerp(b2, c2, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
        Quaternion a3 = TMath.slerp(c2, d2, (t3 - t) / (t3 - t2), (t - t2) / (t3 - t2));
        Quaternion b1 = TMath.slerp(a1, a22, (t2 - t) / (t2 - t0), (t - t0) / (t2 - t0));
        Quaternion b22 = TMath.slerp(a22, a3, (t3 - t) / (t3 - t1), (t - t1) / (t3 - t1));
        return TMath.slerp(b1, b22, (t2 - t) / (t2 - t1), (t - t1) / (t2 - t1));
    }

    public static String toString(EulerAngle angle) {
        return String.format("[%s, %s, %s]", Math.toDegrees(angle.getX()), Math.toDegrees(angle.getY()), Math.toDegrees(angle.getZ()));
    }
}

