/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.texture;

import com.google.gson.Gson;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class TextureWrapper {
    private static final Gson gson = new Gson();
    private static final String jsonTemplate = "{\"textures\":{\"SKIN\":{\"url\":\"\",\"metadata\":{}}}}";
    private final SimpleProfileTexture payload = (SimpleProfileTexture)gson.fromJson("{\"textures\":{\"SKIN\":{\"url\":\"\",\"metadata\":{}}}}", SimpleProfileTexture.class);
    private String url;
    private boolean isSlim;

    public static TextureWrapper fromBase64(String base64) {
        String decoded = new String(Base64.getDecoder().decode(base64));
        SimpleProfileTexture temp = (SimpleProfileTexture)gson.fromJson(decoded, SimpleProfileTexture.class);
        String url = temp.getTextures().get(MinecraftProfileTexture.Type.SKIN).getUrl();
        boolean isSlim = "slim".equals(temp.getTextures().get(MinecraftProfileTexture.Type.SKIN).getMetadata("model"));
        return new TextureWrapper(url, isSlim);
    }

    public TextureWrapper(String url, boolean isSlim) {
        this.setUrl(url);
        this.setSlim(isSlim);
    }

    public String toBase64() {
        this.updatePayload();
        String json = gson.toJson((Object)this.payload);
        return Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
    }

    private void updatePayload() {
        HashMap<String, String> meta = new HashMap<String, String>();
        if (this.isSlim) {
            meta.put("model", "slim");
        }
        this.payload.getTextures().put(MinecraftProfileTexture.Type.SKIN, new MinecraftProfileTexture(this.url, meta));
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isSlim() {
        return this.isSlim;
    }

    public void setSlim(boolean isSlim) {
        this.isSlim = isSlim;
    }

    private static class SimpleProfileTexture {
        private Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures;

        private SimpleProfileTexture() {
        }

        public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures() {
            return this.textures;
        }
    }
}

