/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator;

import com.ticxo.playeranimator.api.PlayerAnimator;
import com.ticxo.playeranimator.api.PlayerAnimatorPlugin;
import com.ticxo.playeranimator.api.animation.AnimationManager;
import com.ticxo.playeranimator.api.model.ModelManager;
import com.ticxo.playeranimator.nms.v1_17_1_R1.NMSHandler_v1_17_1_R1;
import com.ticxo.playeranimator.nms.v1_17_R1.NMSHandler_v1_17_R1;
import com.ticxo.playeranimator.nms.v1_18_R1.NMSHandler_v1_18_R1;
import com.ticxo.playeranimator.nms.v1_18_R2.NMSHandler_v1_18_R2;
import com.ticxo.playeranimator.nms.v1_19_R1.NMSHandler_v1_19_R1;
import com.ticxo.playeranimator.nms.v1_19_R1_2.NMSHandler_v1_19_R1_2;
import com.ticxo.playeranimator.nms.v1_19_R2.NMSHandler_v1_19_R2;
import com.ticxo.playeranimator.nms.v1_19_R3.NMSHandler_v1_19_R3;
import com.ticxo.playeranimator.nms.v1_20_R2.NMSHandler_v1_20_R2;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayerAnimatorImpl
extends PlayerAnimator {
    public static PlayerAnimator initialize(JavaPlugin plugin) {
        if (api == null) {
            api = new PlayerAnimatorImpl();
        }
        if (PlayerAnimatorPlugin.plugin == null) {
            PlayerAnimatorPlugin.plugin = plugin;
        }
        api.getModelManager().activate();
        return api;
    }

    @Override
    public void injectPlayer(Player player) {
        this.getNms().injectPlayer(player);
    }

    @Override
    public void removePlayer(Player player) {
        this.getNms().removePlayer(player);
    }

    private PlayerAnimatorImpl() {
        this.setAnimationManager(new AnimationManager());
        this.setModelManager(new ModelManager());
        this.getVersion();
        this.applyNMS();
    }

    protected void getVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        this.version = name.substring(name.lastIndexOf(46) + 1);
    }

    private void applyNMS() {
        switch (this.version) {
            case "v1_17_R1": {
                if (Bukkit.getBukkitVersion().contains("1.17.1")) {
                    this.setNms(new NMSHandler_v1_17_1_R1());
                    break;
                }
                this.setNms(new NMSHandler_v1_17_R1());
                break;
            }
            case "v1_18_R1": {
                this.setNms(new NMSHandler_v1_18_R1());
                break;
            }
            case "v1_18_R2": {
                this.setNms(new NMSHandler_v1_18_R2());
                break;
            }
            case "v1_19_R1": {
                if (!"1.19-R0.1-SNAPSHOT".equals(Bukkit.getBukkitVersion())) {
                    this.setNms(new NMSHandler_v1_19_R1_2());
                    break;
                }
                this.setNms(new NMSHandler_v1_19_R1());
                break;
            }
            case "v1_19_R2": {
                this.setNms(new NMSHandler_v1_19_R2());
                break;
            }
            case "v1_19_R3": {
                this.setNms(new NMSHandler_v1_19_R3());
                break;
            }
            case "v1_20_R1": {
                this.setNms(new NMSHandler_v1_20_R2());
                break;
            }
            case "v1_20_R2": {
                this.setNms(new NMSHandler_v1_20_R2());
                break;
            }
            default: {
                throw new IllegalStateException("Version not supported");
            }
        }
    }
}

