/*
 * Decompiled with CFR 0.152.
 */
package me.gabytm.util.actions.actions;

import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import me.gabytm.util.actions.actions.Context;
import me.gabytm.util.actions.components.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionMeta<T> {
    private static final long DEFAULT_DELAY = 0L;
    private static final double DEFAULT_CHANCE = 0.0;
    private final Map<String, String> properties;
    private final String rawData;
    private final List<Component<T, ?>> components;
    private final long delay;
    private final double chance;

    public ActionMeta(@NotNull Map<String, String> properties, @Nullable String rawData, @NotNull List<Component<T, ?>> components) {
        this.properties = properties;
        this.rawData = rawData == null ? "" : rawData;
        this.components = components;
        this.delay = this.getProperty("delay", 0L, Longs::tryParse);
        this.chance = this.getProperty("chance", 0.0, Doubles::tryParse);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    @NotNull
    public <R> R getProperty(@NotNull String key, @NotNull R def, @NotNull @NotNull Function<@NotNull String, @Nullable R> transformer) {
        String value = this.properties.get(key);
        if (value == null) {
            return def;
        }
        R result = transformer.apply(value);
        return result == null ? def : result;
    }

    public List<Component<T, ?>> getComponents() {
        return this.components;
    }

    public String getRawData() {
        return this.rawData;
    }

    @NotNull
    public String getParsedData(@NotNull T t, @NotNull Context<T> context) {
        StringBuilder stringBuilder = new StringBuilder(this.rawData.length());
        for (Component<T, ?> component : this.components) {
            stringBuilder.append(component.parse(t, context));
        }
        return stringBuilder.toString();
    }

    public long getDelay() {
        return this.delay;
    }

    public boolean hasDelay() {
        return this.getDelay() != 0L;
    }

    public double getChance() {
        return this.chance;
    }

    public boolean hasChance() {
        return this.getChance() != 0.0;
    }
}

