/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.jeff_media.morepersistentdatatypes.DataType;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.compatibilities.provided.ecoitems.WrappedEcoItem;
import io.th0rgal.oraxen.compatibilities.provided.mmoitems.WrappedMMOItem;
import io.th0rgal.oraxen.compatibilities.provided.mythiccrucible.WrappedCrucibleItem;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.items.OraxenMeta;
import io.th0rgal.oraxen.items.PersistentDataSpace;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.OraxenYaml;
import io.th0rgal.oraxen.utils.VersionUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Tag;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.TropicalFish;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.TropicalFishBucketMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder {
    public static final NamespacedKey UNSTACKABLE_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "unstackable");
    public static final NamespacedKey ORIGINAL_NAME_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "original_name");
    private final ItemStack itemStack;
    private final Map<PersistentDataSpace, Object> persistentDataMap = new HashMap<PersistentDataSpace, Object>();
    private final PersistentDataContainer persistentDataContainer;
    private final Map<Enchantment, Integer> enchantments;
    private OraxenMeta oraxenMeta;
    private Material type;
    private int amount;
    private int durability;
    private Color color;
    private Key trimPattern;
    private PotionData potionData;
    private List<PotionEffect> potionEffects;
    private OfflinePlayer owningPlayer;
    private DyeColor bodyColor;
    private TropicalFish.Pattern pattern;
    private DyeColor patternColor;
    private String displayName;
    private boolean unbreakable;
    private boolean unstackable;
    private Set<ItemFlag> itemFlags;
    private boolean hasAttributeModifiers;
    private Multimap<Attribute, AttributeModifier> attributeModifiers;
    private boolean hasCustomModelData;
    private int customModelData;
    private List<String> lore;
    private ItemStack finalItemStack;

    public ItemBuilder(Material material) {
        this(new ItemStack(material));
    }

    public ItemBuilder(WrappedMMOItem wrapped) {
        this(wrapped.build());
    }

    public ItemBuilder(WrappedCrucibleItem wrapped) {
        this(wrapped.build());
    }

    public ItemBuilder(WrappedEcoItem wrapped) {
        this(wrapped.build());
    }

    public ItemBuilder(@NotNull ItemStack itemStack) {
        TropicalFishBucketMeta tropicalFishBucketMeta;
        ArmorMeta armorMeta;
        this.itemStack = itemStack;
        this.type = itemStack.getType();
        this.amount = itemStack.getAmount();
        ItemMeta itemMeta = itemStack.getItemMeta();
        assert (itemMeta != null);
        if (itemMeta instanceof Damageable) {
            Damageable damageable = (Damageable)itemMeta;
            this.durability = damageable.getDamage();
        }
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            this.color = leatherArmorMeta.getColor();
        }
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            this.color = potionMeta.getColor();
            this.potionData = potionMeta.getBasePotionData();
            this.potionEffects = new ArrayList<PotionEffect>(potionMeta.getCustomEffects());
        }
        if (itemMeta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)itemMeta;
            this.color = mapMeta.getColor();
        }
        if (itemMeta instanceof FireworkEffectMeta) {
            FireworkEffectMeta effectMeta = (FireworkEffectMeta)itemMeta;
            Color color = this.color = effectMeta.hasEffect() ? (Color)effectMeta.getEffect().getColors().get(0) : Color.WHITE;
        }
        if (VersionUtil.atOrAbove("1.20") && itemMeta instanceof ArmorMeta && (armorMeta = (ArmorMeta)itemMeta).hasTrim()) {
            this.trimPattern = armorMeta.getTrim().getMaterial().key();
        }
        if (itemMeta instanceof SkullMeta) {
            SkullMeta skullMeta = (SkullMeta)itemMeta;
            this.owningPlayer = skullMeta.getOwningPlayer();
        }
        if (itemMeta instanceof TropicalFishBucketMeta && (tropicalFishBucketMeta = (TropicalFishBucketMeta)itemMeta).hasVariant()) {
            this.bodyColor = tropicalFishBucketMeta.getBodyColor();
            this.pattern = tropicalFishBucketMeta.getPattern();
            this.patternColor = tropicalFishBucketMeta.getPatternColor();
        }
        if (itemMeta.hasDisplayName()) {
            this.displayName = itemMeta.getDisplayName();
        }
        this.unbreakable = itemMeta.isUnbreakable();
        this.unstackable = itemMeta.getPersistentDataContainer().has(UNSTACKABLE_KEY, DataType.UUID);
        if (!itemMeta.getItemFlags().isEmpty()) {
            this.itemFlags = itemMeta.getItemFlags();
        }
        this.hasAttributeModifiers = itemMeta.hasAttributeModifiers();
        if (this.hasAttributeModifiers) {
            this.attributeModifiers = itemMeta.getAttributeModifiers();
        }
        this.hasCustomModelData = itemMeta.hasCustomModelData();
        if (itemMeta.hasCustomModelData()) {
            this.customModelData = itemMeta.getCustomModelData();
        }
        if (itemMeta.hasLore()) {
            this.lore = itemMeta.getLore();
        }
        this.persistentDataContainer = itemMeta.getPersistentDataContainer();
        this.enchantments = new HashMap<Enchantment, Integer>();
    }

    public Material getType() {
        return this.type;
    }

    public ItemBuilder setType(Material type) {
        this.type = type;
        return this;
    }

    public ItemBuilder setAmount(int amount) {
        if (amount > this.type.getMaxStackSize()) {
            amount = this.type.getMaxStackSize();
        }
        this.amount = amount;
        return this;
    }

    public String getDisplayName() {
        return this.displayName != null ? this.displayName : (String)AdventureUtils.MINI_MESSAGE.serialize(this.itemStack.displayName());
    }

    public ItemBuilder setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public boolean hasLores() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public List<String> getLore() {
        return this.lore != null ? this.lore : new ArrayList<String>();
    }

    public ItemBuilder setLore(List<String> lore) {
        this.lore = lore;
        return this;
    }

    public ItemBuilder setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
        return this;
    }

    public boolean isUnstackable() {
        return this.unstackable;
    }

    public ItemBuilder setUnstackable(boolean unstackable) {
        this.unstackable = unstackable;
        return this;
    }

    public ItemBuilder setDurability(int durability) {
        this.durability = durability;
        return this;
    }

    public boolean hasColor() {
        return this.color != null && !this.color.equals((Object)Bukkit.getItemFactory().getDefaultLeatherColor());
    }

    public Color getColor() {
        return this.color;
    }

    public ItemBuilder setColor(Color color) {
        this.color = color;
        return this;
    }

    public boolean hasTrimPattern() {
        return VersionUtil.atOrAbove("1.20") && this.trimPattern != null && this.getTrimPattern() != null;
    }

    @Nullable
    public Key getTrimPatternKey() {
        if (!VersionUtil.atOrAbove("1.20")) {
            return null;
        }
        if (!Tag.ITEMS_TRIMMABLE_ARMOR.isTagged((Keyed)this.type)) {
            return null;
        }
        return this.trimPattern;
    }

    @Nullable
    public TrimPattern getTrimPattern() {
        if (!VersionUtil.atOrAbove("1.20")) {
            return null;
        }
        if (!Tag.ITEMS_TRIMMABLE_ARMOR.isTagged((Keyed)this.type)) {
            return null;
        }
        if (this.trimPattern == null) {
            return null;
        }
        NamespacedKey key = NamespacedKey.fromString((String)this.trimPattern.asString());
        if (key == null) {
            return null;
        }
        return (TrimPattern)Registry.TRIM_PATTERN.get(key);
    }

    public ItemBuilder setTrimPattern(Key trimKey) {
        if (!VersionUtil.atOrAbove("1.20")) {
            return this;
        }
        if (!Tag.ITEMS_TRIMMABLE_ARMOR.isTagged((Keyed)this.type)) {
            return this;
        }
        this.trimPattern = trimKey;
        return this;
    }

    public ItemBuilder setBasePotionData(PotionData potionData) {
        this.potionData = potionData;
        return this;
    }

    public ItemBuilder addPotionEffect(PotionEffect potionEffect) {
        if (this.potionEffects == null) {
            this.potionEffects = new ArrayList<PotionEffect>();
        }
        this.potionEffects.add(potionEffect);
        return this;
    }

    public ItemBuilder setOwningPlayer(OfflinePlayer owningPlayer) {
        this.owningPlayer = owningPlayer;
        return this;
    }

    public <T, Z> ItemBuilder setCustomTag(NamespacedKey namespacedKey, PersistentDataType<T, Z> dataType, Z data) {
        this.persistentDataMap.put(new PersistentDataSpace<T, Z>(namespacedKey, dataType), data);
        return this;
    }

    public <T, Z> Z getCustomTag(NamespacedKey namespacedKey, PersistentDataType<T, Z> dataType) {
        for (Map.Entry<PersistentDataSpace, Object> dataSpace : this.persistentDataMap.entrySet()) {
            if (!dataSpace.getKey().namespacedKey().equals((Object)namespacedKey) || !dataSpace.getKey().dataType().equals(dataType)) continue;
            return (Z)dataSpace.getValue();
        }
        return null;
    }

    public boolean hasCustomTag() {
        return !this.persistentDataContainer.isEmpty();
    }

    public <T, Z> void addCustomTag(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        this.persistentDataContainer.set(key, type, value);
    }

    public ItemBuilder removeCustomTag(NamespacedKey key) {
        this.persistentDataContainer.remove(key);
        return this;
    }

    public ItemBuilder setCustomModelData(int customModelData) {
        if (!this.hasCustomModelData) {
            this.hasCustomModelData = true;
        }
        this.customModelData = customModelData;
        return this;
    }

    public ItemBuilder addItemFlags(ItemFlag ... itemFlags) {
        if (this.itemFlags == null) {
            this.itemFlags = new HashSet<ItemFlag>();
        }
        this.itemFlags.addAll(Arrays.asList(itemFlags));
        return this;
    }

    public List<ItemFlag> getItemFlags() {
        return this.itemFlags != null ? new ArrayList<ItemFlag>(this.itemFlags) : new ArrayList();
    }

    public ItemBuilder addAttributeModifiers(Attribute attribute, AttributeModifier attributeModifier) {
        if (!this.hasAttributeModifiers) {
            this.hasAttributeModifiers = true;
            this.attributeModifiers = HashMultimap.create();
        }
        this.attributeModifiers.put((Object)attribute, (Object)attributeModifier);
        return this;
    }

    public ItemBuilder addAllAttributeModifiers(Multimap<Attribute, AttributeModifier> attributeModifiers) {
        if (!this.hasAttributeModifiers) {
            this.hasAttributeModifiers = true;
        }
        this.attributeModifiers.putAll(attributeModifiers);
        return this;
    }

    public ItemBuilder setTropicalFishBucketBodyColor(DyeColor bodyColor) {
        this.bodyColor = bodyColor;
        return this;
    }

    public ItemBuilder setTropicalFishBucketPattern(TropicalFish.Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    public ItemBuilder setTropicalFishBucketPatternColor(DyeColor patternColor) {
        this.patternColor = patternColor;
        return this;
    }

    public ItemBuilder addEnchant(Enchantment enchant, int level) {
        this.enchantments.put(enchant, level);
        return this;
    }

    public ItemBuilder addEnchants(Map<Enchantment, Integer> enchants) {
        for (Map.Entry<Enchantment, Integer> enchant : enchants.entrySet()) {
            this.addEnchant(enchant.getKey(), enchant.getValue());
        }
        return this;
    }

    public boolean hasOraxenMeta() {
        return this.oraxenMeta != null;
    }

    public OraxenMeta getOraxenMeta() {
        return this.oraxenMeta;
    }

    public ItemBuilder setOraxenMeta(OraxenMeta itemResources) {
        this.oraxenMeta = itemResources;
        return this;
    }

    public ItemStack getReferenceClone() {
        return this.itemStack.clone();
    }

    public ItemBuilder regen() {
        ItemStack itemStack = this.itemStack;
        if (this.type != null) {
            itemStack.setType(this.type);
        }
        if (this.amount != itemStack.getAmount()) {
            itemStack.setAmount(this.amount);
        }
        ItemMeta itemMeta = this.handleVariousMeta(itemStack.getItemMeta());
        assert (itemMeta != null);
        PersistentDataContainer pdc = itemMeta.getPersistentDataContainer();
        if (this.displayName != null) {
            pdc.set(ORIGINAL_NAME_KEY, DataType.STRING, (Object)this.displayName);
            itemMeta.setDisplayName(this.displayName);
        }
        itemMeta.setUnbreakable(this.unbreakable);
        if (this.itemFlags != null) {
            itemMeta.addItemFlags(this.itemFlags.toArray(new ItemFlag[0]));
        }
        if (this.enchantments.size() > 0) {
            for (Map.Entry<Enchantment, Integer> entry : this.enchantments.entrySet()) {
                if (entry.getKey() == null) continue;
                int lvl = entry.getValue() != null ? entry.getValue() : 1;
                itemMeta.addEnchant(entry.getKey(), lvl, true);
            }
        }
        if (this.hasAttributeModifiers) {
            itemMeta.setAttributeModifiers(this.attributeModifiers);
        }
        if (this.hasCustomModelData) {
            itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
        }
        if (!this.persistentDataMap.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.persistentDataMap.entrySet()) {
                pdc.set(((PersistentDataSpace)entry.getKey()).namespacedKey(), ((PersistentDataSpace)entry.getKey()).dataType(), entry.getValue());
            }
        }
        itemMeta.setLore(this.lore);
        itemStack.setItemMeta(itemMeta);
        this.finalItemStack = itemStack;
        return this;
    }

    public void save() {
        this.regen();
        OraxenItems.getMap().entrySet().stream().filter(entry -> ((Map)entry.getValue()).containsValue(this)).findFirst().ifPresent(entry -> {
            block5: {
                YamlConfiguration yamlConfiguration = OraxenYaml.loadConfiguration((File)entry.getKey());
                if (this.hasColor()) {
                    String color = this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue();
                    yamlConfiguration.set(OraxenItems.getIdByItem(this.build()) + ".color", (Object)color);
                }
                if (this.hasTrimPattern()) {
                    String trimPattern = this.getTrimPatternKey().asString();
                    yamlConfiguration.set(OraxenItems.getIdByItem(this.build()) + ".trim_pattern", (Object)trimPattern);
                }
                if (!this.getItemFlags().isEmpty()) {
                    yamlConfiguration.set(OraxenItems.getIdByItem(this.build()) + ".ItemFlags", this.itemFlags.stream().map(Enum::name).toList());
                }
                try {
                    yamlConfiguration.save((File)entry.getKey());
                }
                catch (IOException e) {
                    if (!Settings.DEBUG.toBool().booleanValue()) break block5;
                    e.printStackTrace();
                }
            }
        });
    }

    private ItemMeta handleVariousMeta(ItemMeta itemMeta) {
        TropicalFishBucketMeta tropicalFishBucketMeta;
        SkullMeta skullMeta;
        OfflinePlayer defaultOwningPlayer;
        Damageable damageable;
        if (itemMeta instanceof Damageable && this.durability != (damageable = (Damageable)itemMeta).getDamage()) {
            damageable.setDamage(this.durability);
            return damageable;
        }
        if (itemMeta instanceof LeatherArmorMeta) {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)itemMeta;
            if (this.color != null && !this.color.equals((Object)leatherArmorMeta.getColor())) {
                leatherArmorMeta.setColor(this.color);
                return leatherArmorMeta;
            }
        }
        if (itemMeta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)itemMeta;
            return this.handlePotionMeta(potionMeta);
        }
        if (itemMeta instanceof MapMeta) {
            MapMeta mapMeta = (MapMeta)itemMeta;
            if (this.color != null && !this.color.equals((Object)mapMeta.getColor())) {
                mapMeta.setColor(this.color);
                return mapMeta;
            }
        }
        if (itemMeta instanceof FireworkEffectMeta) {
            FireworkEffect.Builder fireWorkBuilder;
            FireworkEffectMeta effectMeta = (FireworkEffectMeta)itemMeta;
            if (effectMeta.clone().hasEffect()) {
                effectMeta.getEffect();
                v0 = FireworkEffect.builder();
            } else {
                v0 = fireWorkBuilder = FireworkEffect.builder();
            }
            if (this.color != null) {
                fireWorkBuilder.withColor(this.color);
            }
            try {
                effectMeta.setEffect(fireWorkBuilder.build());
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return effectMeta;
        }
        if (VersionUtil.atOrAbove("1.20") && itemMeta instanceof ArmorMeta) {
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            if (this.hasTrimPattern()) {
                armorMeta.setTrim(new ArmorTrim(TrimMaterial.REDSTONE, this.getTrimPattern()));
                return armorMeta;
            }
        }
        if (itemMeta instanceof SkullMeta && !Objects.equals(this.owningPlayer, defaultOwningPlayer = (skullMeta = (SkullMeta)itemMeta).getOwningPlayer())) {
            skullMeta.setOwningPlayer(this.owningPlayer);
            return skullMeta;
        }
        if (itemMeta instanceof TropicalFishBucketMeta && (tropicalFishBucketMeta = (TropicalFishBucketMeta)itemMeta).hasVariant()) {
            return this.handleTropicalFishBucketMeta(tropicalFishBucketMeta);
        }
        return itemMeta;
    }

    private ItemMeta handlePotionMeta(PotionMeta potionMeta) {
        if (this.color != null && !this.color.equals((Object)potionMeta.getColor())) {
            potionMeta.setColor(this.color);
        }
        if (!this.potionData.equals((Object)potionMeta.getBasePotionData())) {
            potionMeta.setBasePotionData(this.potionData);
        }
        if (!this.potionEffects.equals(potionMeta.getCustomEffects())) {
            for (PotionEffect potionEffect : this.potionEffects) {
                potionMeta.addCustomEffect(potionEffect, true);
            }
        }
        return potionMeta;
    }

    private ItemMeta handleTropicalFishBucketMeta(TropicalFishBucketMeta tropicalFishBucketMeta) {
        DyeColor defaultPatternColor;
        TropicalFish.Pattern defaultPattern;
        DyeColor defaultColor = tropicalFishBucketMeta.getBodyColor();
        if (!this.bodyColor.equals((Object)defaultColor)) {
            tropicalFishBucketMeta.setBodyColor(this.bodyColor);
        }
        if (!this.pattern.equals((Object)(defaultPattern = tropicalFishBucketMeta.getPattern()))) {
            tropicalFishBucketMeta.setPattern(this.pattern);
        }
        if (!this.patternColor.equals((Object)(defaultPatternColor = tropicalFishBucketMeta.getPatternColor()))) {
            tropicalFishBucketMeta.setPatternColor(this.patternColor);
        }
        return tropicalFishBucketMeta;
    }

    public int getMaxStackSize() {
        return this.unstackable ? 1 : (this.type != null ? this.type.getMaxStackSize() : this.itemStack.getType().getMaxStackSize());
    }

    public ItemStack[] buildArray(int amount) {
        ItemStack built = this.build();
        int max = this.getMaxStackSize();
        int rest = max == amount ? amount : amount % max;
        int iterations = amount > max ? (amount - rest) / max : 0;
        ItemStack[] output = new ItemStack[iterations + (rest > 0 ? 1 : 0)];
        for (int index = 0; index < iterations; ++index) {
            ItemStack clone = built.clone();
            clone.setAmount(max);
            if (this.unstackable) {
                this.handleUnstackable(clone);
            }
            output[index] = ItemUpdater.updateItem(clone);
        }
        if (rest != 0) {
            ItemStack clone = built.clone();
            clone.setAmount(rest);
            if (this.unstackable) {
                this.handleUnstackable(clone);
            }
            output[iterations] = ItemUpdater.updateItem(clone);
        }
        return output;
    }

    public ItemStack build() {
        if (this.finalItemStack == null) {
            this.regen();
        }
        if (this.unstackable) {
            return this.handleUnstackable(this.finalItemStack);
        }
        return this.finalItemStack.clone();
    }

    private ItemStack handleUnstackable(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return item;
        }
        meta.getPersistentDataContainer().set(UNSTACKABLE_KEY, DataType.UUID, (Object)UUID.randomUUID());
        item.setItemMeta(meta);
        item.setAmount(1);
        return item;
    }

    public String toString() {
        return super.toString();
    }
}

