/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.model.player;

import com.ticxo.playeranimator.api.PlayerAnimator;
import com.ticxo.playeranimator.api.PlayerAnimatorPlugin;
import com.ticxo.playeranimator.api.animation.animation.Animation;
import com.ticxo.playeranimator.api.animation.pack.AnimationPack;
import com.ticxo.playeranimator.api.animation.pack.Bone;
import com.ticxo.playeranimator.api.animation.time.AnimationProperty;
import com.ticxo.playeranimator.api.exceptions.MissingAnimationsException;
import com.ticxo.playeranimator.api.exceptions.UnknownAnimationException;
import com.ticxo.playeranimator.api.model.player.LimbType;
import com.ticxo.playeranimator.api.model.player.PlayerBone;
import com.ticxo.playeranimator.api.model.player.PlayerItemBone;
import com.ticxo.playeranimator.api.nms.IRangeManager;
import com.ticxo.playeranimator.api.nms.IRenderer;
import com.ticxo.playeranimator.api.texture.TextureWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class PlayerModel {
    private final Map<LimbType, IRenderer> limbs = new HashMap<LimbType, IRenderer>();
    private final Map<LimbType, PlayerBone> bones = new HashMap<LimbType, PlayerBone>();
    private final Map<String, PlayerBone> children = new HashMap<String, PlayerBone>();
    private Entity base;
    private TextureWrapper texture;
    private AnimationProperty animationProperty;
    private IRangeManager rangeManager;
    private Location locationBuffer;

    public PlayerModel(Player player) {
        this.base = player;
        String raw = PlayerAnimator.api.getNms().getTexture(player);
        this.texture = TextureWrapper.fromBase64(raw);
        this.rangeManager = PlayerAnimator.api.getNms().createRangeManager(this.base);
        this.initialize();
    }

    public PlayerModel(Entity base, String url, boolean isSlim) {
        this.base = base;
        this.texture = new TextureWrapper(url, isSlim);
        this.rangeManager = PlayerAnimator.api.getNms().createRangeManager(base);
        this.initialize();
    }

    public PlayerModel(Entity base, TextureWrapper tex) {
        this.base = base;
        this.texture = tex;
        this.rangeManager = PlayerAnimator.api.getNms().createRangeManager(base);
        this.initialize();
    }

    public PlayerModel(Entity base, Player player) {
        this.base = base;
        String raw = PlayerAnimator.api.getNms().getTexture(player);
        this.texture = TextureWrapper.fromBase64(raw);
        this.rangeManager = PlayerAnimator.api.getNms().createRangeManager(base);
        this.initialize();
    }

    protected void initialize() {
        for (LimbType type : LimbType.values()) {
            this.limbs.put(type, PlayerAnimator.api.getNms().createRenderer());
        }
    }

    public void spawn() {
        for (LimbType type : LimbType.values()) {
            if (!this.limbs.containsKey((Object)type) || !this.bones.containsKey((Object)type)) continue;
            this.limbs.get((Object)type).spawn();
        }
    }

    public void spawn(Player player) {
        for (LimbType type : LimbType.values()) {
            if (!this.limbs.containsKey((Object)type) || !this.bones.containsKey((Object)type)) continue;
            this.limbs.get((Object)type).spawn(player);
        }
    }

    public void despawn() {
        for (LimbType type : this.bones.keySet()) {
            this.limbs.get((Object)type).despawn();
        }
    }

    public void despawn(Player player) {
        for (LimbType type : this.bones.keySet()) {
            this.limbs.get((Object)type).despawn(player);
        }
    }

    public void playAnimation(String name) {
        String[] keys = name.split("\\.", 3);
        if (keys.length < 3) {
            throw new IllegalArgumentException();
        }
        AnimationPack animationPack = PlayerAnimator.api.getAnimationManager().getAnimationPack(keys[0] + ":" + keys[1]);
        if (animationPack == null) {
            PlayerAnimatorPlugin.plugin.getLogger().log(Level.SEVERE, "AnimationPack " + keys[0] + ":" + keys[1] + " not found");
            throw new MissingAnimationsException();
        }
        Animation animation = animationPack.getAnimation(keys[2]);
        if (animation == null) {
            throw new UnknownAnimationException();
        }
        this.bones.clear();
        this.children.clear();
        for (Bone bone : animationPack.getBones()) {
            this.children.put(bone.getName(), this.setBones(bone));
        }
        this.animationProperty = new AnimationProperty(animation);
        this.update(false);
        this.spawn();
        PlayerAnimator.api.getModelManager().registerModel(this);
    }

    private PlayerBone setBones(Bone bone) {
        PlayerBone playerBone;
        LimbType type = LimbType.get(bone.getName());
        if (type != null) {
            playerBone = type.isItem() ? new PlayerItemBone(this, bone, type) : new PlayerBone(this, bone, type);
            this.limbs.get((Object)type).setLimb(playerBone);
            this.bones.put(type, playerBone);
        } else {
            playerBone = new PlayerBone(this, bone);
        }
        for (Bone child : bone.getChildren()) {
            playerBone.addChild(this.setBones(child));
        }
        return playerBone;
    }

    public boolean update() {
        return this.update(true);
    }

    protected boolean update(boolean updateTime) {
        this.locationBuffer = this.getBase().getLocation();
        for (PlayerBone bone : this.children.values()) {
            bone.update();
        }
        for (LimbType type : this.bones.keySet()) {
            this.limbs.get((Object)type).update();
        }
        if (updateTime && !this.getAnimationProperty().updateTime()) {
            this.animationProperty = null;
        }
        return this.animationProperty != null && !this.base.isDead();
    }

    public Set<Player> getSeenBy() {
        Set<Player> set = this.getRangeManager().getPlayerInRange();
        Entity entity = this.base;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            set.add(player);
        }
        return set;
    }

    public Vector getBaseVector() {
        if (this.locationBuffer != null) {
            return this.locationBuffer.toVector();
        }
        return this.getBase().getLocation().toVector();
    }

    public float getBaseYaw() {
        if (this.locationBuffer != null) {
            return this.locationBuffer.getYaw();
        }
        return this.getBase().getLocation().getYaw();
    }

    public Entity getBase() {
        return this.base;
    }

    public void setBase(Entity base) {
        this.base = base;
    }

    public TextureWrapper getTexture() {
        return this.texture;
    }

    public void setTexture(TextureWrapper texture) {
        this.texture = texture;
    }

    public AnimationProperty getAnimationProperty() {
        return this.animationProperty;
    }

    public IRangeManager getRangeManager() {
        return this.rangeManager;
    }
}

