/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_18_2;

import com.github.stefvanschie.inventoryframework.abstraction.GrindstoneInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_18_2.util.CustomInventoryUtil;
import com.github.stefvanschie.inventoryframework.nms.v1_18_2.util.TextHolderUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerGrindstone;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.Slot;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrindstoneInventoryImpl
extends GrindstoneInventory {
    public GrindstoneInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a grindstone should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((EntityHuman)serverPlayer);
        serverPlayer.bV = serverPlayer.bU;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        ContainerGrindstoneImpl containerGrindstone = new ContainerGrindstoneImpl(serverPlayer);
        Inventory inventory = containerGrindstone.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        int containerId = containerGrindstone.getContainerId();
        serverPlayer.b.a((Packet)new PacketPlayOutOpenWindow(containerId, Containers.o, message));
        serverPlayer.bV = containerGrindstone;
        serverPlayer.a((Container)containerGrindstone);
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items, @Nullable ItemStack cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("Cursor may not be null on version 1.17.1");
        }
        NonNullList<net.minecraft.world.item.ItemStack> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.bV.k();
        net.minecraft.world.item.ItemStack nmsCursor = CraftItemStack.asNMSCopy((ItemStack)cursor);
        ServerPlayerConnection playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.a((Packet)new PacketPlayOutWindowItems(containerId, state, nmsItems, nmsCursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bV.k();
        this.getPlayerConnection(serverPlayer).a((Packet)new PacketPlayOutSetSlot(-1, state, -1, net.minecraft.world.item.ItemStack.b));
    }

    @Deprecated
    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.bV.j;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private static class ContainerGrindstoneImpl
    extends ContainerGrindstone {
        public ContainerGrindstoneImpl(@NotNull EntityPlayer serverPlayer) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fr());
            Slot firstSlot = (Slot)this.i.get(0);
            Slot secondSlot = (Slot)this.i.get(1);
            Slot thirdSlot = (Slot)this.i.get(2);
            this.i.set(0, (Object)new Slot(firstSlot.c, firstSlot.d, firstSlot.e, firstSlot.f){

                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    return true;
                }
            });
            this.i.set(1, (Object)new Slot(secondSlot.c, secondSlot.d, secondSlot.e, secondSlot.f){

                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    return true;
                }
            });
            this.i.set(2, (Object)new Slot(thirdSlot.c, thirdSlot.d, thirdSlot.e, thirdSlot.f){

                public boolean a(net.minecraft.world.item.ItemStack stack) {
                    return true;
                }

                public void a(EntityHuman player, net.minecraft.world.item.ItemStack stack) {
                }
            });
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void b(EntityHuman nmsPlayer) {
        }

        public int getContainerId() {
            return this.j;
        }
    }
}

