/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.timers;

import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.utils.AdventureUtils;
import java.text.DecimalFormat;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Timer {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("##.##");
    private long lastUsage = 0L;
    private final long delay;

    Timer(long delay) {
        this.delay = delay;
    }

    Timer(int delay) {
        this.delay = delay;
    }

    public void reset() {
        this.lastUsage = System.currentTimeMillis();
    }

    public boolean isFinished() {
        return System.currentTimeMillis() >= this.lastUsage + this.delay;
    }

    public long getRemainingTime() {
        return this.lastUsage + this.delay - System.currentTimeMillis();
    }

    public String getString() {
        return "%.2f".formatted(Float.valueOf((float)this.getRemainingTime() / 1000.0f));
    }

    public void sendToPlayer(Player player) {
        Message.COOLDOWN.send((CommandSender)player, AdventureUtils.tagResolver("time", this.getString()));
    }
}

