/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.customarmor;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.pack.generation.ResourcePack;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.VirtualFile;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Color;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class ShaderArmorTextures {
    static final int DEFAULT_RESOLUTION = 16;
    static final int HEIGHT_RATIO = 2;
    static final int WIDTH_RATIO = 4;
    private final List<BufferedImage> layers1 = new ArrayList<BufferedImage>();
    private final List<BufferedImage> layers2 = new ArrayList<BufferedImage>();
    private final int resolution;
    private BufferedImage layer1;
    private int layer1Width = 0;
    private int layer1Height = 0;
    private BufferedImage layer2;
    private int layer2Width = 0;
    private int layer2Height = 0;
    private static ShaderType shaderType;
    private final Map<String, Integer> allSpecifiedArmorColors = ShaderArmorTextures.getAllSpecifiedArmorColors();
    private final String OPTIFINE_ARMOR_PATH = "assets/minecraft/optifine/cit/armors/";
    private final String OPTIFINE_ARMOR_ANIMATION_PATH = "assets/minecraft/optifine/anim/";
    private static final String SHADER_PARAMETER_PLACEHOLDER = "{#TEXTURE_RESOLUTION#}";

    public ShaderArmorTextures() {
        this(16);
    }

    public ShaderArmorTextures(int resolution) {
        this.resolution = resolution;
        try {
            shaderType = ShaderType.valueOf(Settings.CUSTOM_ARMOR_SHADER_TYPE.toString().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            Logs.logError("Invalid value for CUSTOM_ARMOR_SHADER_TYPE: " + Settings.CUSTOM_ARMOR_SHADER_TYPE.getValue());
            Logs.logWarning("Valid values are: FANCY, LESS_FANCY");
            Logs.logWarning("Defaulting to FANCY");
            shaderType = ShaderType.FANCY;
        }
    }

    public static boolean isSameArmorType(ItemStack firstItem, ItemStack secondItem) {
        return Objects.equals(ShaderArmorTextures.getArmorNameFromItem(firstItem), ShaderArmorTextures.getArmorNameFromItem(secondItem));
    }

    public static String getArmorNameFromItem(ItemStack item) {
        return ShaderArmorTextures.getArmorNameFromId(OraxenItems.getIdByItem(item));
    }

    public static String getArmorNameFromId(String itemId) {
        return StringUtils.substringBeforeLast((String)itemId, (String)"_");
    }

    public boolean registerImage(File file) {
        BufferedImage img;
        String name = file.getName();
        if (!name.endsWith(".png")) {
            return false;
        }
        if (!name.contains("armor_layer") && !name.contains("leather_layer")) {
            return false;
        }
        if (!Settings.CUSTOM_ARMOR_SHADER_GENERATE_CUSTOM_TEXTURES.toBool().booleanValue()) {
            return false;
        }
        try {
            img = ImageIO.read(file);
        }
        catch (IOException e) {
            OraxenPlugin.get().getLogger().warning("Error while reading " + name + ": " + e.getMessage());
            return false;
        }
        if (name.equals("leather_layer_1.png")) {
            img = this.rescaleArmorImage(img);
            img = this.initLayer(img);
            if (shaderType == ShaderType.FANCY) {
                this.setPixel(img.getRaster(), 0, 1, Color.WHITE);
            }
            this.layer1 = img;
            this.layer1Width = shaderType == ShaderType.FANCY ? this.layer1Width + this.layer1.getWidth() : this.getLayerWidth();
            this.layer1Height = shaderType == ShaderType.FANCY ? this.getLayerHeight() : this.layer1Height + this.layer1.getHeight();
            return true;
        }
        if (name.equals("leather_layer_2.png")) {
            img = this.rescaleArmorImage(img);
            img = this.initLayer(img);
            if (shaderType == ShaderType.FANCY) {
                this.setPixel(img.getRaster(), 0, 1, Color.WHITE);
            }
            this.layer2 = img;
            this.layer2Width = shaderType == ShaderType.FANCY ? this.layer2Width + this.layer2.getWidth() : this.getLayerWidth();
            this.layer2Height = shaderType == ShaderType.FANCY ? this.getLayerHeight() : this.layer2Height + this.layer2.getHeight();
            return true;
        }
        return name.contains("armor_layer_") && this.handleArmorLayer(name, file);
    }

    private int getLayerWidth() {
        return this.resolution * 4;
    }

    private int getLayerHeight() {
        return this.resolution * 2;
    }

    private BufferedImage initLayer(BufferedImage original) {
        BufferedImage output;
        Image scaled;
        int width = original.getWidth();
        int height = original.getHeight();
        if (shaderType == ShaderType.FANCY) {
            if (width == this.resolution * 4 && height == this.getLayerHeight()) {
                return original;
            }
            scaled = original.getScaledInstance(this.resolution * 4, height, 1);
            output = new BufferedImage(this.resolution * 4, height, 2);
        } else {
            if (width == this.getLayerWidth() && height == this.resolution * 2) {
                return original;
            }
            scaled = original.getScaledInstance(width, this.resolution * 2, 1);
            output = new BufferedImage(width, this.resolution * 2, 2);
        }
        output.getGraphics().drawImage(scaled, 0, 0, null);
        return output;
    }

    private boolean handleArmorLayer(String name, File file) {
        BufferedImage original;
        String prefix = name.split("armor_layer_")[0];
        if (name.endsWith("_e.png")) {
            return false;
        }
        try {
            original = ImageIO.read(file);
        }
        catch (IOException e) {
            OraxenPlugin.get().getLogger().warning("Error while reading " + name + ": " + e.getMessage());
            return false;
        }
        if (original == null) {
            OraxenPlugin.get().getLogger().warning("Error while reading " + name + ": Image is null");
            return false;
        }
        BufferedImage image = this.initLayer(original);
        boolean isAnimated = name.endsWith("_a.png");
        File emissiveFile = file.getParentFile().toPath().toAbsolutePath().resolve(name.replace(".png", "_e.png")).toFile();
        boolean isEmissive = Files.exists(emissiveFile.toPath(), new LinkOption[0]);
        if (isEmissive) {
            BufferedImage emissive;
            try {
                emissive = ImageIO.read(emissiveFile);
            }
            catch (IOException e) {
                OraxenPlugin.get().getLogger().warning("Error while reading " + name + ": " + e.getMessage());
                return false;
            }
            BufferedImage emissiveImage = this.initLayer(emissive);
            image = this.mergeImages(image.getWidth() + emissiveImage.getWidth(), emissiveImage.getHeight(), image, emissiveImage);
            this.setPixel(image.getRaster(), 2, 0, Color.fromRGB((int)1, (int)0, (int)0));
        }
        if (image.getColorModel().getPixelSize() < 32) {
            int width = image.getWidth();
            int height = image.getHeight();
            Image resizedImage = original.getScaledInstance(width, height, 1);
            image = new BufferedImage(width, height, 2);
            image.getGraphics().drawImage(resizedImage, 0, 0, null);
        }
        this.addPixel(image, name, prefix, isAnimated);
        return true;
    }

    private Color fixArmorColors(String prefix, String name) {
        Color color = null;
        for (String suffix : new String[]{"helmet", "chestplate", "leggings", "boots"}) {
            boolean duplicateColor;
            boolean missingArmor;
            ItemMeta meta;
            ItemBuilder builder = OraxenItems.getItemById(prefix + suffix);
            ItemMeta itemMeta = meta = builder != null ? builder.build().getItemMeta() : null;
            if (!(meta instanceof LeatherArmorMeta) && builder != null && builder.build().getType().toString().toLowerCase().endsWith(suffix)) {
                Logs.logError("Material of " + prefix + suffix + " is not a LeatherArmor material!");
                Logs.logWarning("Custom Armor requires that the item is LeatherArmor");
                Logs.logWarning("You can add fake armor values via AttributeModifiers", true);
            }
            switch (suffix) {
                case "helmet": 
                case "chestplate": {
                    boolean bl;
                    if (OraxenItems.getItemById(prefix + "helmet") == null && OraxenItems.getItemById(prefix + "chestplate") == null) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case "leggings": 
                case "boots": {
                    boolean bl;
                    if (OraxenItems.getItemById(prefix + "leggings") == null && OraxenItems.getItemById(prefix + "boots") == null) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    boolean bl = missingArmor = true;
                }
            }
            if (missingArmor) {
                if (name.endsWith("_1.png") && Set.of("helmet", "chestplate").contains(suffix)) {
                    Message.NO_ARMOR_ITEM.log(AdventureUtils.tagResolver("name", prefix + suffix), AdventureUtils.tagResolver("armor_layer_file", name));
                } else if (name.endsWith("_2.png") && Set.of("leggings", "boots").contains(suffix)) {
                    Message.NO_ARMOR_ITEM.log(AdventureUtils.tagResolver("name", prefix + suffix), AdventureUtils.tagResolver("armor_layer_file", name));
                }
            }
            boolean bl = duplicateColor = this.allSpecifiedArmorColors.entrySet().stream().filter(e -> builder != null && builder.hasColor() && ((Integer)e.getValue()).intValue() == builder.getColor().asRGB()).toList().size() >= 2;
            if (builder != null && (!builder.hasColor() || duplicateColor || shaderType == ShaderType.LESS_FANCY)) {
                String itemPrefix = prefix.replace("_", "");
                int tempColor = (Integer)this.allSpecifiedArmorColors.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(itemPrefix)).findFirst().orElseGet(() -> Map.entry(prefix, this.layers1.size() + 1)).getValue();
                Color armorColor = Color.fromRGB((int)this.getColorInt(itemPrefix, tempColor));
                if (this.allSpecifiedArmorColors.entrySet().stream().filter(e -> !((String)e.getKey()).equals(itemPrefix)).map(Map.Entry::getValue).toList().contains(armorColor.asRGB())) {
                    armorColor = Color.fromRGB((int)this.getColorInt(itemPrefix, tempColor + 1));
                }
                builder.setColor(armorColor);
                builder.save();
                if (Settings.DEBUG.toBool().booleanValue()) {
                    Logs.logInfo("Assigned color " + armorColor.asRGB() + " to " + prefix + suffix);
                }
            }
            color = builder != null && builder.hasColor() ? builder.getColor() : null;
        }
        return color;
    }

    private int getColorInt(String itemId, int start) {
        int color;
        if (this.allSpecifiedArmorColors.get(itemId) != null) {
            color = this.allSpecifiedArmorColors.get(itemId);
        } else if (this.allSpecifiedArmorColors.entrySet().stream().filter(e -> !((String)e.getKey()).equals(itemId)).anyMatch(e -> (Integer)e.getValue() == start)) {
            Logs.logWarning("Color " + start + " is already used! Reassigning " + itemId + " with a new color...");
            color = this.getColorInt(itemId, start + 1);
        } else {
            color = start;
        }
        this.allSpecifiedArmorColors.put(itemId, color);
        return color;
    }

    private void addPixel(BufferedImage image, String name, String prefix, boolean isAnimated) {
        Color armorColor = this.fixArmorColors(prefix, name);
        if (armorColor != null) {
            if (shaderType == ShaderType.FANCY) {
                this.setPixel(image.getRaster(), 0, 0, armorColor);
                if (isAnimated) {
                    this.setPixel(image.getRaster(), 1, 0, Color.fromRGB((int)(image.getHeight() / (Integer)Settings.CUSTOM_ARMOR_SHADER_RESOLUTION.getValue()), (int)this.getAnimatedArmorFramerate(), (int)1));
                }
            }
            if (name.contains("armor_layer_1")) {
                this.layers1.add(image);
                this.layer1Width = shaderType == ShaderType.FANCY ? this.layer1Width + image.getWidth() : Math.max(this.layer1Width, image.getWidth());
                this.layer1Height = shaderType == ShaderType.FANCY ? Math.max(this.layer1Height, image.getHeight()) : this.layer1Height + image.getHeight();
            } else {
                this.layers2.add(image);
                this.layer2Width = shaderType == ShaderType.FANCY ? this.layer2Width + image.getWidth() : Math.max(this.layer2Width, image.getWidth());
                int n = this.layer2Height = shaderType == ShaderType.FANCY ? Math.max(this.layer2Height, image.getHeight()) : this.layer2Height + image.getHeight();
            }
            if (!isAnimated && image.getHeight() > this.getLayerHeight()) {
                Logs.logError("The height of " + name + " is greater than " + this.getLayerHeight() + "px.");
                Logs.logWarning("Since it is not an animated armor-file, this will potentially break other armor sets.");
                Logs.logWarning("Adjust the " + Settings.CUSTOM_ARMOR_SHADER_RESOLUTION.getPath() + " setting to fix this issue.");
                Logs.logWarning("If it is meant to be an animated armor-file, make sure it ends with _a.png or _a_e.png if emissive");
            }
        }
    }

    public boolean hasCustomArmors() {
        return !this.layers1.isEmpty() && !this.layers2.isEmpty() && this.layer1 != null && this.layer2 != null;
    }

    public InputStream getLayerOne() throws IOException {
        return this.getInputStream(this.layer1Width, this.layer1Height, this.layer1, this.layers1);
    }

    public InputStream getLayerTwo() throws IOException {
        return this.getInputStream(this.layer2Width, this.layer2Height, this.layer2, this.layers2);
    }

    private InputStream rescaleArmorImage(File original) {
        try {
            return this.rescaleArmorImage(Files.newInputStream(original.toPath().toAbsolutePath(), new OpenOption[0]));
        }
        catch (IOException e) {
            return null;
        }
    }

    private InputStream rescaleArmorImage(InputStream original) {
        BufferedImage img;
        try {
            img = ImageIO.read(original);
        }
        catch (IOException e) {
            OraxenPlugin.get().getLogger().warning("Error while reading InputStream: " + e.getMessage());
            return original;
        }
        try {
            img = this.rescaleArmorImage(img);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", os);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            ((InputStream)is).close();
            os.close();
            return is;
        }
        catch (IOException ignored) {
            return original;
        }
    }

    private BufferedImage rescaleArmorImage(BufferedImage original) {
        int width = this.resolution * 4;
        int height = this.resolution * 2;
        Image resizedImage = original.getScaledInstance(width, height, 1);
        BufferedImage outputImage = new BufferedImage(width, height, 2);
        outputImage.getGraphics().drawImage(resizedImage, 0, 0, null);
        return outputImage;
    }

    public int getAnimatedArmorFramerate() {
        try {
            return Integer.parseInt(Settings.CUSTOM_ARMOR_SHADER_ANIMATED_FRAMERATE.getValue().toString());
        }
        catch (NumberFormatException e) {
            return 24;
        }
    }

    public Set<VirtualFile> getOptifineFiles() throws FileNotFoundException {
        HashSet<VirtualFile> optifineFiles = new HashSet<VirtualFile>(this.generateLeatherArmors());
        for (Map.Entry<String, InputStream> armorFile : this.getAllArmors().entrySet()) {
            String fileName = armorFile.getKey();
            String parentFolder = StringUtils.substringBefore((String)fileName, (String)"_");
            String path = "assets/minecraft/optifine/cit/armors/" + parentFolder;
            optifineFiles.add(new VirtualFile(path, fileName, armorFile.getValue()));
            if (fileName.endsWith("_e.png") || optifineFiles.stream().map(VirtualFile::getPath).anyMatch(p -> Objects.equals(p, path + "/" + parentFolder + ".properties"))) continue;
            String colorProperty = "nbt.display.color=" + this.getArmorColor(parentFolder);
            String propContent = this.getArmorPropertyFile(fileName, colorProperty, 1);
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(propContent.getBytes(StandardCharsets.UTF_8));
                optifineFiles.add(new VirtualFile(path, parentFolder + ".properties", inputStream));
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!fileName.endsWith("_a.png")) continue;
            optifineFiles.addAll(this.getOptifineAnimFiles(armorFile.getValue(), fileName, parentFolder));
        }
        return optifineFiles;
    }

    private int getArmorColor(String parentFolder) {
        return OraxenItems.getEntries().stream().filter(e -> ((ItemBuilder)e.getValue()).build().getType().toString().startsWith("LEATHER_") && ((ItemBuilder)e.getValue()).hasOraxenMeta() && ((ItemBuilder)e.getValue()).getOraxenMeta().getLayers() != null && !((ItemBuilder)e.getValue()).getOraxenMeta().getLayers().isEmpty() && ((ItemBuilder)e.getValue()).getOraxenMeta().getLayers().get(0).contains(parentFolder)).map(s -> ((ItemBuilder)s.getValue()).getColor()).findFirst().orElse(Color.WHITE).asRGB();
    }

    private List<VirtualFile> getOptifineAnimFiles(InputStream armorFile, String fileName, String parentFolder) {
        int width;
        int height;
        ArrayList<VirtualFile> optifineFiles = new ArrayList<VirtualFile>();
        try {
            BufferedImage image = ImageIO.read(armorFile);
            height = image.getHeight();
            width = image.getWidth();
        }
        catch (IOException e) {
            Logs.logError("Error while reading " + fileName + ": " + e.getMessage());
            return optifineFiles;
        }
        String animPropContent = this.getOptifineArmorAnimPropertyFile(parentFolder, fileName, width, height, height / this.getLayerHeight());
        ByteArrayInputStream animInputStream = new ByteArrayInputStream(animPropContent.getBytes(StandardCharsets.UTF_8));
        optifineFiles.add(new VirtualFile("assets/minecraft/optifine/anim/" + parentFolder, parentFolder + "_anim.properties", animInputStream));
        optifineFiles.add(new VirtualFile("assets/minecraft/optifine/anim/" + parentFolder, fileName, armorFile));
        return optifineFiles;
    }

    private String getOptifineArmorAnimPropertyFile(String parentFolder, String fileName, int width, int height, int frames) {
        StringBuilder string = new StringBuilder("from=~/anim/" + fileName + "\nto=assets/minecraft/optifine/cit/armors/" + parentFolder + "/" + fileName + "\ny=0\nx=0\nh=" + height + "\nw=" + width + "\n");
        for (int i = 0; i < frames; ++i) {
            string.append("tile.").append(i).append("=").append(i).append("\n").append("duration.").append(i).append("=").append(this.getAnimatedArmorFramerate() / frames).append("\n");
        }
        return string.toString();
    }

    private List<VirtualFile> generateLeatherArmors() {
        ArrayList<VirtualFile> leatherArmors = new ArrayList<VirtualFile>();
        String absolute = OraxenPlugin.get().getDataFolder().getAbsolutePath() + "/pack/textures/models/armor";
        File leatherFile1 = new File(absolute, "/leather_layer_1.png");
        File leatherFile2 = new File(absolute, "/leather_layer_2.png");
        File leatherFileOverlay = new File(absolute, "/leather_layer_1_overlay.png");
        String leatherPath = "assets/minecraft/optifine/cit/armors/leather";
        if (!(leatherFile1.exists() && leatherFile2.exists() && leatherFileOverlay.exists())) {
            return leatherArmors;
        }
        leatherArmors.add(new VirtualFile(leatherPath, "leather_armor_layer_1.png", this.rescaleArmorImage(leatherFile1)));
        leatherArmors.add(new VirtualFile(leatherPath, "leather_armor_layer_2.png", this.rescaleArmorImage(leatherFile2)));
        leatherArmors.add(new VirtualFile(leatherPath, "leather_armor_overlay.png", this.rescaleArmorImage(leatherFileOverlay)));
        String content = this.correctLeatherPropertyFile(this.getArmorPropertyFile("leather_armor_layer_1.png", "", 0));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        leatherArmors.add(new VirtualFile(leatherPath, "leather.properties", inputStream));
        return leatherArmors;
    }

    private String correctLeatherPropertyFile(String content) {
        return content.replace("texture.leather_layer_1_overlay=leather_armor_layer_1.png", "texture.leather_layer_1_overlay=leather_armor_overlay.png").replace("texture.leather_layer_2_overlay=leather_armor_layer_2.png", "texture.leather_layer_2_overlay=leather_armor_overlay.png");
    }

    private String getArmorPropertyFile(String fileName, String cmdProperty, int weight) {
        return "type=armor\nitems=minecraft:leather_helmet minecraft:leather_chestplate minecraft:leather_leggings minecraft:leather_boots\ntexture.leather_layer_1=" + fileName.replace("_2.png", "_1.png") + "\ntexture.leather_layer_1_overlay=" + fileName.replace("_2.png", "_1.png") + "\ntexture.leather_layer_2=" + fileName.replace("_1.png", "_2.png") + "\ntexture.leather_layer_2_overlay=" + fileName.replace("_1.png", "_2.png") + "\n" + cmdProperty + "\nweight=" + weight;
    }

    private Map<String, InputStream> getAllArmors() {
        HashMap<String, InputStream> layers = new HashMap<String, InputStream>();
        for (Map.Entry<String, ItemBuilder> entry : OraxenItems.getEntries()) {
            String itemId = entry.getKey();
            ItemBuilder builder = entry.getValue();
            String armorType = StringUtils.substringBeforeLast((String)itemId, (String)"_");
            if (!builder.hasOraxenMeta()) continue;
            List<String> layerList = builder.getOraxenMeta().getLayers();
            boolean isArmor = builder.build().getType().toString().contains("LEATHER_");
            boolean inLayerList = layers.keySet().stream().anyMatch(s -> s.contains(armorType));
            if (!isArmor || inLayerList || !builder.hasOraxenMeta() || layerList == null || layerList.size() != 2) continue;
            for (String file : layerList) {
                File emissiveFile;
                int id = layers.keySet().stream().anyMatch(s -> s.contains(armorType)) ? 2 : 1;
                Object fileName = armorType + "_armor_layer_" + id + ".png";
                String absolutePath = OraxenPlugin.get().getDataFolder().getAbsolutePath() + "/pack/textures/";
                String fileFolder = absolutePath + StringUtils.substringBeforeLast((String)file, (String)itemId) + (String)fileName;
                File armorFile = new File(fileFolder);
                if (!armorFile.exists()) {
                    fileName = ((String)fileName).replace(".png", "_a.png");
                    armorFile = new File(fileFolder.replace(".png", "_a.png"));
                    if (!armorFile.exists()) continue;
                }
                try {
                    BufferedImage armorLayer = ImageIO.read(armorFile);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)armorLayer, "png", os);
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    layers.put((String)fileName, is);
                    os.close();
                    ((InputStream)is).close();
                }
                catch (IOException armorLayer) {
                    // empty catch block
                }
                if (!(emissiveFile = new File(fileFolder.replace(".png", "_e.png"))).exists()) continue;
                try {
                    BufferedImage armorLayer = ImageIO.read(emissiveFile);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)armorLayer, "png", os);
                    ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
                    layers.put(((String)fileName).replace(".png", "_e.png"), is);
                    os.close();
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return layers;
    }

    private static Map<String, Integer> getAllSpecifiedArmorColors() {
        HashMap<String, Integer> specifiedColors = new HashMap<String, Integer>();
        for (Map.Entry<String, ItemBuilder> entry : OraxenItems.getEntries()) {
            String itemId = entry.getKey();
            ItemBuilder builder = entry.getValue();
            if (!builder.build().getType().toString().contains("LEATHER_") || !builder.hasColor()) continue;
            specifiedColors.putIfAbsent(StringUtils.substringBeforeLast((String)itemId, (String)"_"), builder.getColor().asRGB());
        }
        return specifiedColors;
    }

    private InputStream getInputStream(int layerWidth, int layerHeight, BufferedImage layer, List<BufferedImage> layers) throws IOException {
        layers.add(0, layer);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)this.mergeImages(layerWidth, layerHeight, layers.toArray(new BufferedImage[0])), "png", outputStream);
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    private void setPixel(WritableRaster raster, int x, int y, Color color) {
        raster.setPixel(x, y, new int[]{color.getRed(), color.getGreen(), color.getBlue(), 255});
    }

    private BufferedImage mergeImages(int width, int height, BufferedImage ... images) {
        BufferedImage concatImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = concatImage.createGraphics();
        int currentWidth = 0;
        int currentHeight = 0;
        for (BufferedImage bufferedImage : images) {
            g2d.drawImage((Image)bufferedImage, currentWidth, currentHeight, null);
            if (shaderType == ShaderType.FANCY) {
                currentWidth += bufferedImage.getWidth();
                continue;
            }
            if (shaderType != ShaderType.LESS_FANCY) continue;
            currentHeight += bufferedImage.getHeight();
        }
        g2d.dispose();
        return concatImage;
    }

    public static void generateArmorShaderFiles() {
        if (shaderType == ShaderType.LESS_FANCY) {
            LessFancyArmorShaders.generateArmorShaderFiles();
        } else if (shaderType == ShaderType.FANCY) {
            FancyArmorShaders.generateArmorShaderFiles();
        }
    }

    public static enum ShaderType {
        FANCY,
        LESS_FANCY;

    }

    private static class LessFancyArmorShaders {
        private LessFancyArmorShaders() {
        }

        private static void generateArmorShaderFiles() {
            String shaders = "assets/minecraft/shaders";
            ResourcePack.writeStringToVirtual(shaders + "/core", "rendertype_armor_cutout_no_cull.json", LessFancyArmorShaders.getShaderJson());
            ResourcePack.writeStringToVirtual(shaders + "/core", "rendertype_outline.json", LessFancyArmorShaders.getOutlineJson());
            ResourcePack.writeStringToVirtual(shaders + "/core/render", "armor.vsh", LessFancyArmorShaders.getArmorVsh());
            ResourcePack.writeStringToVirtual(shaders + "/core/render", "armor.fsh", LessFancyArmorShaders.getArmorFsh());
            ResourcePack.writeStringToVirtual(shaders + "/core/render", "glowing.vsh", LessFancyArmorShaders.getGlowingVsh());
            ResourcePack.writeStringToVirtual(shaders + "/core/render", "glowing.fsh", LessFancyArmorShaders.getGlowingFsh());
            ResourcePack.writeStringToVirtual(shaders + "/include", "LICENSE.md", LessFancyArmorShaders.getFogGlsl());
        }

        public static String getShaderJson() {
            return "{\n     \"blend\": {\n         \"func\": \"add\",\n         \"srcrgb\": \"srcalpha\",\n         \"dstrgb\": \"1-srcalpha\"\n     },\n     \"vertex\": \"render/armor\",\n     \"fragment\": \"render/armor\",\n     \"attributes\": [\n         \"Position\",\n         \"Color\",\n         \"UV0\",\n         \"UV1\",\n         \"UV2\",\n         \"Normal\"\n     ],\n     \"samplers\": [\n         { \"name\": \"Sampler0\" },\n         { \"name\": \"Sampler1\" },\n         { \"name\": \"Sampler2\" }\n     ],\n     \"uniforms\": [\n         { \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n         { \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n         { \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n         { \"name\": \"Light0_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n         { \"name\": \"Light1_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n         { \"name\": \"FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n         { \"name\": \"FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n         { \"name\": \"FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] },\n         { \"name\": \"GameTime\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] }\n     ]\n }".trim();
        }

        public static String getOutlineJson() {
            return "{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"render/glowing\",\n    \"fragment\": \"render/glowing\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\"\n    ],\n    \"samplers\": [\n        { \"name\": \"Sampler0\" }\n    ],\n    \"uniforms\": [\n        { \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] }\n    ]\n}".trim();
        }

        public static String getArmorVsh() {
            return "#version 150\n\n#moj_import <light.glsl>\n#moj_import <fog.glsl>\n\nin vec3 Position;\nin vec4 Color;\nin vec2 UV0;\nin ivec2 UV1;\nin ivec2 UV2;\nin vec3 Normal;\n\nuniform sampler2D Sampler0;\nuniform sampler2D Sampler1;\nuniform sampler2D Sampler2;\n\nuniform mat4 ModelViewMat;\nuniform mat4 ProjMat;\nuniform mat3 IViewRotMat;\nuniform int FogShape;\n\nuniform vec3 Light0_Direction;\nuniform vec3 Light1_Direction;\n\nout float vertexDistance;\nout vec4 vertexColor;\nout vec4 tintColor;\nout vec4 lightColor;\nout vec4 overlayColor;\nout vec2 uv;\nout vec4 normal;\n\nint toint(vec3 c) {\n    ivec3 v = ivec3(c*255);\n    return (v.r<<16)+(v.g<<8)+v.b;\n}\n\nvoid main() {\n    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);\n\n    vertexDistance = fog_distance(ModelViewMat, IViewRotMat * Position, FogShape);\n    tintColor = Color;\n    vertexColor = minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, vec4(1));\n    lightColor = minecraft_sample_lightmap(Sampler2, UV2);\n    overlayColor = texelFetch(Sampler1, UV1, 0);\n    uv = UV0;\n    normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);\n\n    //number of armors from texture size\n    vec2 size = textureSize(Sampler0, 0);\n    int n = int(2*size.y/size.x);\n    //if theres more than 1 custom armor\n    if (n > 1 && size.x < 256) {\n        //divide uv by number of armors, it is now on the first armor\n        uv.y /= n;\n        //if color index is within number of armors\n        int i = toint(Color.rgb);\n        if (i < n) {\n            //move uv down to index\n            uv.y += i*size.x/size.y/2.;\n            //remove tint color\n            tintColor = vec4(1);\n        }\n    }\n}".trim();
        }

        public static String getArmorFsh() {
            return "#version 150\n\n#moj_import <fog.glsl>\n\nuniform sampler2D Sampler0;\n\nuniform vec4 ColorModulator;\nuniform float FogStart;\nuniform float FogEnd;\nuniform vec4 FogColor;\n\nin float vertexDistance;\nin vec4 vertexColor;\nin vec4 tintColor;\nin vec4 lightColor;\nin vec4 overlayColor;\nin vec2 uv;\nin vec4 normal;\n\nout vec4 fragColor;\n\nvoid main() {\n    vec4 color = texture(Sampler0, uv);\n    if (color.a < 0.1) discard;\n    color *= tintColor * ColorModulator;\n    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);\n    color *= vertexColor * lightColor; //shading\n    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);\n}".trim();
        }

        public static String getGlowingVsh() {
            return "#version 150\n\nuniform sampler2D Sampler0;\n\nin vec3 Position;\nin vec4 Color;\nin vec2 UV0;\n\nuniform mat4 ModelViewMat;\nuniform mat4 ProjMat;\n\nout vec4 vertexColor;\nout vec2 uv;\n\nvoid main() {\n    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);\n    vertexColor = Color;\n    uv = UV0;\n\n    //we assume if y >= 2x it is an armor and divide uv\n    //cannot pass tint color here so it's the only option\n    vec2 size = textureSize(Sampler0, 0);\n    if (size.y >= 2*size.x && size.x < 256) {\n        uv.y /= 2.*size.y/size.x;\n    }\n}".trim();
        }

        public static String getGlowingFsh() {
            return "#version 150\n\nuniform sampler2D Sampler0;\n\nuniform vec4 ColorModulator;\n\nin vec4 vertexColor;\nin vec2 uv;\n\nout vec4 fragColor;\n\nvoid main() {\n    vec4 color = texture(Sampler0, uv);\n    if (color.a == 0.0) discard;\n    fragColor = vec4(ColorModulator.rgb * vertexColor.rgb, ColorModulator.a);\n}".trim();
        }

        public static String getFogGlsl() {
            return "#version 150\n\nvec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {\n    if (vertexDistance <= fogStart) {\n        return inColor;\n    }\n    float fogValue = vertexDistance < fogEnd ? smoothstep(fogStart, fogEnd, vertexDistance) : 1.0;\n    return vec4(mix(inColor.rgb, fogColor.rgb, fogValue * fogColor.a), inColor.a);\n}\n\nfloat linear_fog_fade(float vertexDistance, float fogStart, float fogEnd) {\n    if (vertexDistance <= fogStart) {\n        return 1.0;\n    } else if (vertexDistance >= fogEnd) {\n        return 0.0;\n    }\n    return smoothstep(fogEnd, fogStart, vertexDistance);\n}\n\nfloat fog_distance(mat4 modelViewMat, vec3 pos, int shape) {\n    if (shape == 0) {\n        return length((modelViewMat * vec4(pos, 1.0)).xyz);\n    } else {\n        float distXZ = length((modelViewMat * vec4(pos.x, 0.0, pos.z, 1.0)).xyz);\n        float distY = length((modelViewMat * vec4(0.0, pos.y, 0.0, 1.0)).xyz);\n        return max(distXZ, distY);\n    }\n}".trim();
        }
    }

    private static class FancyArmorShaders {
        private FancyArmorShaders() {
        }

        private static void generateArmorShaderFiles() {
            String parent = "assets/minecraft/shaders/core/";
            String file = "rendertype_armor_cutout_no_cull";
            ResourcePack.writeStringToVirtual(parent, file + ".json", FancyArmorShaders.getShaderJson());
            ResourcePack.writeStringToVirtual(parent, file + ".vsh", FancyArmorShaders.getShaderVsh());
            ResourcePack.writeStringToVirtual(parent, file + ".fsh", FancyArmorShaders.getShaderFsh());
            ResourcePack.writeStringToVirtual(parent, "LICENSE.md", FancyArmorShaders.getLicense());
        }

        private static String getShaderVsh() {
            return "#version 150\n\n #moj_import <light.glsl>\n\n in vec3 Position;\n in vec4 Color;\n in vec2 UV0;\n in vec2 UV1;\n in ivec2 UV2;\n in vec3 Normal;\n\n uniform sampler2D Sampler2;\n\n uniform mat4 ModelViewMat;\n uniform mat4 ProjMat;\n\n uniform vec3 Light0_Direction;\n uniform vec3 Light1_Direction;\n\n out float vertexDistance;\n out vec4 vertexColor;\n out vec2 texCoord0;\n out vec2 texCoord1;\n out vec4 normal;\n flat out vec4 tint;\n flat out vec3 vNormal;\n flat out vec4 texel;\n\n void main() {\n     vNormal = Normal;\n     texel = texelFetch(Sampler2, UV2 / 16, 0);\n     gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);\n\n     vertexDistance = length((ModelViewMat * vec4(Position, 1.0)).xyz);\n     vertexColor = minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, Color) * texelFetch(Sampler2, UV2 / 16, 0);\n     tint = Color;\n     texCoord0 = UV0;\n     texCoord1 = UV1;\n     normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);\n }\n".trim();
        }

        private static String getShaderFsh() {
            return "#version 150\n\n #moj_import <fog.glsl>\n #moj_import <light.glsl>\n\n #define TEX_RES {#TEXTURE_RESOLUTION#}\n #define ANIM_SPEED 50 // Runs every 24 seconds\n #define IS_LEATHER_LAYER texelFetch(Sampler0, ivec2(0, 1), 0) == vec4(1) // If it's leather_layer_X.png texture\n\n uniform sampler2D Sampler0;\n\n uniform vec4 ColorModulator;\n uniform float FogStart;\n uniform float FogEnd;\n uniform vec4 FogColor;\n uniform float GameTime;\n uniform vec3 Light0_Direction;\n uniform vec3 Light1_Direction;\n\n in float vertexDistance;\n in vec4 vertexColor;\n in vec2 texCoord0;\n in vec2 texCoord1;\n in vec4 normal;\n flat in vec4 tint;\n flat in vec3 vNormal;\n flat in vec4 texel;\n\n out vec4 fragColor;\n\n void main()\n {\n     ivec2 atlasSize = textureSize(Sampler0, 0);\n     float armorAmount = atlasSize.x / (TEX_RES * 4.0);\n     float maxFrames = atlasSize.y / (TEX_RES * 2.0);\n\n     vec2 coords = texCoord0;\n     coords.x /= armorAmount;\n     coords.y /= maxFrames;\n\n     vec4 color;\n\n     if(IS_LEATHER_LAYER)\n     {\n         // Texture properties contains extra info about the armor texture, such as to enable shading\n         vec4 textureProperties = vec4(0);\n         vec4 customColor = vec4(0);\n\n         float h_offset = 1.0 / armorAmount;\n         vec2 nextFrame = vec2(0);\n         float interpolClock = 0;\n         vec4 vtc = vertexColor;\n\n         for (int i = 1; i < (armorAmount + 1); i++)\n         {\n             customColor = texelFetch(Sampler0, ivec2(TEX_RES * 4 * i + 0.5, 0), 0);\n             if (tint == customColor){\n\n                 coords.x += (h_offset * i);\n                 vec4 animInfo = texelFetch(Sampler0, ivec2(TEX_RES * 4 * i + 1.5, 0), 0);\n                 animInfo.rgb *= animInfo.a * 255;\n                 textureProperties = texelFetch(Sampler0, ivec2(TEX_RES * 4 * i + 2.5, 0), 0);\n                 textureProperties.rgb *= textureProperties.a * 255;\n                 if (animInfo != vec4(0))\n                 {\n                     // oh god it's animated\n                     // animInfo = amount of frames, speed, interpolation (1||0)\n                     // textureProperties = emissive, tint\n                     // fract(GameTime * 1200) blinks every second so [0,1] every second\n                     float timer = floor(mod(GameTime * ANIM_SPEED * animInfo.g, animInfo.r));\n                     if (animInfo.b > 0)\n                         interpolClock = fract(GameTime * ANIM_SPEED * animInfo.g);\n                     float v_offset = (TEX_RES * 2.0) / atlasSize.y * timer;\n                     nextFrame = coords;\n                     coords.y += v_offset;\n                     nextFrame.y += (TEX_RES * 2.0) / atlasSize.y * mod(timer + 1, animInfo.r);\n                 }\n                 break;\n             }\n         }\n\n         if (textureProperties.g == 1)\n         {\n             if (textureProperties.r > 1)\n             {\n                 vtc = tint;\n             }\n             else if (textureProperties.r == 1)\n             {\n                 if (texture(Sampler0, vec2(coords.x + h_offset, coords.y)).a != 0)\n                 {\n                     vtc = tint * texture(Sampler0, vec2(coords.x + h_offset, coords.y)).a;\n                 }\n             }\n         }\n         else if(textureProperties.g == 0)\n         {\n             if (textureProperties.r > 1)\n             {\n                 vtc = vec4(1);\n             }\n             else if (textureProperties.r == 1)\n             {\n                 if (texture(Sampler0, vec2(coords.x + h_offset, coords.y)).a != 0)\n                 {\n                     vtc = vec4(1) * texture(Sampler0, vec2(coords.x + h_offset, coords.y)).a;\n                 }\n                 else\n                 {\n                     vtc = minecraft_mix_light(Light0_Direction, Light1_Direction, vNormal, vec4(1)) * texel;\n                 }\n             }\n             else\n             {\n                 vtc = minecraft_mix_light(Light0_Direction, Light1_Direction, vNormal, vec4(1)) * texel;\n             }\n         }\n         else\n         {\n             vtc = minecraft_mix_light(Light0_Direction, Light1_Direction, vNormal, vec4(1)) * texel;\n         }\n\n         vec4 armor = mix(texture(Sampler0, coords), texture(Sampler0, nextFrame), interpolClock);\n\n         // If it's the first leather texture in the atlas (used for the vanilla leather texture, with no custom color specified)\n         if (coords.x < (1 / armorAmount))\n             color = armor * vertexColor * ColorModulator;\n         else // If it's a custom texture\n             color = armor * vtc * ColorModulator;\n     }\n     else // If it's another vanilla armor, for example diamond_layer_1.png or diamond_layer_2.png\n     {\n         color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;\n     }\n\n     if (color.a < 0.1)\n         discard;\n\n     fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);\n }\n".replace(ShaderArmorTextures.SHADER_PARAMETER_PLACEHOLDER, String.valueOf((Integer)Settings.CUSTOM_ARMOR_SHADER_RESOLUTION.getValue())).trim();
        }

        private static String getShaderJson() {
            return "{\n     \"blend\": {\n         \"func\": \"add\",\n         \"srcrgb\": \"srcalpha\",\n         \"dstrgb\": \"1-srcalpha\"\n     },\n     \"vertex\": \"rendertype_armor_cutout_no_cull\",\n     \"fragment\": \"rendertype_armor_cutout_no_cull\",\n     \"attributes\": [\n         \"Position\",\n         \"Color\",\n         \"UV0\",\n         \"UV1\",\n         \"UV2\",\n         \"Normal\"\n     ],\n     \"samplers\": [\n         { \"name\": \"Sampler0\" },\n         { \"name\": \"Sampler2\" }\n     ],\n     \"uniforms\": [\n         { \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n         { \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n         { \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n         { \"name\": \"Light0_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n         { \"name\": \"Light1_Direction\", \"type\": \"float\", \"count\": 3, \"values\": [0.0, 0.0, 0.0] },\n         { \"name\": \"FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n         { \"name\": \"FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n         { \"name\": \"FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] },\n         { \"name\": \"GameTime\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] }\n     ]\n }\n".trim();
        }

        private static String getLicense() {
            return "Author of this shader is Ancientkingg\n\nThis allowed to commercially use with reference to original author.\nOriginal license: https://github.com/Ancientkingg/fancyPants/blob/master/README.md\n".trim();
        }
    }
}

