/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.generation;

import com.comphenix.protocol.events.PacketListener;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.api.events.OraxenPackGeneratedEvent;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.ResourcesManager;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.font.Font;
import io.th0rgal.oraxen.font.FontManager;
import io.th0rgal.oraxen.font.Glyph;
import io.th0rgal.oraxen.font.packets.ScoreboardPacketListener;
import io.th0rgal.oraxen.gestures.GestureManager;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.OraxenMeta;
import io.th0rgal.oraxen.pack.generation.AtlasGenerator;
import io.th0rgal.oraxen.pack.generation.DuplicationHandler;
import io.th0rgal.oraxen.pack.generation.ModelGenerator;
import io.th0rgal.oraxen.pack.generation.PackSlicer;
import io.th0rgal.oraxen.pack.generation.PredicatesGenerator;
import io.th0rgal.oraxen.pack.upload.UploadManager;
import io.th0rgal.oraxen.sound.CustomSound;
import io.th0rgal.oraxen.sound.SoundManager;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.PluginUtils;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.VirtualFile;
import io.th0rgal.oraxen.utils.ZipUtils;
import io.th0rgal.oraxen.utils.customarmor.CustomArmorType;
import io.th0rgal.oraxen.utils.customarmor.ShaderArmorTextures;
import io.th0rgal.oraxen.utils.customarmor.TrimArmorDatapack;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ResourcePack {
    private final Map<String, Collection<Consumer<File>>> packModifiers;
    private static Map<String, VirtualFile> outputFiles;
    private ShaderArmorTextures shaderArmorTextures;
    private TrimArmorDatapack trimArmorDatapack;
    private static final File packFolder;
    private final File pack = new File(packFolder, packFolder.getName() + ".zip");
    private final boolean extractAssets = !new File(packFolder, "assets").exists();
    private final boolean extractModels = !new File(packFolder, "models").exists();
    private final boolean extractFonts = !new File(packFolder, "font").exists();
    private final boolean extractOptifine = !new File(packFolder, "optifine").exists();
    private final boolean extractLang = !new File(packFolder, "lang").exists();
    private final boolean extractTextures = !new File(packFolder, "textures").exists();
    private final boolean extractSounds = !new File(packFolder, "sounds").exists();
    private static final Set<String> availableLanguageCodes;

    public ResourcePack() {
        this.packModifiers = new HashMap<String, Collection<Consumer<File>>>();
        outputFiles = new HashMap<String, VirtualFile>();
    }

    public void generate() {
        outputFiles.clear();
        this.makeDirsIfNotExists(packFolder, new File(packFolder, "assets"));
        this.trimArmorDatapack = CustomArmorType.getSetting() == CustomArmorType.TRIMS ? new TrimArmorDatapack() : null;
        this.shaderArmorTextures = CustomArmorType.getSetting() == CustomArmorType.SHADER ? new ShaderArmorTextures() : null;
        if (Settings.GENERATE_DEFAULT_ASSETS.toBool().booleanValue()) {
            this.extractDefaultFolders();
        }
        this.extractRequired();
        if (!Settings.GENERATE.toBool().booleanValue()) {
            return;
        }
        if (Settings.HIDE_SCOREBOARD_NUMBERS.toBool().booleanValue() && PluginUtils.isEnabled("HappyHUD")) {
            Logs.logError("HappyHUD detected with hide_scoreboard_numbers enabled!");
            Logs.logWarning("Recommend following this guide for compatibility: https://docs.oraxen.com/compatibility/happyhud");
        }
        try {
            Files.deleteIfExists(this.pack.toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.extractInPackIfNotExists(new File(packFolder, "pack.mcmeta"));
        this.extractInPackIfNotExists(new File(packFolder, "pack.png"));
        this.generatePredicates(this.extractTexturedItems());
        this.generateFont();
        if (Settings.GESTURES_ENABLED.toBool().booleanValue()) {
            this.generateGestureFiles();
        }
        if (Settings.HIDE_SCOREBOARD_NUMBERS.toBool().booleanValue()) {
            this.hideScoreboardNumbers();
        }
        if (Settings.HIDE_SCOREBOARD_BACKGROUND.toBool().booleanValue()) {
            this.generateScoreboardHideBackground();
        }
        if (Settings.TEXTURE_SLICER.toBool().booleanValue()) {
            PackSlicer.slicePackFiles();
        }
        if (CustomArmorType.getSetting() == CustomArmorType.SHADER && Settings.CUSTOM_ARMOR_SHADER_GENERATE_FILES.toBool().booleanValue()) {
            ShaderArmorTextures.generateArmorShaderFiles();
        }
        for (Collection<Consumer<File>> packModifiers : this.packModifiers.values()) {
            for (Consumer<File> packModifier : packModifiers) {
                packModifier.accept(packFolder);
            }
        }
        ArrayList<VirtualFile> output = new ArrayList<VirtualFile>(outputFiles.values());
        try {
            this.getFilesInFolder(packFolder, output, packFolder.getCanonicalPath(), packFolder.getName() + ".zip");
            File[] files = packFolder.listFiles();
            if (files != null) {
                for (File folder : files) {
                    if (folder.isDirectory() && folder.getName().equalsIgnoreCase("assets")) {
                        this.getAllFiles(folder, output, "", new String[0]);
                        continue;
                    }
                    if (!folder.isDirectory()) continue;
                    this.getAllFiles(folder, output, "assets/minecraft", new String[0]);
                }
            }
            this.convertGlobalLang(output);
            this.handleCustomArmor(output);
            Collections.sort(output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashSet<String> malformedTextures = new HashSet();
        if (Settings.VERIFY_PACK_FILES.toBool().booleanValue()) {
            malformedTextures = ResourcePack.verifyPackFormatting(output);
        }
        if (Settings.GENERATE_ATLAS_FILE.toBool().booleanValue()) {
            AtlasGenerator.generateAtlasFile(output, malformedTextures);
        }
        if (Settings.MERGE_DUPLICATE_FONTS.toBool().booleanValue()) {
            DuplicationHandler.mergeFontFiles(output);
        }
        if (Settings.MERGE_ITEM_MODELS.toBool().booleanValue()) {
            DuplicationHandler.mergeBaseItemFiles(output);
        }
        List<String> excludedExtensions = Settings.EXCLUDED_FILE_EXTENSIONS.toStringList();
        excludedExtensions.removeIf(f -> f.equals("png") || f.equals("json"));
        if (!excludedExtensions.isEmpty() && !output.isEmpty()) {
            ArrayList<VirtualFile> newOutput = new ArrayList<VirtualFile>();
            for (VirtualFile virtual : output) {
                for (String extension : excludedExtensions) {
                    if (!virtual.getPath().endsWith(extension)) continue;
                    newOutput.add(virtual);
                }
            }
            output.removeAll(newOutput);
        }
        this.generateSound(output);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OraxenPlugin.get(), () -> {
            OraxenPackGeneratedEvent event = new OraxenPackGeneratedEvent(output);
            EventUtils.callEvent(event);
            ZipUtils.writeZipFile(this.pack, event.getOutput());
            UploadManager uploadManager = OraxenPlugin.get().getUploadManager();
            if (uploadManager != null) {
                uploadManager.uploadAsyncAndSendToPlayers(OraxenPlugin.get().getResourcePack(), true, true);
            } else {
                uploadManager = new UploadManager((Plugin)OraxenPlugin.get());
                OraxenPlugin.get().setUploadManager(uploadManager);
                uploadManager.uploadAsyncAndSendToPlayers(OraxenPlugin.get().getResourcePack(), false, false);
            }
        });
    }

    private static Set<String> verifyPackFormatting(List<VirtualFile> output) {
        Logs.logInfo("Verifying formatting for textures and models...");
        HashSet<VirtualFile> textures = new HashSet<VirtualFile>();
        HashSet<String> texturePaths = new HashSet<String>();
        HashSet<String> mcmeta = new HashSet<String>();
        HashSet<VirtualFile> models = new HashSet<VirtualFile>();
        HashSet<VirtualFile> malformedTextures = new HashSet<VirtualFile>();
        HashSet<VirtualFile> malformedModels = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile : output) {
            String path = virtualFile.getPath();
            if (path.matches("assets/.*/models/.*.json")) {
                models.add(virtualFile);
                continue;
            }
            if (path.matches("assets/.*/textures/.*.png.mcmeta")) {
                mcmeta.add(path);
                continue;
            }
            if (!path.matches("assets/.*/textures/.*.png")) continue;
            textures.add(virtualFile);
            texturePaths.add(path);
        }
        if (models.isEmpty() && !textures.isEmpty()) {
            return Collections.emptySet();
        }
        for (VirtualFile model : models) {
            JsonObject jsonModel;
            String content;
            if (!model.getPath().matches("[a-z0-9/._-]+")) {
                Logs.logWarning("Found invalid model at <blue>" + model.getPath());
                Logs.logError("Model-paths must only contain characters [a-z0-9/._-]");
                malformedModels.add(model);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream inputStream = model.getInputStream();
            try {
                inputStream.transferTo(baos);
                content = baos.toString(StandardCharsets.UTF_8);
                baos.close();
                inputStream.reset();
                inputStream.close();
            }
            catch (IOException e) {
                content = "";
            }
            if (content.isEmpty()) continue;
            try {
                jsonModel = JsonParser.parseString((String)content).getAsJsonObject();
            }
            catch (JsonSyntaxException e) {
                Logs.logError("Found malformed json at <red>" + model.getPath() + "</red>");
                e.printStackTrace();
                continue;
            }
            if (!jsonModel.has("textures")) continue;
            for (JsonElement element : jsonModel.getAsJsonObject("textures").entrySet().stream().map(Map.Entry::getValue).toList()) {
                String jsonTexture = element.getAsString();
                if (texturePaths.contains(ResourcePack.modelPathToPackPath(jsonTexture)) || jsonTexture.startsWith("#") || jsonTexture.startsWith("item/") || jsonTexture.startsWith("block/") || jsonTexture.startsWith("entity/") || Material.matchMaterial((String)Utils.getFileNameOnly(jsonTexture).toUpperCase()) != null) continue;
                Logs.logWarning("Found invalid texture-path inside model-file <blue>" + model.getPath() + "</blue>: " + jsonTexture);
                Logs.logWarning("Verify that you have a texture in said path.", true);
                malformedModels.add(model);
            }
        }
        for (VirtualFile texture : textures) {
            BufferedImage image;
            if (!texture.getPath().matches("[a-z0-9/._-]+")) {
                Logs.logWarning("Found invalid texture at <blue>" + texture.getPath());
                Logs.logError("Texture-paths must only contain characters [a-z0-9/._-]");
                malformedTextures.add(texture);
            }
            if (texture.getPath().matches(".*_layer_.*.png") || mcmeta.contains(texture.getPath() + ".mcmeta")) continue;
            InputStream inputStream = texture.getInputStream();
            try {
                image = ImageIO.read(new File("fake_file.png"));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                inputStream.transferTo(baos);
                ImageIO.write((RenderedImage)image, "png", baos);
                baos.close();
                inputStream.reset();
                inputStream.close();
            }
            catch (IOException e) {
                continue;
            }
            if (image.getHeight() <= 256 && image.getWidth() <= 256) continue;
            Logs.logWarning("Found invalid texture at <blue>" + texture.getPath());
            Logs.logError("Resolution of textures cannot exceed 256x256");
            malformedTextures.add(texture);
        }
        if (!malformedTextures.isEmpty() || !malformedModels.isEmpty()) {
            Logs.logError("Pack contains malformed texture(s) and/or model(s)");
            Logs.logError("These need to be fixed, otherwise the resourcepack will be broken", true);
        } else {
            Logs.logSuccess("No broken models or textures were found in the resourcepack", true);
        }
        Set<String> malformedFiles = malformedTextures.stream().map(VirtualFile::getPath).collect(Collectors.toSet());
        malformedFiles.addAll(malformedModels.stream().map(VirtualFile::getPath).collect(Collectors.toSet()));
        return malformedFiles;
    }

    private static String modelPathToPackPath(String modelPath) {
        String namespace = modelPath.split(":").length == 1 ? "minecraft" : modelPath.split(":")[0];
        Object texturePath = modelPath.split(":").length == 1 ? modelPath : modelPath.split(":")[1];
        texturePath = ((String)texturePath).endsWith(".png") ? texturePath : (String)texturePath + ".png";
        return "assets/" + namespace + "/textures/" + (String)texturePath;
    }

    private void extractDefaultFolders() {
        ZipInputStream zip = ResourcesManager.browse();
        try {
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                this.extract(entry, OraxenPlugin.get().getResourceManager(), this.isSuitable(entry.getName()));
                entry = zip.getNextEntry();
            }
            zip.closeEntry();
            zip.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private boolean isSuitable(String entryName) {
        String name = StringUtils.substringAfter((String)entryName, (String)"pack/").split("/")[0];
        if (name.equals("textures") && this.extractTextures) {
            return true;
        }
        if (name.equals("models") && this.extractModels) {
            return true;
        }
        if (name.equals("font") && this.extractFonts) {
            return true;
        }
        if (name.equals("optifine") && this.extractOptifine) {
            return true;
        }
        if (name.equals("lang") && this.extractLang) {
            return true;
        }
        if (name.equals("sounds") && this.extractSounds) {
            return true;
        }
        return name.equals("assets") && this.extractAssets;
    }

    private void extractRequired() {
        ZipInputStream zip = ResourcesManager.browse();
        try {
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (entry.getName().startsWith("pack/textures/models/armor/leather_layer_") || entry.getName().startsWith("pack/textures/required") || entry.getName().startsWith("pack/models/required")) {
                    OraxenPlugin.get().getResourceManager().extractFileIfTrue(entry, !OraxenPlugin.get().getDataFolder().toPath().resolve(entry.getName()).toFile().exists());
                }
                entry = zip.getNextEntry();
            }
            zip.closeEntry();
            zip.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void extract(ZipEntry entry, ResourcesManager resourcesManager, boolean isSuitable) {
        String name = entry.getName();
        resourcesManager.extractFileIfTrue(entry, isSuitable);
    }

    private Map<Material, List<ItemBuilder>> extractTexturedItems() {
        HashMap<Material, List<ItemBuilder>> texturedItems = new HashMap<Material, List<ItemBuilder>>();
        for (Map.Entry<String, ItemBuilder> entry : OraxenItems.getEntries()) {
            List items;
            ItemBuilder item = entry.getValue();
            OraxenMeta oraxenMeta = item.getOraxenMeta();
            if (!item.hasOraxenMeta() || !oraxenMeta.hasPackInfos()) continue;
            if (oraxenMeta.shouldGenerateModel()) {
                ResourcePack.writeStringToVirtual(oraxenMeta.getModelPath(), item.getOraxenMeta().getModelName() + ".json", new ModelGenerator(oraxenMeta).getJson().toString());
            }
            if ((items = (List)texturedItems.getOrDefault(item.build().getType(), new ArrayList())).isEmpty()) {
                items.add(item);
            } else {
                for (int i = 0; i < items.size(); ++i) {
                    if (((ItemBuilder)items.get(i)).getOraxenMeta().getCustomModelData() > item.getOraxenMeta().getCustomModelData()) {
                        items.add(i, item);
                        break;
                    }
                    if (i != items.size() - 1) continue;
                    items.add(item);
                    break;
                }
            }
            texturedItems.put(item.build().getType(), items);
        }
        return texturedItems;
    }

    @SafeVarargs
    public final void addModifiers(String groupName, Consumer<File> ... modifiers) {
        this.packModifiers.put(groupName, Arrays.asList(modifiers));
    }

    public static void addOutputFiles(VirtualFile ... files) {
        for (VirtualFile file : files) {
            outputFiles.put(file.getPath(), file);
        }
    }

    public File getFile() {
        return this.pack;
    }

    public File getPackFolder() {
        return packFolder;
    }

    private void extractInPackIfNotExists(File file) {
        if (!file.exists()) {
            OraxenPlugin.get().saveResource("pack/" + file.getName(), true);
        }
    }

    private void makeDirsIfNotExists(File ... folders) {
        for (File folder : folders) {
            if (folder.exists()) continue;
            folder.mkdirs();
        }
    }

    private void generatePredicates(Map<Material, List<ItemBuilder>> texturedItems) {
        for (Map.Entry<Material, List<ItemBuilder>> texturedItemsEntry : texturedItems.entrySet()) {
            Material entryMaterial = texturedItemsEntry.getKey();
            PredicatesGenerator predicatesGenerator = new PredicatesGenerator(entryMaterial, texturedItemsEntry.getValue());
            String[] vanillaModelPath = (predicatesGenerator.getVanillaModelName(entryMaterial) + ".json").split("/");
            ResourcePack.writeStringToVirtual("assets/minecraft/models/" + vanillaModelPath[0], vanillaModelPath[1], predicatesGenerator.toJSON().toString());
        }
    }

    private void generateFont() {
        FontManager fontManager = OraxenPlugin.get().getFontManager();
        if (!fontManager.autoGenerate) {
            return;
        }
        JsonObject output = new JsonObject();
        JsonArray providers = new JsonArray();
        for (Glyph glyph : fontManager.getGlyphs()) {
            if (glyph.hasBitmap()) continue;
            providers.add((JsonElement)glyph.toJson());
        }
        for (FontManager.GlyphBitMap glyphBitMap : FontManager.glyphBitMaps.values()) {
            providers.add((JsonElement)glyphBitMap.toJson(fontManager));
        }
        for (Font font : fontManager.getFonts()) {
            providers.add((JsonElement)font.toJson());
        }
        output.add("providers", (JsonElement)providers);
        ResourcePack.writeStringToVirtual("assets/minecraft/font", "default.json", output.toString());
        if (Settings.FIX_FORCE_UNICODE_GLYPHS.toBool().booleanValue()) {
            ResourcePack.writeStringToVirtual("assets/minecraft/font", "uniform.json", output.toString());
        }
    }

    private void generateSound(List<VirtualFile> output) {
        SoundManager soundManager = OraxenPlugin.get().getSoundManager();
        if (!soundManager.isAutoGenerate()) {
            return;
        }
        List<VirtualFile> soundFiles = output.stream().filter(file -> file.getPath().equals("assets/minecraft/sounds.json")).toList();
        JsonObject outputJson = new JsonObject();
        for (VirtualFile soundFile : soundFiles) {
            block9: {
                if (soundFile != null) {
                    try {
                        JsonElement soundElement = JsonParser.parseString((String)IOUtils.toString((InputStream)soundFile.getInputStream(), (Charset)StandardCharsets.UTF_8));
                        if (soundElement == null || !soundElement.isJsonObject()) break block9;
                        for (Map.Entry entry : soundElement.getAsJsonObject().entrySet()) {
                            outputJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
            }
            output.remove(soundFile);
        }
        for (CustomSound sound : this.handleCustomSoundEntries(soundManager.getCustomSounds())) {
            outputJson.add(sound.getName(), (JsonElement)sound.toJson());
        }
        ByteArrayInputStream soundInput = new ByteArrayInputStream(outputJson.toString().getBytes(StandardCharsets.UTF_8));
        output.add(new VirtualFile("assets/minecraft", "sounds.json", soundInput));
        try {
            ((InputStream)soundInput).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateGestureFiles() {
        GestureManager gestureManager = OraxenPlugin.get().getGesturesManager();
        for (Map.Entry<String, String> entry : gestureManager.getPlayerHeadJsons().entrySet()) {
            ResourcePack.writeStringToVirtual(StringUtils.removeEnd((String)Utils.getParentDirs(entry.getKey()), (String)"/"), Utils.removeParentDirs(entry.getKey()), entry.getValue());
        }
        ResourcePack.writeStringToVirtual("assets/minecraft/models/item", "player_head.json", gestureManager.getSkullJson());
        ResourcePack.writeStringToVirtual("assets/minecraft/shaders/core", "rendertype_entity_translucent.vsh", gestureManager.getShaderVsh());
        ResourcePack.writeStringToVirtual("assets/minecraft/shaders/core", "rendertype_entity_translucent.fsh", gestureManager.getShaderFsh());
        ResourcePack.writeStringToVirtual("assets/minecraft/shaders/core", "rendertype_entity_translucent.json", gestureManager.getShaderJson());
    }

    private Collection<CustomSound> handleCustomSoundEntries(Collection<CustomSound> sounds) {
        YamlConfiguration mechanic = OraxenPlugin.get().getConfigsManager().getMechanics();
        ConfigurationSection customSounds = mechanic.getConfigurationSection("custom_block_sounds");
        ConfigurationSection noteblock = mechanic.getConfigurationSection("noteblock");
        ConfigurationSection stringblock = mechanic.getConfigurationSection("stringblock");
        ConfigurationSection furniture = mechanic.getConfigurationSection("furniture");
        ConfigurationSection block = mechanic.getConfigurationSection("block");
        if (customSounds == null) {
            sounds.removeIf(s -> s.getName().startsWith("required.wood") || s.getName().startsWith("block.wood"));
            sounds.removeIf(s -> s.getName().startsWith("required.stone") || s.getName().startsWith("block.stone"));
        } else {
            if (!customSounds.getBoolean("noteblock_and_block", true)) {
                sounds.removeIf(s -> s.getName().startsWith("required.wood") || s.getName().startsWith("block.wood"));
            }
            if (!customSounds.getBoolean("stringblock_and_furniture", true)) {
                sounds.removeIf(s -> s.getName().startsWith("required.stone") || s.getName().startsWith("block.stone"));
            }
            if (noteblock != null && !noteblock.getBoolean("enabled", true) && block != null && !block.getBoolean("enabled", false)) {
                sounds.removeIf(s -> s.getName().startsWith("required.wood") || s.getName().startsWith("block.wood"));
            }
            if (stringblock != null && !stringblock.getBoolean("enabled", true) && furniture != null && !furniture.getBoolean("enabled", true)) {
                sounds.removeIf(s -> s.getName().startsWith("required.stone") || s.getName().startsWith("block.stone"));
            }
        }
        sounds.removeIf(s -> s.getName().equals("required") || s.getName().equals("block") || s.getName().equals("block.wood") || s.getName().equals("block.stone") || s.getName().equals("required.wood") || s.getName().equals("required.stone"));
        return sounds;
    }

    public static void writeStringToVirtual(String folder, String name, String content) {
        folder = !folder.endsWith("/") ? folder : folder.substring(0, folder.length() - 1);
        ResourcePack.addOutputFiles(new VirtualFile(folder, name, new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8))));
    }

    private void getAllFiles(File dir, Collection<VirtualFile> fileList, String newFolder, String ... excluded) {
        File[] files = dir.listFiles();
        List<String> blacklist = Arrays.asList(excluded);
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.getAllFiles(file, fileList, newFolder, excluded);
                    continue;
                }
                if (file.isDirectory() || blacklist.contains(file.getName())) continue;
                this.readFileToVirtuals(fileList, file, newFolder);
            }
        }
    }

    private void getFilesInFolder(File dir, Collection<VirtualFile> fileList, String newFolder, String ... excluded) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory() || Arrays.asList(excluded).contains(file.getName())) continue;
                this.readFileToVirtuals(fileList, file, newFolder);
            }
        }
    }

    private void readFileToVirtuals(Collection<VirtualFile> output, File file, String newFolder) {
        try {
            InputStream fis;
            if (file.getName().endsWith(".json")) {
                fis = this.processJsonFile(file);
            } else {
                if (CustomArmorType.getSetting() == CustomArmorType.SHADER && this.shaderArmorTextures.registerImage(file)) {
                    return;
                }
                fis = new FileInputStream(file);
            }
            output.add(new VirtualFile(this.getZipFilePath(file.getParentFile().getCanonicalPath(), newFolder), file.getName(), fis));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InputStream processJsonFile(File file) throws IOException {
        String content;
        if (!file.exists()) {
            return new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8));
        }
        try {
            content = Files.readString(file.toPath(), StandardCharsets.UTF_8);
        }
        catch (IOException | NullPointerException e) {
            Logs.logError("Error while reading file " + file.getPath());
            Logs.logError("It seems to be malformed!");
            ByteArrayInputStream newStream = new ByteArrayInputStream("".getBytes(StandardCharsets.UTF_8));
            ((InputStream)newStream).close();
            return newStream;
        }
        if (file.getPath().replace("\\", "/").split("assets/.*/font/").length > 1) {
            return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        }
        return this.processJson(content);
    }

    private InputStream processJson(String content) {
        String parsedContent = AdventureUtils.parseMiniMessage(AdventureUtils.parseLegacy(content), AdventureUtils.tagResolver("prefix", Message.PREFIX.toString()));
        parsedContent = AdventureUtils.parseLegacyThroughMiniMessage(content);
        ByteArrayInputStream newStream = new ByteArrayInputStream(parsedContent.getBytes(StandardCharsets.UTF_8));
        try {
            ((InputStream)newStream).close();
        }
        catch (IOException e) {
            return new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        }
        return newStream;
    }

    private String getZipFilePath(String path, String newFolder) throws IOException {
        if (newFolder.equals(packFolder.getCanonicalPath())) {
            return "";
        }
        Object prefix = newFolder.isEmpty() ? newFolder : newFolder + "/";
        return (String)prefix + path.substring(packFolder.getCanonicalPath().length() + 1);
    }

    private void handleCustomArmor(List<VirtualFile> output) {
        CustomArmorType customArmorType = CustomArmorType.getSetting();
        TrimArmorDatapack.clearOldDataPacks();
        switch (customArmorType) {
            case TRIMS: {
                this.trimArmorDatapack.generateTrimAssets(output);
                break;
            }
            case SHADER: {
                if (!Settings.CUSTOM_ARMOR_SHADER_GENERATE_CUSTOM_TEXTURES.toBool().booleanValue() || !this.shaderArmorTextures.hasCustomArmors()) break;
                try {
                    String armorPath = "assets/minecraft/textures/models/armor";
                    output.add(new VirtualFile(armorPath, "leather_layer_1.png", this.shaderArmorTextures.getLayerOne()));
                    output.add(new VirtualFile(armorPath, "leather_layer_2.png", this.shaderArmorTextures.getLayerTwo()));
                    if (!Settings.CUSTOM_ARMOR_SHADER_GENERATE_SHADER_COMPATIBLE_ARMOR.toBool().booleanValue()) break;
                    output.addAll(this.shaderArmorTextures.getOptifineFiles());
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void convertGlobalLang(List<VirtualFile> output) {
        Logs.logWarning("Converting global lang file to individual language files...");
        HashSet<VirtualFile> virtualLangFiles = new HashSet<VirtualFile>();
        File globalLangFile = new File(packFolder, "lang/global.json");
        JsonObject globalLang = new JsonObject();
        String content = "";
        if (!globalLangFile.exists()) {
            OraxenPlugin.get().saveResource("pack/lang/global.json", false);
        }
        try {
            content = Files.readString(globalLangFile.toPath(), StandardCharsets.UTF_8);
            globalLang = JsonParser.parseString((String)content).getAsJsonObject();
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            // empty catch block
        }
        if (content.isEmpty() || globalLang.isJsonNull()) {
            return;
        }
        for (String lang : availableLanguageCodes) {
            File langFile = new File(packFolder, "lang/" + lang + ".json");
            JsonObject langJson = new JsonObject();
            if (langFile.exists()) {
                try {
                    langJson = JsonParser.parseString((String)Files.readString(langFile.toPath(), StandardCharsets.UTF_8)).getAsJsonObject();
                }
                catch (IOException | IllegalStateException exception) {
                    // empty catch block
                }
            }
            for (Map.Entry entry : globalLang.entrySet()) {
                if (((String)entry.getKey()).equals("DO_NOT_ALTER_THIS_LINE") || langJson.has((String)entry.getKey())) continue;
                langJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            InputStream langStream = this.processJson(langJson.toString());
            virtualLangFiles.add(new VirtualFile("assets/minecraft/lang", lang + ".json", langStream));
        }
        output.removeIf(virtualFile -> virtualLangFiles.stream().anyMatch(v -> v.getPath().equals(virtualFile.getPath())));
        output.addAll(virtualLangFiles);
    }

    private void hideScoreboardNumbers() {
        if (VersionUtil.atOrAbove("1.20.3")) {
            OraxenPlugin.get().getProtocolManager().addPacketListener((PacketListener)new ScoreboardPacketListener());
        } else {
            ResourcePack.writeStringToVirtual("assets/minecraft/shaders/core/", "rendertype_text.json", this.getScoreboardJson());
            ResourcePack.writeStringToVirtual("assets/minecraft/shaders/core/", "rendertype_text.vsh", this.getScoreboardVsh());
        }
    }

    private void generateScoreboardHideBackground() {
        String fileName = VersionUtil.atOrAbove("1.20.1") ? "rendertype_gui.vsh" : "position_color.fsh";
        ResourcePack.writeStringToVirtual("assets/minecraft/shaders/core/", fileName, this.getScoreboardBackground());
    }

    private String getScoreboardVsh() {
        return "#version 150\n\nin vec3 Position;\nin vec4 Color;\nin vec2 UV0;\nin ivec2 UV2;\n\nuniform sampler2D Sampler2;\n\nuniform mat4 ModelViewMat;\nuniform mat4 ProjMat;\n\nuniform vec2 ScreenSize;\n\nout float vertexDistance;\nout vec4 vertexColor;\nout vec2 texCoord0;\n\nvoid main() {\n    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);\n\n    vertexDistance = length((ModelViewMat * vec4(Position, 1.0)).xyz);\n    vertexColor = Color * texelFetch(Sampler2, UV2 / 16, 0);\n    texCoord0 = UV0;\n\n\t// delete sidebar numbers\n\tif(\tPosition.z == 0.0 && // check if the depth is correct (0 for gui texts)\n\t\t\tgl_Position.x >= 0.95 && gl_Position.y >= -0.35 && // check if the position matches the sidebar\n\t\t\tvertexColor.g == 84.0/255.0 && vertexColor.g == 84.0/255.0 && vertexColor.r == 252.0/255.0 && // check if the color is the sidebar red color\n\t\t\tgl_VertexID <= 4 // check if it's the first character of a string\n\t\t) gl_Position = ProjMat * ModelViewMat * vec4(ScreenSize + 100.0, 0.0, 0.0); // move the vertices offscreen, idk if this is a good solution for that but vec4(0.0) doesnt do the trick for everyone\n}\n";
    }

    private String getScoreboardJson() {
        return "{\n    \"blend\": {\n        \"func\": \"add\",\n        \"srcrgb\": \"srcalpha\",\n        \"dstrgb\": \"1-srcalpha\"\n    },\n    \"vertex\": \"rendertype_text\",\n    \"fragment\": \"rendertype_text\",\n    \"attributes\": [\n        \"Position\",\n        \"Color\",\n        \"UV0\",\n        \"UV2\"\n    ],\n    \"samplers\": [\n        { \"name\": \"Sampler0\" },\n        { \"name\": \"Sampler2\" }\n    ],\n    \"uniforms\": [\n        { \"name\": \"ModelViewMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ProjMat\", \"type\": \"matrix4x4\", \"count\": 16, \"values\": [ 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0 ] },\n        { \"name\": \"ColorModulator\", \"type\": \"float\", \"count\": 4, \"values\": [ 1.0, 1.0, 1.0, 1.0 ] },\n        { \"name\": \"FogStart\", \"type\": \"float\", \"count\": 1, \"values\": [ 0.0 ] },\n        { \"name\": \"FogEnd\", \"type\": \"float\", \"count\": 1, \"values\": [ 1.0 ] },\n        { \"name\": \"FogColor\", \"type\": \"float\", \"count\": 4, \"values\": [ 0.0, 0.0, 0.0, 0.0 ] },\n\t\t{ \"name\": \"ScreenSize\", \"type\": \"float\", \"count\": 2,  \"values\": [ 1.0, 1.0 ] }\n    ]\n}\n";
    }

    private String getScoreboardBackground() {
        if (VersionUtil.atOrAbove("1.20.1")) {
            return "#version 150\n\nin vec3 Position;\nin vec4 Color;\n\nuniform mat4 ModelViewMat;\nuniform mat4 ProjMat;\n\nout vec4 vertexColor;\n\nvoid main() {\n\tgl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);\n\n\tvertexColor = Color;\n\n\t//Isolating Scoreboard Display\n\tif(gl_Position.y > -0.5 && gl_Position.y < 0.85 && gl_Position.x > 0.0 && gl_Position.x <= 1.0 && Position.z == 0.0) {\n\t\t//vertexColor = vec4(vec3(0.0,0.0,1.0),1.0); // Debugger\n\t\tvertexColor.a = 0.0;\n\t}\n\telse {\n    \t//vertexColor = vec4(vec3(1.0,0.0,0.0),1.0);\n\t}\n}\n";
        }
        return "#version 150\n\nin vec4 vertexColor;\n\nuniform vec4 ColorModulator;\n\nout vec4 fragColor;\n\nbool isgray(vec4 a) {\n    return a.r == 0 && a.g == 0 && a.b == 0 && a.a < 0.3 && a.a > 0.29;\n}\n\nbool isdarkgray(vec4 a) {\n\treturn a.r == 0 && a.g == 0 && a.b == 0 && a.a == 0.4;\n}\n\nvoid main() {\n\n    vec4 color = vertexColor;\n\n    if (color.a == 0.0) {\n        discard;\n    }\n\n    fragColor = color * ColorModulator;\n\n\tif(isgray(fragColor)){\n\t\tdiscard;\n\t}\n\tif(isdarkgray(fragColor)){\n\t\tdiscard;\n\t}\n}\n// Made by Reytz#9806 for minecraft 1.18.2";
    }

    static {
        packFolder = new File(OraxenPlugin.get().getDataFolder(), "pack");
        availableLanguageCodes = new HashSet<String>(Arrays.asList("af_za", "ar_sa", "ast_es", "az_az", "ba_ru", "bar", "be_by", "bg_bg", "br_fr", "brb", "bs_ba", "ca_es", "cs_cz", "cy_gb", "da_dk", "de_at", "de_ch", "de_de", "el_gr", "en_au", "en_ca", "en_gb", "en_nz", "en_pt", "en_ud", "en_us", "enp", "enws", "eo_uy", "es_ar", "es_cl", "es_ec", "es_es", "es_mx", "es_uy", "es_ve", "esan", "et_ee", "eu_es", "fa_ir", "fi_fi", "fil_ph", "fo_fo", "fr_ca", "fr_fr", "fra_de", "fur_it", "fy_nl", "ga_ie", "gd_gb", "gl_es", "haw_us", "he_il", "hi_in", "hr_hr", "hu_hu", "hy_am", "id_id", "ig_ng", "io_en", "is_is", "isv", "it_it", "ja_jp", "jbo_en", "ka_ge", "kk_kz", "kn_in", "ko_kr", "ksh", "kw_gb", "la_la", "lb_lu", "li_li", "lmo", "lol_us", "lt_lt", "lv_lv", "lzh", "mk_mk", "mn_mn", "ms_my", "mt_mt", "nah", "nds_de", "nl_be", "nl_nl", "nn_no", "no_no", "oc_fr", "ovd", "pl_pl", "pt_br", "pt_pt", "qya_aa", "ro_ro", "rpr", "ru_ru", "ry_ua", "se_no", "sk_sk", "sl_si", "so_so", "sq_al", "sr_sp", "sv_se", "sxu", "szl", "ta_in", "th_th", "tl_ph", "tlh_aa", "tok", "tr_tr", "tt_ru", "uk_ua", "val_es", "vec_it", "vi_vn", "yi_de", "yo_ng", "zh_cn", "zh_hk", "zh_tw", "zlm_arab"));
    }
}

