/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.farming.smelting;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.farming.smelting.SmeltingMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;

public class SmeltingMechanicListener
implements Listener {
    private final MechanicFactory factory;

    public SmeltingMechanicListener(MechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInMainHand();
        Block block = event.getBlock();
        Location location = BlockHelpers.toCenterLocation(block.getLocation());
        Collection itemStacks = event.getBlock().getDrops();
        String itemID = OraxenItems.getIdByItem(item);
        if (itemStacks.isEmpty()) {
            return;
        }
        if (this.factory.isNotImplementedIn(itemID)) {
            return;
        }
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        ItemStack loot = this.furnace(itemStacks.stream().findAny().orElse(null));
        if (loot == null) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (!item.hasItemMeta()) {
            return;
        }
        assert (itemMeta != null);
        if (block.getType().toString().contains("ORE") && itemMeta.hasEnchant(Enchantment.LOOT_BONUS_BLOCKS)) {
            loot.setAmount(1 + ThreadLocalRandom.current().nextInt(itemMeta.getEnchantLevel(Enchantment.LOOT_BONUS_BLOCKS)));
        }
        event.setDropItems(false);
        if (!location.isWorldLoaded()) {
            return;
        }
        assert (location.getWorld() != null);
        location.getWorld().dropItemNaturally(location, loot);
        SmeltingMechanic mechanic = (SmeltingMechanic)this.factory.getMechanic(itemID);
        if (mechanic != null && mechanic.playSound()) {
            location.getWorld().playSound(location, Sound.ENTITY_GUARDIAN_ATTACK, 0.1f, 0.8f);
        }
    }

    private ItemStack furnace(ItemStack item) {
        if (item == null) {
            return null;
        }
        String type = item.getType().toString();
        if (type.startsWith("RAW_") && !type.endsWith("_BLOCK")) {
            Material smeltedMaterial = Material.matchMaterial((String)(item.getType().toString().substring(4) + "_INGOT"));
            if (smeltedMaterial == null) {
                return null;
            }
            item.setType(smeltedMaterial);
            return item;
        }
        for (Recipe recipe : Bukkit.getRecipesFor((ItemStack)item)) {
            CookingRecipe cookingRecipe;
            if (!(recipe instanceof CookingRecipe) || !(cookingRecipe = (CookingRecipe)recipe).getInputChoice().test(item)) continue;
            return new ItemStack(recipe.getResult().getType(), item.getAmount());
        }
        return null;
    }
}

