/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_16_4_5;

import com.github.stefvanschie.inventoryframework.abstraction.StonecutterInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_16_4_5.util.TextHolderUtil;
import java.lang.reflect.Field;
import net.minecraft.server.v1_16_R3.Container;
import net.minecraft.server.v1_16_R3.ContainerStonecutter;
import net.minecraft.server.v1_16_R3.Containers;
import net.minecraft.server.v1_16_R3.EntityHuman;
import net.minecraft.server.v1_16_R3.EntityPlayer;
import net.minecraft.server.v1_16_R3.IChatBaseComponent;
import net.minecraft.server.v1_16_R3.IInventory;
import net.minecraft.server.v1_16_R3.NonNullList;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R3.PacketPlayOutSetSlot;
import net.minecraft.server.v1_16_R3.PacketPlayOutWindowItems;
import net.minecraft.server.v1_16_R3.PlayerConnection;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryStonecutter;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StonecutterInventoryImpl
extends StonecutterInventory {
    public StonecutterInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 2) {
            throw new IllegalArgumentException("The amount of items for a stonecutter should be 2, but is '" + itemAmount + "'");
        }
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        ContainerStonecutterImpl containerEnchantmentTable = new ContainerStonecutterImpl(entityPlayer, items);
        entityPlayer.activeContainer = containerEnchantmentTable;
        int id = containerEnchantmentTable.windowId;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        PacketPlayOutOpenWindow packet = new PacketPlayOutOpenWindow(id, Containers.STONECUTTER, message);
        entityPlayer.playerConnection.sendPacket((Packet)packet);
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList nmsItems = NonNullList.a((Object)net.minecraft.server.v1_16_R3.ItemStack.b, (Object[])new net.minecraft.server.v1_16_R3.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1])});
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(this.getWindowId(entityPlayer), nmsItems));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        this.getPlayerConnection(this.getEntityPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, net.minecraft.server.v1_16_R3.ItemStack.b));
    }

    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }

    @NotNull
    @Contract(pure=true)
    private PlayerConnection getPlayerConnection(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.playerConnection;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerStonecutterImpl
    extends ContainerStonecutter {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;
        @NotNull
        private final Field resultInventoryField;

        public ContainerStonecutterImpl(@Nullable EntityPlayer entityPlayer, ItemStack[] items) {
            super(entityPlayer.nextContainerCounter(), entityPlayer.inventory);
            this.player = entityPlayer.getBukkitEntity();
            try {
                this.resultInventoryField = ContainerStonecutter.class.getDeclaredField("resultInventory");
                this.resultInventoryField.setAccessible(true);
            }
            catch (NoSuchFieldException exception) {
                throw new RuntimeException(exception);
            }
            this.inventory.setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.getResultInventory().setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[1]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                CraftInventoryStonecutter inventory = new CraftInventoryStonecutter(this.inventory, this.getResultInventory()){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return StonecutterInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
            }
            return this.bukkitEntity;
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman entityhuman) {
            return true;
        }

        public void a(IInventory inventory) {
        }

        public void b(EntityHuman entityhuman) {
        }

        @NotNull
        @Contract(pure=true)
        public IInventory getResultInventory() {
            try {
                return (IInventory)this.resultInventoryField.get((Object)this);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

