/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.font.GlyphTag;
import io.th0rgal.oraxen.font.ShiftTag;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class AdventureUtils {
    public static final MiniMessage MINI_MESSAGE_EMPTY = MiniMessage.miniMessage();
    public static final TagResolver OraxenTagResolver = TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), GlyphTag.RESOLVER, ShiftTag.RESOLVER, TagResolver.resolver((String)"prefix", (Tag)Tag.selfClosingInserting((Component)MINI_MESSAGE_EMPTY.deserialize((Object)Message.PREFIX.toString())))});
    public static final LegacyComponentSerializer LEGACY_SERIALIZER = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    public static final LegacyComponentSerializer LEGACY_AMPERSAND = LegacyComponentSerializer.builder().character('&').hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    public static final MiniMessage MINI_MESSAGE = MiniMessage.builder().tags(OraxenTagResolver).build();
    public static final GsonComponentSerializer GSON_SERIALIZER = GsonComponentSerializer.gson();
    public static final PlainTextComponentSerializer PLAIN_TEXT = PlainTextComponentSerializer.plainText();

    private AdventureUtils() {
    }

    public static MiniMessage MINI_MESSAGE_PLAYER(Player player) {
        return MiniMessage.builder().tags(TagResolver.resolver((TagResolver[])new TagResolver[]{TagResolver.standard(), GlyphTag.getResolverForPlayer(player)})).build();
    }

    public static String parseMiniMessage(String message) {
        return ((String)MINI_MESSAGE.serialize(MINI_MESSAGE.deserialize((Object)message))).replaceAll("\\\\(?!u)(?!n)(?!\")", "");
    }

    public static String parseMiniMessage(String message, @Nullable TagResolver tagResolver) {
        return ((String)MINI_MESSAGE.serialize(tagResolver != null ? MINI_MESSAGE.deserialize(message, tagResolver) : MINI_MESSAGE.deserialize((Object)message))).replaceAll("\\\\(?!u)(?!n)(?!\")", "");
    }

    public static String parseMiniMessage(String message, Player player) {
        return ((String)MINI_MESSAGE_EMPTY.serialize(AdventureUtils.MINI_MESSAGE_PLAYER(player).deserialize((Object)message))).replaceAll("\\\\(?!u)(?!n)(?!\")", "");
    }

    public static Component parseMiniMessage(Component message) {
        return MINI_MESSAGE.deserialize((Object)((String)MINI_MESSAGE.serialize(message)).replaceAll("\\\\(?!u)(?!n)(?!\")", ""));
    }

    public static Component parseMiniMessage(Component message, TagResolver tagResolver) {
        return MINI_MESSAGE.deserialize(((String)MINI_MESSAGE.serialize(message)).replaceAll("\\\\(?!u)(?!n)(?!\")", ""), tagResolver);
    }

    public static Component parseMiniMessage(Component message, Player player) {
        return AdventureUtils.MINI_MESSAGE_PLAYER(player).deserialize((Object)((String)MINI_MESSAGE_EMPTY.serialize(message)).replaceAll("\\\\(?!u)(?!n)(?!\")", ""));
    }

    public static String parseLegacy(String message) {
        return ((String)MINI_MESSAGE.serialize((Component)LEGACY_SERIALIZER.deserialize(message))).replaceAll("\\\\(?!u)(?!n)(?!\")", "");
    }

    public static Component parseLegacy(Component message) {
        return MINI_MESSAGE.deserialize((Object)LEGACY_SERIALIZER.serialize(message));
    }

    public static String parseLegacyToString(Component message) {
        return (String)MINI_MESSAGE.serialize(AdventureUtils.parseLegacy(message));
    }

    public static String parseLegacyThroughMiniMessage(String message) {
        return LEGACY_SERIALIZER.serialize(MINI_MESSAGE.deserialize((Object)((String)MINI_MESSAGE.serialize((Component)LEGACY_SERIALIZER.deserialize(message))).replaceAll("\\\\(?!u)(?!n)(?!\")", "")));
    }

    public static String parseLegacyThroughMiniMessage(String message, Player player) {
        MiniMessage mm = player != null ? AdventureUtils.MINI_MESSAGE_PLAYER(player) : MINI_MESSAGE;
        return LEGACY_SERIALIZER.serialize(mm.deserialize((Object)((String)mm.serialize((Component)LEGACY_SERIALIZER.deserialize(message))).replaceAll("\\\\(?!u)(?!n)(?!\")", "")));
    }

    public static String parseLegacyThroughMiniMessage(Component message) {
        return LEGACY_SERIALIZER.serialize(MINI_MESSAGE.deserialize((Object)LEGACY_SERIALIZER.serialize(message).replaceAll("\\\\(?!u)(?!n)(?!\")", "")));
    }

    public static String parseMiniMessageThroughLegacy(Component message) {
        return ((String)MINI_MESSAGE.serialize((Component)LEGACY_SERIALIZER.deserialize(((String)MINI_MESSAGE.serialize(message)).replace("&", "\u00c2\u00a7")))).replaceAll("\\\\(?!u)(?!n)(?!\")", "");
    }

    public static String parseJson(String message) {
        return ((String)GSON_SERIALIZER.serialize(GSON_SERIALIZER.deserialize((Object)message))).replaceAll("\\\\(?!u)(?!n)(?!\")", "");
    }

    public static Component parseJson(Component message) {
        return GSON_SERIALIZER.deserialize((Object)((String)GSON_SERIALIZER.serialize(message)).replaceAll("\\\\(?!u)(?!n)(?!\")", ""));
    }

    public static String parseJsonThroughMiniMessage(String message) {
        return ((String)GSON_SERIALIZER.serialize(MINI_MESSAGE.deserialize((Object)((String)MINI_MESSAGE.serialize(GSON_SERIALIZER.deserialize((Object)message))).replaceAll("\\\\(?!u)(?!n)(?!\")(?!:)", "")))).replaceAll("\\\\(?!u)(?!n)(?!\")(?!:)", "");
    }

    public static String parseJsonThroughMiniMessage(String message, Player player) {
        TagResolver resolver = TagResolver.resolver((TagResolver[])new TagResolver[]{GlyphTag.getResolverForPlayer(player), ShiftTag.RESOLVER});
        Component component = GSON_SERIALIZER.deserialize((Object)message.replaceAll("\\\\(?!u)(?!n)(?!\")", ""));
        component = MINI_MESSAGE.deserialize(((String)MINI_MESSAGE.serialize(component)).replaceAll("\\\\(?!u)(?!n)(?!\")", ""), resolver);
        if (player != null) {
            component = GlobalTranslator.render((Component)component, (Locale)Locale.forLanguageTag(player.getLocale()));
        }
        return ((String)GSON_SERIALIZER.serialize(component)).replaceAll("\\\\(?!u)(?!n)(?!\")", "");
    }

    public static String parsePlainText(String message) {
        return PLAIN_TEXT.serialize((Component)PLAIN_TEXT.deserialize(message));
    }

    public static Component parsePlainText(Component message) {
        return PLAIN_TEXT.deserialize(PLAIN_TEXT.serialize(message));
    }

    public static TagResolver tagResolver(String string, String tag) {
        return TagResolver.resolver((String)string, (Tag)Tag.selfClosingInserting((Component)MINI_MESSAGE.deserialize((Object)tag)));
    }
}

