/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.armor_effects;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.MechanicsManager;
import io.th0rgal.oraxen.mechanics.provided.misc.armor_effects.ArmorEffectsListener;
import io.th0rgal.oraxen.mechanics.provided.misc.armor_effects.ArmorEffectsMechanic;
import io.th0rgal.oraxen.mechanics.provided.misc.armor_effects.ArmorEffectsTask;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class ArmorEffectsFactory
extends MechanicFactory {
    private static ArmorEffectsFactory instance;
    private ArmorEffectsTask armorEffectTask;
    private final int delay;

    public ArmorEffectsFactory(ConfigurationSection section) {
        super(section);
        this.delay = section.getInt("delay_in_ticks", 20);
        instance = this;
        MechanicsManager.registerListeners(OraxenPlugin.get(), this.getMechanicID(), new ArmorEffectsListener());
    }

    public static ArmorEffectsFactory getInstance() {
        return instance;
    }

    @Override
    public Mechanic parse(ConfigurationSection configurationSection) {
        ArmorEffectsMechanic mechanic = new ArmorEffectsMechanic(this, configurationSection);
        this.addToImplemented(mechanic);
        if (this.armorEffectTask != null) {
            this.armorEffectTask.cancel();
        }
        this.armorEffectTask = new ArmorEffectsTask();
        this.armorEffectTask.runTaskTimer((Plugin)OraxenPlugin.get(), 0L, this.delay);
        return mechanic;
    }

    public int getDelay() {
        return this.delay;
    }
}

