/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.durability;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.provided.gameplay.durability.DurabilityMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.durability.DurabilityMechanicFactory;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

public class DurabilityMechanicManager
implements Listener {
    private final DurabilityMechanicFactory factory;

    public DurabilityMechanicManager(DurabilityMechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemDamaged(PlayerItemDamageEvent event) {
        DurabilityMechanic mechanic = this.factory.getMechanic(event.getItem());
        if (mechanic == null || !mechanic.changeDurability(event.getItem(), -event.getDamage())) {
            return;
        }
        event.setDamage(0);
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onItemMend(PlayerItemMendEvent event) {
        DurabilityMechanic mechanic = this.factory.getMechanic(OraxenItems.getIdByItem(event.getItem()));
        if (mechanic == null || !mechanic.changeDurability(event.getItem(), event.getRepairAmount())) {
            return;
        }
        event.setRepairAmount(0);
    }

    @EventHandler
    public void onItemRepair(PrepareAnvilEvent event) {
        DurabilityMechanic secondMechanic;
        ItemStack firstItem = event.getInventory().getFirstItem();
        ItemStack secondItem = event.getInventory().getSecondItem();
        ItemStack resultItem = event.getResult();
        if (firstItem == null || secondItem == null) {
            return;
        }
        if (!(firstItem.getItemMeta() instanceof Damageable)) {
            return;
        }
        if (!(secondItem.getItemMeta() instanceof Damageable)) {
            return;
        }
        DurabilityMechanic firstMechanic = this.factory.getMechanic(OraxenItems.getIdByItem(firstItem));
        if (firstMechanic != (secondMechanic = this.factory.getMechanic(OraxenItems.getIdByItem(secondItem))) || firstMechanic == null) {
            return;
        }
        int combinedDurability = firstMechanic.getItemMaxDurability() - firstMechanic.getItemDurability(firstItem);
        double repairPercentAmount = (double)firstMechanic.getItemMaxDurability() * 0.12;
        int repairAmount = (int)(repairPercentAmount + (double)(combinedDurability += secondMechanic.getItemDurability(secondItem)));
        DurabilityMechanic resultMechanic = this.factory.getMechanic(OraxenItems.getIdByItem(resultItem));
        if (resultMechanic == null) {
            return;
        }
        resultMechanic.changeDurability(resultItem, repairAmount);
        event.setResult(resultItem);
    }
}

