/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.utils.ValueConsumer;
import io.th0rgal.oraxen.utils.ValueProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public abstract class ReflectionUtils {
    public static Class<?>[] getClasses(Class<?> sample, String packageName, boolean deep) {
        ArrayList list = new ArrayList();
        ReflectionUtils.collectClasses(sample, packageName, list, deep);
        return new Class[0];
    }

    public static void collectClasses(Class<?> sample, String packageName, Collection<Class<?>> collection, boolean deep) {
        Thread thread = new Thread(() -> ReflectionUtils.acceptJarStream(sample, stream -> {
            JarEntry entry;
            Predicate<String> test;
            String packagePath = packageName.replace('.', '/');
            Predicate<String> predicate = test = deep ? name -> name.startsWith(packagePath) : name -> name.split("\\.")[0].equals(packagePath);
            while ((entry = stream.getNextJarEntry()) != null) {
                String name2 = entry.getName();
                if (!test.test(name2) || name2.contains("$")) continue;
                if (name2.endsWith(".class")) {
                    collection.add(Class.forName(name2.replace('/', '.').substring(0, name2.length() - 6)));
                    continue;
                }
                if (!name2.endsWith(".java")) continue;
                collection.add(Class.forName(name2.replace('/', '.').substring(0, name2.length() - 5)));
            }
        }));
        thread.setName("Oraxen Class Loader");
        thread.start();
    }

    public static void acceptJarStream(Class<?> sample, ValueConsumer<JarInputStream> consumer) {
        Optional<JarInputStream> option = ReflectionUtils.getJarStream(sample);
        if (option.isEmpty()) {
            return;
        }
        option.ifPresent(consumer);
        try {
            JarInputStream stream = option.get();
            stream.closeEntry();
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Optional<JarInputStream> getJarStream(Class<?> sample) {
        return ValueProvider.option(() -> new JarInputStream(sample.getProtectionDomain().getCodeSource().getLocation().openStream()));
    }
}

