/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.upload.hosts;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.pack.upload.hosts.HostingProvider;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Polymath
implements HostingProvider {
    private final String serverAddress;
    private String packUrl;
    private String minecraftPackURL;
    private String sha1;
    private UUID packUUID;

    public Polymath(String serverAddress) {
        this.serverAddress = (serverAddress.startsWith("http://") || serverAddress.startsWith("https://") ? "" : "https://") + serverAddress + (serverAddress.endsWith("/") ? "" : "/");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean uploadPack(File resourcePack) {
        try {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                JsonObject jsonOutput;
                HttpPost request = new HttpPost(this.serverAddress + "upload");
                HttpEntity httpEntity = MultipartEntityBuilder.create().addTextBody("id", Settings.POLYMATH_SECRET.toString()).addBinaryBody("pack", resourcePack).build();
                request.setEntity(httpEntity);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                HttpEntity responseEntity = response.getEntity();
                String responseString = EntityUtils.toString((HttpEntity)responseEntity);
                try {
                    jsonOutput = JsonParser.parseString((String)responseString).getAsJsonObject();
                }
                catch (JsonSyntaxException e) {
                    Logs.logError("The resource pack could not be uploaded due to a malformed response.");
                    Logs.logWarning("This is usually due to the resourcepack server being down.");
                    boolean bl = false;
                    if (httpClient == null) return bl;
                    httpClient.close();
                    return bl;
                }
                if (jsonOutput.has("url") && jsonOutput.has("sha1")) {
                    this.packUrl = jsonOutput.get("url").getAsString();
                    this.minecraftPackURL = this.packUrl.replace("https://", "http://");
                    this.sha1 = jsonOutput.get("sha1").getAsString();
                    this.packUUID = UUID.nameUUIDFromBytes(this.sha1.getBytes());
                    boolean bl = true;
                    return bl;
                }
                if (jsonOutput.has("error")) {
                    Logs.logError("Error: " + jsonOutput.get("error").getAsString());
                }
                Logs.logError("Response: " + jsonOutput);
                Logs.logError("The resource pack has not been uploaded to the server. Usually this is due to an excessive size.");
                boolean bl = false;
                return bl;
            }
            finally {
                if (httpClient != null) {
                    try {
                        httpClient.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (IOException | IllegalStateException ex) {
            Logs.logError("The resource pack has not been uploaded to the server. Usually this is due to an excessive size.");
            ex.printStackTrace();
            return false;
        }
    }

    @Override
    public String getPackURL() {
        return this.packUrl;
    }

    @Override
    public String getMinecraftPackURL() {
        return this.minecraftPackURL;
    }

    @Override
    public byte[] getSHA1() {
        int len = this.sha1.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(this.sha1.charAt(i), 16) << 4) + Character.digit(this.sha1.charAt(i + 1), 16));
        }
        return data;
    }

    @Override
    public String getOriginalSHA1() {
        return this.sha1;
    }

    @Override
    public UUID getPackUUID() {
        return this.packUUID;
    }
}

