/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.receive;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.pack.receive.PackAction;
import io.th0rgal.oraxen.utils.AdventureUtils;
import java.time.Duration;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.plugin.Plugin;

public class PackReceiver
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerUpdatesPackStatus(PlayerResourcePackStatusEvent event) {
        PlayerResourcePackStatusEvent.Status status = event.getStatus();
        TagResolver playerResolver = AdventureUtils.tagResolver("player", event.getPlayer().getName());
        PackAction packAction = switch (status) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerResourcePackStatusEvent.Status.ACCEPTED -> new PackAction(Settings.RECEIVE_ALLOWED_ACTIONS.toConfigSection(), playerResolver);
            case PlayerResourcePackStatusEvent.Status.DECLINED -> new PackAction(Settings.RECEIVE_DENIED_ACTIONS.toConfigSection(), playerResolver);
            case PlayerResourcePackStatusEvent.Status.FAILED_DOWNLOAD -> new PackAction(Settings.RECEIVE_FAILED_ACTIONS.toConfigSection(), playerResolver);
            case PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED -> new PackAction(Settings.RECEIVE_LOADED_ACTIONS.toConfigSection(), playerResolver);
            case PlayerResourcePackStatusEvent.Status.DOWNLOADED -> new PackAction(Settings.RECEIVE_DOWNLOADED_ACTIONS.toConfigSection(), playerResolver);
            case PlayerResourcePackStatusEvent.Status.INVALID_URL -> new PackAction(Settings.RECEIVE_INVALID_URL_ACTIONS.toConfigSection(), playerResolver);
            case PlayerResourcePackStatusEvent.Status.FAILED_RELOAD -> new PackAction(Settings.RECEIVE_FAILED_RELOAD_ACTIONS.toConfigSection(), playerResolver);
            case PlayerResourcePackStatusEvent.Status.DISCARDED -> new PackAction(Settings.RECEIVE_DISCARDED_ACTIONS.toConfigSection(), playerResolver);
        };
        Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> {
            if (packAction.hasMessage()) {
                this.sendMessage(event.getPlayer(), packAction.getMessageType(), packAction.getMessageContent());
            }
            if (packAction.hasSound()) {
                packAction.playSound(event.getPlayer(), event.getPlayer().getLocation());
            }
            packAction.getCommandsParser().perform(event.getPlayer());
        }, (long)packAction.getDelay());
    }

    private void sendMessage(Player receiver, String action, Component message) {
        Audience audience = OraxenPlugin.get().getAudience().sender((CommandSender)receiver);
        switch (action) {
            case "KICK": {
                receiver.kickPlayer(AdventureUtils.LEGACY_SERIALIZER.serialize(message));
                break;
            }
            case "CHAT": {
                audience.sendMessage(message);
                break;
            }
            case "ACTION_BAR": {
                audience.sendActionBar(message);
                break;
            }
            case "TITLE": {
                audience.showTitle(Title.title((Component)Component.empty(), (Component)message, (Title.Times)Title.Times.times((Duration)Duration.ofMillis(250L), (Duration)Duration.ofMillis(3500L), (Duration)Duration.ofMillis(250L))));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + action);
            }
        }
    }
}

