/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.backpack;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import java.util.function.Function;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class BackpackMechanic
extends Mechanic {
    public static final NamespacedKey BACKPACK_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "backpack");
    private final int rows;
    private final String title;
    private final String openSound;
    private final String closeSound;
    private final float volume;
    private final float pitch;

    public BackpackMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        this.rows = section.getInt("rows", 6);
        this.title = section.getString("title", "Backpack");
        this.openSound = section.getString("open_sound", "minecraft:entity.shulker.open");
        this.closeSound = section.getString("close_sound", "minecraft:entity.shulker.close");
        this.volume = (float)section.getDouble("volume", 1.0);
        this.pitch = (float)section.getDouble("pitch", 1.0);
    }

    public int getRows() {
        return this.rows;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasOpenSound() {
        return this.openSound != null;
    }

    public String getOpenSound() {
        return this.openSound;
    }

    public boolean hasCloseSound() {
        return this.closeSound != null;
    }

    public String getCloseSound() {
        return this.closeSound;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getVolume() {
        return this.volume;
    }
}

