/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.api.animation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ticxo.playeranimator.api.PlayerAnimatorPlugin;
import com.ticxo.playeranimator.api.animation.pack.AnimationPack;
import com.ticxo.playeranimator.api.animation.pack.AnimationPackDeserializer;
import com.ticxo.playeranimator.io.FilenameUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class AnimationManager {
    private final Gson gson = new GsonBuilder().registerTypeAdapter(AnimationPack.class, (Object)new AnimationPackDeserializer()).create();
    private final Map<String, AnimationPack> registry = new HashMap<String, AnimationPack>();
    private final File packsFolder;

    public AnimationManager() {
        if (PlayerAnimatorPlugin.plugin == null) {
            this.packsFolder = null;
            return;
        }
        File root = PlayerAnimatorPlugin.plugin.getDataFolder();
        this.packsFolder = new File(root, "packs");
        if (!this.packsFolder.exists() && !this.packsFolder.mkdirs()) {
            PlayerAnimatorPlugin.plugin.getLogger().log(Level.WARNING, "Unable to create packs folder.");
        }
    }

    public void clearRegistry() {
        this.registry.clear();
    }

    public void importPacks() {
        if (this.packsFolder == null) {
            throw new RuntimeException("Player Animator is not used as a standalone plugin. Please use AnimationManager.importAnimations() to import animations individually.");
        }
        try {
            this.clearRegistry();
            File[] packs = this.packsFolder.listFiles();
            if (packs == null) {
                return;
            }
            for (File pack : packs) {
                File[] animations;
                if (!pack.isDirectory() || (animations = pack.listFiles()) == null) continue;
                for (File animation : animations) {
                    if (!animation.isFile()) continue;
                    String animationName = FilenameUtils.removeExtension(animation.getName());
                    FileReader reader = new FileReader(animation);
                    AnimationPack animationPack = (AnimationPack)this.gson.fromJson((Reader)reader, AnimationPack.class);
                    this.registerPack(pack.getName() + ":" + animationName, animationPack);
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void importAnimations(String key, File animation) {
        try {
            if (!animation.isFile()) {
                throw new IllegalArgumentException("Provided path to animation file does not point to a file.");
            }
            if (!"bbmodel".equalsIgnoreCase(FilenameUtils.getExtension(animation.getName()))) {
                throw new IllegalArgumentException("File is not a bbmodel file.");
            }
            String animationName = FilenameUtils.removeExtension(animation.getName());
            FileReader reader = new FileReader(animation);
            AnimationPack animationPack = (AnimationPack)this.gson.fromJson((Reader)reader, AnimationPack.class);
            this.registerPack(key + ":" + animationName, animationPack);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerPack(String name, AnimationPack pack) {
        this.registry.put(name, pack);
    }

    public AnimationPack getAnimationPack(String name) {
        return this.registry.get(name);
    }

    public Map<String, AnimationPack> getRegistry() {
        return this.registry;
    }
}

