/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_20_0_1;

import com.github.stefvanschie.inventoryframework.abstraction.GrindstoneInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_20_0_1.util.CustomInventoryUtil;
import com.github.stefvanschie.inventoryframework.nms.v1_20_0_1.util.TextHolderUtil;
import org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GrindstoneInventoryImpl
extends GrindstoneInventory {
    public GrindstoneInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public Inventory openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for a grindstone should be 3, but is '" + itemAmount + "'");
        }
        aig serverPlayer = this.getServerPlayer(player);
        CraftEventFactory.handleInventoryCloseEvent((byo)serverPlayer);
        serverPlayer.bR = serverPlayer.bQ;
        sw message = TextHolderUtil.toComponent(title);
        ContainerGrindstoneImpl containerGrindstone = new ContainerGrindstoneImpl(serverPlayer, message);
        Inventory inventory = containerGrindstone.getBukkitView().getTopInventory();
        inventory.setItem(0, items[0]);
        inventory.setItem(1, items[1]);
        inventory.setItem(2, items[2]);
        int containerId = containerGrindstone.getContainerId();
        serverPlayer.c.a((uo)new wo(containerId, cck.o, message));
        serverPlayer.bR = containerGrindstone;
        serverPlayer.a((cbf)containerGrindstone);
        return inventory;
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items, @Nullable ItemStack cursor) {
        if (cursor == null) {
            throw new IllegalArgumentException("Cursor may not be null on version 1.19.2");
        }
        hn<cfz> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        aig serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((byo)serverPlayer);
        int state = serverPlayer.bR.k();
        cfz nmsCursor = CraftItemStack.asNMSCopy((ItemStack)cursor);
        ajb playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.a((uo)new vk(containerId, state, nmsItems, nmsCursor));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        aig serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bR.k();
        this.getPlayerConnection(serverPlayer).a((uo)new vm(-1, state, -1, cfz.b));
    }

    @Deprecated
    @Contract(pure=true)
    private int getContainerId(@NotNull byo nmsPlayer) {
        return nmsPlayer.bR.j;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    private ajb getPlayerConnection(@NotNull aig serverPlayer) {
        return serverPlayer.c;
    }

    @NotNull
    @Contract(pure=true)
    private aig getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private static class ContainerGrindstoneImpl
    extends ccb {
        public ContainerGrindstoneImpl(@NotNull aig serverPlayer, @NotNull sw title) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fN());
            this.setTitle(title);
            ccx firstSlot = (ccx)this.i.get(0);
            ccx secondSlot = (ccx)this.i.get(1);
            ccx thirdSlot = (ccx)this.i.get(2);
            this.i.set(0, (Object)new ccx(firstSlot.d, firstSlot.e, firstSlot.f, firstSlot.g){

                public boolean a(cfz stack) {
                    return true;
                }
            });
            this.i.set(1, (Object)new ccx(secondSlot.d, secondSlot.e, secondSlot.f, secondSlot.g){

                public boolean a(cfz stack) {
                    return true;
                }
            });
            this.i.set(2, (Object)new ccx(thirdSlot.d, thirdSlot.e, thirdSlot.f, thirdSlot.g){

                public boolean a(cfz stack) {
                    return true;
                }

                public void a(byo player, cfz stack) {
                }
            });
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable byo nmsPlayer) {
            return true;
        }

        public void a(bdq container) {
        }

        public void b(byo nmsPlayer) {
        }

        public int getContainerId() {
            return this.j;
        }
    }
}

