/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.inventories;

import dev.triumphteam.gui.builder.gui.PaginatedBuilder;
import dev.triumphteam.gui.components.ScrollType;
import dev.triumphteam.gui.guis.BaseGui;
import dev.triumphteam.gui.guis.Gui;
import dev.triumphteam.gui.guis.GuiItem;
import dev.triumphteam.gui.guis.PaginatedGui;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.ItemParser;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class ItemsView {
    private final YamlConfiguration settings = OraxenPlugin.get().getResourceManager().getSettings();
    BaseGui mainGui;

    public BaseGui create() {
        HashMap<File, PaginatedGui> files = new HashMap<File, PaginatedGui>();
        for (File file : OraxenItems.getMap().keySet()) {
            List<ItemBuilder> unexcludedItems = OraxenItems.getUnexcludedItems(file);
            if (unexcludedItems.isEmpty()) continue;
            files.put(file, this.createSubGUI(file.getName(), unexcludedItems));
        }
        int rows = (Integer)Settings.ORAXEN_INV_ROWS.getValue();
        String invType = Settings.ORAXEN_INV_TYPE.toString();
        this.mainGui = (Objects.equals(invType, "PAGINATED") ? Gui.paginated().pageSize((rows - 1) * 9) : (Objects.equals(invType, "SCROLL_HORIZONTAL") ? Gui.scrolling((ScrollType)ScrollType.HORIZONTAL).pageSize((rows - 1) * 9) : (Objects.equals(invType, "SCROLL_VERTICAL") ? Gui.scrolling((ScrollType)ScrollType.VERTICAL).pageSize((rows - 1) * 9) : Gui.gui()))).rows(rows).title(Settings.ORAXEN_INV_TITLE.toComponent()).create();
        ArrayList<Object> pageItems = new ArrayList<Object>(Collections.nCopies(files.size(), null));
        for (Map.Entry entry : files.entrySet()) {
            int slot = (Integer)this.getItemStack((File)entry.getKey()).getRight();
            if (slot == -1) continue;
            GuiItem guiItem = new GuiItem((ItemStack)this.getItemStack((File)entry.getKey()).getLeft(), e -> ((PaginatedGui)entry.getValue()).open(e.getWhoClicked()));
            pageItems.add(slot, guiItem);
        }
        for (Map.Entry entry : files.entrySet()) {
            if ((Integer)this.getItemStack((File)entry.getKey()).getRight() != -1) continue;
            pageItems.add(new GuiItem((ItemStack)this.getItemStack((File)entry.getKey()).getLeft(), e -> ((PaginatedGui)entry.getValue()).open(e.getWhoClicked())));
        }
        this.mainGui.addItem((GuiItem[])pageItems.stream().filter(Objects::nonNull).toArray(GuiItem[]::new));
        ItemStack nextPage = (Settings.ORAXEN_INV_NEXT_ICON.getValue() == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById(Settings.ORAXEN_INV_NEXT_ICON.toString())).setDisplayName("Next Page").build();
        ItemStack previousPage = (Settings.ORAXEN_INV_PREVIOUS_ICON.getValue() == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById(Settings.ORAXEN_INV_PREVIOUS_ICON.toString())).setDisplayName("Previous Page").build();
        ItemStack exitIcon = (Settings.ORAXEN_INV_EXIT.getValue() == null ? new ItemBuilder(Material.BARRIER) : OraxenItems.getItemById(Settings.ORAXEN_INV_EXIT.toString())).setDisplayName("Exit").build();
        BaseGui baseGui = this.mainGui;
        if (baseGui instanceof PaginatedGui) {
            PaginatedGui paginated = (PaginatedGui)baseGui;
            if (paginated.getPagesNum() > 1) {
                paginated.setItem(6, 2, new GuiItem(previousPage, event -> {
                    paginated.previous();
                    event.setCancelled(true);
                }));
                paginated.setItem(6, 8, new GuiItem(nextPage, event -> {
                    paginated.next();
                    event.setCancelled(true);
                }));
            }
            paginated.setItem(6, 5, new GuiItem(exitIcon, event -> this.mainGui.open(event.getWhoClicked())));
        }
        return this.mainGui;
    }

    private PaginatedGui createSubGUI(String fileName, List<ItemBuilder> items) {
        PaginatedGui gui = ((PaginatedBuilder)((PaginatedBuilder)Gui.paginated().rows(6)).pageSize(45).title(AdventureUtils.MINI_MESSAGE.deserialize((Object)this.settings.getString(String.format("oraxen_inventory.menu_layout.%s.title", Utils.removeExtension(fileName)), Settings.ORAXEN_INV_TITLE.toString()).replace("<main_menu_title>", Settings.ORAXEN_INV_TITLE.toString())))).create();
        gui.disableAllInteractions();
        for (ItemBuilder builder : items) {
            ItemStack itemStack;
            if (builder == null || (itemStack = builder.build()) == null || itemStack.getType().isAir()) continue;
            GuiItem guiItem = new GuiItem(itemStack);
            guiItem.setAction(e -> e.getWhoClicked().getInventory().addItem(new ItemStack[]{ItemUpdater.updateItem(guiItem.getItemStack())}));
            gui.addItem(guiItem);
        }
        ItemStack nextPage = (Settings.ORAXEN_INV_NEXT_ICON.getValue() == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById(Settings.ORAXEN_INV_NEXT_ICON.toString())).setDisplayName("Next Page").build();
        ItemStack previousPage = (Settings.ORAXEN_INV_PREVIOUS_ICON.getValue() == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById(Settings.ORAXEN_INV_PREVIOUS_ICON.toString())).setDisplayName("Previous Page").build();
        ItemStack exitIcon = (Settings.ORAXEN_INV_EXIT.getValue() == null ? new ItemBuilder(Material.BARRIER) : OraxenItems.getItemById(Settings.ORAXEN_INV_EXIT.toString())).setDisplayName("Exit").build();
        if (gui.getPagesNum() > 1) {
            gui.setItem(6, 2, new GuiItem(previousPage, event -> gui.previous()));
            gui.setItem(6, 8, new GuiItem(nextPage, event -> gui.next()));
        }
        gui.setItem(6, 5, new GuiItem(exitIcon, event -> this.mainGui.open(event.getWhoClicked())));
        return gui;
    }

    private Pair<ItemStack, Integer> getItemStack(File file) {
        ItemStack itemStack;
        String fileName = Utils.removeExtension(file.getName());
        String material = this.settings.getString(String.format("oraxen_inventory.menu_layout.%s.icon", fileName), "PAPER");
        String displayName = ItemParser.parseComponentDisplayName(this.settings.getString(String.format("oraxen_inventory.menu_layout.%s.displayname", fileName), "<green>" + file.getName()));
        try {
            itemStack = new ItemBuilder(OraxenItems.getItemById(material).getReferenceClone()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setDisplayName(displayName).setLore(new ArrayList<String>()).build();
        }
        catch (Exception e) {
            try {
                itemStack = new ItemBuilder(Material.getMaterial((String)material.toUpperCase())).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setDisplayName(displayName).build();
            }
            catch (Exception ignored) {
                itemStack = new ItemBuilder(Material.PAPER).setDisplayName(displayName).build();
            }
        }
        if (itemStack == null) {
            itemStack = new ItemBuilder(Material.PAPER).setDisplayName(displayName).build();
        }
        int slot = this.settings.getInt(String.format("oraxen_inventory.menu_layout.%s.slot", Utils.removeExtension(file.getName())), -1) - 1;
        return Pair.of((Object)itemStack, (Object)Math.max(slot, -1));
    }
}

