/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.generation.slicer;

import io.th0rgal.oraxen.pack.generation.slicer.InputFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.imageio.ImageIO;

@ParametersAreNonnullByDefault
public class Slicer {
    private final Path inputPath;
    private final Path outputPath;
    @Nullable
    private final Path leftoverPath;

    public Slicer(Path inputPath, Path outputPath, @Nullable Path leftoverPath) {
        this.inputPath = inputPath;
        this.outputPath = outputPath;
        this.leftoverPath = leftoverPath;
    }

    public static Slicer parse(String[] argv) {
        int argc = argv.length;
        if (argc != 2 && argc != 3) {
            throw new IllegalArgumentException("Usage: <input dir or zip> <output dir> [<leftover dir>]");
        }
        Path inputPath = Paths.get(argv[0], new String[0]);
        Path outputPath = Paths.get(argv[1], new String[0]);
        Path leftoverPath = argc == 3 ? Paths.get(argv[2], new String[0]) : null;
        return new Slicer(inputPath, outputPath, leftoverPath);
    }

    public static void writeImage(Path path, BufferedImage image) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.deleteIfExists(path);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            ImageIO.write((RenderedImage)image, "png", os);
        }
    }

    public void process(Collection<InputFile> inputs) throws IOException {
        if (Files.isDirectory(this.inputPath, new LinkOption[0])) {
            Slicer.process(inputs, this.inputPath, this.outputPath, this.leftoverPath);
        } else if (this.inputPath.getFileName().toString().endsWith(".zip")) {
            URI fsUri = URI.create("jar:" + this.inputPath.toUri());
            try (FileSystem fs = FileSystems.newFileSystem(fsUri, Collections.emptyMap());){
                Slicer.process(inputs, fs.getPath("/", new String[0]), this.outputPath, this.leftoverPath);
            }
        } else {
            throw new IllegalStateException("Expected either directory or zip file");
        }
    }

    private static void process(Collection<InputFile> inputs, Path inputPath, Path outputPath, @Nullable Path leftoverPath) throws IOException {
        for (InputFile input : inputs) {
            input.process(inputPath, outputPath, leftoverPath);
        }
    }
}

