/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.api.events.noteblock.OraxenNoteBlockBreakEvent;
import io.th0rgal.oraxen.api.events.noteblock.OraxenNoteBlockPlaceEvent;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.blocksounds.BlockSounds;
import io.th0rgal.protectionlib.ProtectionLib;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameEvent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.SoundGroup;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageAbortEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.world.GenericGameEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class NoteBlockSoundListener
implements Listener {
    private final Map<Location, BukkitTask> breakerPlaySound = new HashMap<Location, BukkitTask>();

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        for (Map.Entry<Location, BukkitTask> entry : this.breakerPlaySound.entrySet()) {
            if (entry.getKey().isWorldLoaded() || entry.getValue().isCancelled()) continue;
            entry.getValue().cancel();
            this.breakerPlaySound.remove(entry.getKey());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlacingWood(BlockPlaceEvent event) {
        Block placed = event.getBlockPlaced();
        if (placed.getBlockData().getSoundGroup().getPlaceSound() != Sound.BLOCK_WOOD_PLACE) {
            return;
        }
        if (OraxenBlocks.isOraxenNoteBlock(placed)) {
            return;
        }
        BlockHelpers.playCustomBlockSound(placed.getLocation(), BlockSounds.VANILLA_WOOD_PLACE, BlockSounds.VANILLA_PLACE_VOLUME, BlockSounds.VANILLA_PLACE_PITCH);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBreakingWood(BlockBreakEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        if (this.breakerPlaySound.containsKey(location)) {
            this.breakerPlaySound.get(location).cancel();
            this.breakerPlaySound.remove(location);
        }
        if (block.getBlockData().getSoundGroup().getBreakSound() != Sound.BLOCK_WOOD_BREAK) {
            return;
        }
        if (OraxenBlocks.isOraxenNoteBlock(block) || block.getType() == Material.MUSHROOM_STEM) {
            return;
        }
        if (!event.isCancelled() && ProtectionLib.canBreak((Player)event.getPlayer(), (Location)location)) {
            BlockHelpers.playCustomBlockSound(location, BlockSounds.VANILLA_WOOD_BREAK, BlockSounds.VANILLA_BREAK_VOLUME, BlockSounds.VANILLA_BREAK_PITCH);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onHitWood(BlockDamageEvent event) {
        Block block = event.getBlock();
        Location location = block.getLocation();
        SoundGroup soundGroup = block.getBlockData().getSoundGroup();
        if (block.getType() == Material.NOTE_BLOCK || block.getType() == Material.MUSHROOM_STEM) {
            if (event.getInstaBreak()) {
                Bukkit.getScheduler().runTaskLater((Plugin)OraxenPlugin.get(), () -> block.setType(Material.AIR, false), 1L);
            }
            return;
        }
        if (soundGroup.getHitSound() != Sound.BLOCK_WOOD_HIT) {
            return;
        }
        if (this.breakerPlaySound.containsKey(location)) {
            return;
        }
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)OraxenPlugin.get(), () -> BlockHelpers.playCustomBlockSound(location, BlockSounds.VANILLA_WOOD_HIT, BlockSounds.VANILLA_HIT_VOLUME, BlockSounds.VANILLA_HIT_PITCH), 2L, 4L);
        this.breakerPlaySound.put(location, task);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onStopHittingWood(BlockDamageAbortEvent event) {
        Location location = event.getBlock().getLocation();
        if (this.breakerPlaySound.containsKey(location)) {
            this.breakerPlaySound.get(location).cancel();
            this.breakerPlaySound.remove(location);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onStepFall(GenericGameEvent event) {
        float pitch;
        float volume;
        String sound;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (!BlockHelpers.isLoaded(entity.getLocation())) {
            return;
        }
        GameEvent gameEvent = event.getEvent();
        Block block = BlockHelpers.getBlockStandingOn(entity);
        EntityDamageEvent cause = entity.getLastDamageCause();
        if (gameEvent == GameEvent.HIT_GROUND && cause != null && cause.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        if (block == null || block.getType().isAir() || block.getBlockData().getSoundGroup().getStepSound() != Sound.BLOCK_WOOD_STEP) {
            return;
        }
        NoteBlockMechanic mechanic = OraxenBlocks.getNoteBlockMechanic(block);
        if (mechanic != null && mechanic.isDirectional() && !mechanic.getDirectional().isParentBlock()) {
            mechanic = mechanic.getDirectional().getParentMechanic();
        }
        if (gameEvent == GameEvent.STEP) {
            boolean check = block.getType() == Material.NOTE_BLOCK && mechanic != null && mechanic.hasBlockSounds() && mechanic.getBlockSounds().hasStepSound();
            sound = check ? mechanic.getBlockSounds().getStepSound() : BlockSounds.VANILLA_WOOD_STEP;
            volume = check ? mechanic.getBlockSounds().getStepVolume() : BlockSounds.VANILLA_STEP_VOLUME;
            pitch = check ? mechanic.getBlockSounds().getStepPitch() : BlockSounds.VANILLA_STEP_PITCH;
        } else if (gameEvent == GameEvent.HIT_GROUND) {
            boolean check = block.getType() == Material.NOTE_BLOCK && mechanic != null && mechanic.hasBlockSounds() && mechanic.getBlockSounds().hasFallSound();
            sound = check ? mechanic.getBlockSounds().getFallSound() : BlockSounds.VANILLA_WOOD_FALL;
            volume = check ? mechanic.getBlockSounds().getFallVolume() : BlockSounds.VANILLA_FALL_VOLUME;
            pitch = check ? mechanic.getBlockSounds().getFallPitch() : BlockSounds.VANILLA_FALL_PITCH;
        } else {
            return;
        }
        BlockHelpers.playCustomBlockSound(entity.getLocation(), sound, SoundCategory.PLAYERS, volume, pitch);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlacing(OraxenNoteBlockPlaceEvent event) {
        NoteBlockMechanic mechanic = event.getMechanic();
        if (mechanic.isDirectional() && !mechanic.getDirectional().isParentBlock()) {
            mechanic = mechanic.getDirectional().getParentMechanic();
        }
        if (mechanic == null || !mechanic.hasBlockSounds() || !mechanic.getBlockSounds().hasPlaceSound()) {
            return;
        }
        BlockSounds blockSounds = mechanic.getBlockSounds();
        BlockHelpers.playCustomBlockSound(event.getBlock().getLocation(), blockSounds.getPlaceSound(), blockSounds.getPlaceVolume(), blockSounds.getPlacePitch());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBreaking(OraxenNoteBlockBreakEvent event) {
        NoteBlockMechanic mechanic = event.getMechanic();
        if (mechanic.isDirectional() && !mechanic.getDirectional().isParentBlock()) {
            mechanic = mechanic.getDirectional().getParentMechanic();
        }
        if (mechanic == null || !mechanic.hasBlockSounds() || !mechanic.getBlockSounds().hasBreakSound()) {
            return;
        }
        BlockSounds blockSounds = mechanic.getBlockSounds();
        BlockHelpers.playCustomBlockSound(event.getBlock().getLocation(), blockSounds.getBreakSound(), blockSounds.getBreakVolume(), blockSounds.getBreakPitch());
    }
}

