/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.furniture;

import com.jeff_media.customblockdata.CustomBlockData;
import com.jeff_media.morepersistentdatatypes.DataType;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenFurniture;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.compatibilities.provided.blocklocker.BlockLockerMechanic;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.BlockLocation;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.DisplayEntityProperties;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.FurnitureFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.evolution.EvolvingFurniture;
import io.th0rgal.oraxen.mechanics.provided.gameplay.furniture.jukebox.JukeboxBlock;
import io.th0rgal.oraxen.mechanics.provided.gameplay.light.LightMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing.LimitedPlacing;
import io.th0rgal.oraxen.mechanics.provided.gameplay.storage.StorageMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.EntityUtils;
import io.th0rgal.oraxen.utils.ItemUtils;
import io.th0rgal.oraxen.utils.ModelEngineUtils;
import io.th0rgal.oraxen.utils.PluginUtils;
import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.actions.ClickAction;
import io.th0rgal.oraxen.utils.blocksounds.BlockSounds;
import io.th0rgal.oraxen.utils.drops.Drop;
import io.th0rgal.oraxen.utils.drops.Loot;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Rotation;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Transformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FurnitureMechanic
extends Mechanic {
    public static final NamespacedKey FURNITURE_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "furniture");
    public static final NamespacedKey BASE_ENTITY_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "base_entity");
    public static final NamespacedKey INTERACTION_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "interaction");
    public static final NamespacedKey MODELENGINE_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "modelengine");
    public static final NamespacedKey SEAT_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "seat");
    public static final NamespacedKey ROOT_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "root");
    public static final NamespacedKey ORIENTATION_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "orientation");
    public static final NamespacedKey EVOLUTION_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "evolution");
    public static final NamespacedKey BARRIER_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "barriers");
    private final int hardness;
    private final LimitedPlacing limitedPlacing;
    private final StorageMechanic storage;
    private final BlockSounds blockSounds;
    private final JukeboxBlock jukebox;
    public final boolean farmlandRequired;
    public final boolean farmblockRequired;
    private final List<BlockLocation> barriers;
    private final boolean hasSeat;
    private boolean hasSeatYaw;
    private final Drop drop;
    private final EvolvingFurniture evolvingFurniture;
    private final LightMechanic light;
    private final String modelEngineID;
    private final String placedItemId;
    private ItemStack placedItem;
    private float seatHeight;
    private float seatYaw;
    private final List<ClickAction> clickActions;
    private FurnitureType furnitureType;
    private final DisplayEntityProperties displayEntityProperties;
    private final FurnitureHitbox hitbox;
    private final boolean isRotatable;
    private final BlockLockerMechanic blockLocker;
    private final RestrictedRotation restrictedRotation;

    public FurnitureMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, itemBuilder -> itemBuilder.setCustomTag(FURNITURE_KEY, PersistentDataType.BYTE, (byte)1));
        ConfigurationSection dropSection;
        ConfigurationSection evoSection;
        ConfigurationSection hitboxSection;
        this.hardness = section.getInt("hardness", 1);
        this.placedItemId = section.getString("item", null);
        this.modelEngineID = section.getString("modelengine_id", null);
        this.farmlandRequired = section.getBoolean("farmland_required", false);
        this.farmblockRequired = section.getBoolean("farmblock_required", false);
        this.light = new LightMechanic(section);
        this.restrictedRotation = RestrictedRotation.fromString(section.getString("restricted_rotation", "STRICT"));
        try {
            String defaultEntityType = OraxenPlugin.supportsDisplayEntities ? Objects.requireNonNullElse(FurnitureFactory.defaultFurnitureType, FurnitureType.DISPLAY_ENTITY).name() : FurnitureType.ITEM_FRAME.name();
            this.furnitureType = FurnitureType.valueOf(section.getString("type", defaultEntityType));
            if (this.furnitureType == FurnitureType.DISPLAY_ENTITY && !OraxenPlugin.supportsDisplayEntities) {
                Logs.logError("Use of Display Entity on unsupported server version.");
                Logs.logError("This EntityType is only supported on 1.19.4 and above.");
                Logs.logWarning("Setting type to ITEM_FRAME for furniture: <i><gold>" + this.getItemID());
                this.furnitureType = FurnitureType.ITEM_FRAME;
            }
        }
        catch (IllegalArgumentException e) {
            Logs.logError("Use of illegal EntityType in furniture: <gold>" + this.getItemID());
            Logs.logWarning("Allowed ones are: <gold>" + Arrays.stream(FurnitureType.values()).map(Enum::name).toList());
            Logs.logWarning("Setting type to ITEM_FRAME for furniture: <gold>" + this.getItemID());
            this.furnitureType = FurnitureType.ITEM_FRAME;
        }
        section.set("type", (Object)this.furnitureType.name());
        ConfigurationSection displayProperties = section.getConfigurationSection("display_entity_properties");
        this.displayEntityProperties = OraxenPlugin.supportsDisplayEntities ? (displayProperties != null ? new DisplayEntityProperties(displayProperties) : new DisplayEntityProperties()) : null;
        this.barriers = new ArrayList<BlockLocation>();
        if (section.getBoolean("barrier", false)) {
            this.barriers.add(new BlockLocation(0, 0, 0));
        }
        if (section.isList("barriers")) {
            for (Object barrierObject : section.getList("barriers", new ArrayList())) {
                String string;
                if (barrierObject instanceof String && (string = (String)barrierObject).equals("origin")) {
                    this.barriers.add(new BlockLocation(0, 0, 0));
                    continue;
                }
                if (!(barrierObject instanceof Map)) continue;
                Map barrierMap = (Map)barrierObject;
                try {
                    this.barriers.add(new BlockLocation(barrierMap));
                }
                catch (ClassCastException e) {
                    Logs.logError("Invalid barrier location: " + barrierMap + " for furniture: " + this.getItemID());
                }
            }
        }
        if ((hitboxSection = section.getConfigurationSection("hitbox")) != null) {
            float width = (float)hitboxSection.getDouble("width", 1.0);
            float height = (float)hitboxSection.getDouble("height", 1.0);
            this.hitbox = width > 0.0f && height > 0.0f ? new FurnitureHitbox(width, height) : null;
        } else {
            this.hitbox = !this.hasBarriers() ? new FurnitureHitbox(1.0f, 1.0f) : null;
        }
        ConfigurationSection seatSection = section.getConfigurationSection("seat");
        if (seatSection != null) {
            this.hasSeat = true;
            this.seatHeight = (float)seatSection.getDouble("height");
            this.hasSeatYaw = seatSection.contains("yaw");
            if (this.hasSeatYaw) {
                this.seatYaw = (float)seatSection.getDouble("yaw");
            }
        } else {
            this.hasSeat = false;
        }
        EvolvingFurniture evolvingFurniture = this.evolvingFurniture = (evoSection = section.getConfigurationSection("evolution")) != null ? new EvolvingFurniture(this.getItemID(), evoSection) : null;
        if (this.evolvingFurniture != null) {
            ((FurnitureFactory)this.getFactory()).registerEvolution();
        }
        this.drop = (dropSection = section.getConfigurationSection("drop")) != null ? Drop.createDrop(FurnitureFactory.getInstance().toolTypes, dropSection, this.getItemID()) : new Drop(new ArrayList<Loot>(), false, false, this.getItemID());
        ConfigurationSection limitedPlacingSection = section.getConfigurationSection("limited_placing");
        this.limitedPlacing = limitedPlacingSection != null ? new LimitedPlacing(limitedPlacingSection) : null;
        ConfigurationSection storageSection = section.getConfigurationSection("storage");
        this.storage = storageSection != null ? new StorageMechanic(storageSection) : null;
        ConfigurationSection blockSoundsSection = section.getConfigurationSection("block_sounds");
        this.blockSounds = blockSoundsSection != null ? new BlockSounds(blockSoundsSection) : null;
        ConfigurationSection jukeboxSection = section.getConfigurationSection("jukebox");
        this.jukebox = jukeboxSection != null ? new JukeboxBlock(mechanicFactory, jukeboxSection) : null;
        this.clickActions = ClickAction.parseList(section);
        if (section.getBoolean("rotatable", false)) {
            if (this.barriers.stream().anyMatch(b -> b.getX() != 0 || b.getZ() != 0)) {
                Logs.logWarning("Furniture <gold>" + this.getItemID() + " </gold>has barriers with non-zero X or Z coordinates.");
                Logs.logWarning("Furniture rotation will be disabled for this furniture.");
                this.isRotatable = false;
            } else {
                this.isRotatable = true;
            }
        } else {
            this.isRotatable = false;
        }
        ConfigurationSection blockLockerSection = section.getConfigurationSection("blocklocker");
        this.blockLocker = blockLockerSection != null ? new BlockLockerMechanic(blockLockerSection) : null;
    }

    public boolean isModelEngine() {
        return this.modelEngineID != null;
    }

    public String getModelEngineID() {
        return this.modelEngineID;
    }

    public static ArmorStand getSeat(Location location) {
        Location seatLoc = BlockHelpers.toCenterBlockLocation(location);
        if (location.getWorld() == null) {
            return null;
        }
        for (Entity entity : location.getWorld().getNearbyEntities(seatLoc, 0.1, 4.0, 0.1)) {
            if (!(entity instanceof ArmorStand)) continue;
            ArmorStand seat = (ArmorStand)entity;
            if (entity.getLocation().getX() != seatLoc.getX() || entity.getLocation().getZ() != seatLoc.getZ() || !entity.getPersistentDataContainer().has(FURNITURE_KEY, DataType.STRING)) continue;
            return seat;
        }
        return null;
    }

    public static ArmorStand getSeat(Entity baseEntity) {
        PersistentDataContainer pdc = baseEntity.getPersistentDataContainer();
        if (!pdc.has(SEAT_KEY, DataType.UUID)) {
            return null;
        }
        UUID seatUUID = (UUID)pdc.get(SEAT_KEY, DataType.UUID);
        if (seatUUID == null) {
            return null;
        }
        Entity seat = Bukkit.getEntity((UUID)seatUUID);
        return seat instanceof ArmorStand ? (ArmorStand)seat : null;
    }

    public boolean hasHardness() {
        return this.hardness != -1;
    }

    public int getHardness() {
        return this.hardness;
    }

    public boolean hasLimitedPlacing() {
        return this.limitedPlacing != null;
    }

    public LimitedPlacing getLimitedPlacing() {
        return this.limitedPlacing;
    }

    public boolean isStorage() {
        return this.storage != null;
    }

    public StorageMechanic getStorage() {
        return this.storage;
    }

    public boolean hasBlockSounds() {
        return this.blockSounds != null;
    }

    public BlockSounds getBlockSounds() {
        return this.blockSounds;
    }

    public boolean isJukebox() {
        return this.jukebox != null;
    }

    public JukeboxBlock getJukebox() {
        return this.jukebox;
    }

    public boolean hasBarriers() {
        return !this.barriers.isEmpty();
    }

    public boolean hasBarriers(@NotNull Entity baseEntity) {
        return this.hasBarriers() || !((List)baseEntity.getPersistentDataContainer().getOrDefault(BARRIER_KEY, DataType.asList(BlockLocation.dataType), new ArrayList())).isEmpty();
    }

    public List<BlockLocation> getBarriers() {
        return this.barriers;
    }

    public List<BlockLocation> getBarriers(@NotNull Entity baseEntity) {
        List<BlockLocation> barriers = (List<BlockLocation>)baseEntity.getPersistentDataContainer().getOrDefault(BARRIER_KEY, DataType.asList(BlockLocation.dataType), new ArrayList());
        return barriers.isEmpty() ? this.barriers : barriers;
    }

    public boolean hasHitbox() {
        return this.hitbox != null;
    }

    public FurnitureHitbox getHitbox() {
        return this.hitbox;
    }

    public boolean hasSeat() {
        return this.hasSeat;
    }

    public float getSeatHeight() {
        return this.seatHeight;
    }

    public Drop getDrop() {
        return this.drop;
    }

    public boolean hasEvolution() {
        return this.evolvingFurniture != null;
    }

    public EvolvingFurniture getEvolution() {
        return this.evolvingFurniture;
    }

    public boolean isRotatable() {
        return this.isRotatable;
    }

    public boolean isInteractable() {
        return this.isRotatable || this.hasSeat || this.isStorage();
    }

    public void setPlacedItem() {
        if (this.placedItem == null) {
            this.placedItem = OraxenItems.getItemById(this.placedItemId != null ? this.placedItemId : this.getItemID()).build();
        }
    }

    public Entity place(Location location) {
        this.setPlacedItem();
        return this.place(location, this.placedItem, Float.valueOf(0.0f), BlockFace.NORTH, true);
    }

    public Entity place(Location location, Float yaw, BlockFace facing) {
        this.setPlacedItem();
        return this.place(location, this.placedItem, yaw, facing, true);
    }

    public Entity place(Location location, ItemStack originalItem, Float yaw, BlockFace facing, boolean checkSpace) {
        if (!location.isWorldLoaded()) {
            return null;
        }
        if (checkSpace && this.notEnoughSpace(yaw.floatValue(), location)) {
            return null;
        }
        assert (location.getWorld() != null);
        this.setPlacedItem();
        assert (location.getWorld() != null);
        Class<ItemFrame> entityClass = this.getFurnitureEntityType().getEntityClass();
        if (entityClass == null) {
            entityClass = ItemFrame.class;
        }
        ItemStack item = this.evolvingFurniture == null ? ItemUtils.editItemMeta(originalItem.clone(), meta -> meta.setDisplayName("")) : this.placedItem;
        item.setAmount(1);
        Entity baseEntity = EntityUtils.spawnEntity(this.correctedSpawnLocation(location, facing), entityClass, e -> this.setEntityData((Entity)e, yaw.floatValue(), item, facing));
        if (this.isModelEngine() && PluginUtils.isEnabled("ModelEngine")) {
            this.spawnModelEngineFurniture(baseEntity);
        }
        return baseEntity;
    }

    private Location correctedSpawnLocation(Location baseLocation, BlockFace facing) {
        float scale;
        boolean isFixed;
        Location correctedLocation = BlockHelpers.toCenterBlockLocation(baseLocation);
        boolean isWall = this.hasLimitedPlacing() && this.limitedPlacing.isWall();
        boolean isRoof = this.hasLimitedPlacing() && this.limitedPlacing.isRoof();
        boolean bl = isFixed = this.hasDisplayEntityProperties() && this.displayEntityProperties.getDisplayTransform() == ItemDisplay.ItemDisplayTransform.FIXED;
        if (this.furnitureType != FurnitureType.DISPLAY_ENTITY || !this.hasDisplayEntityProperties()) {
            return correctedLocation;
        }
        if (this.displayEntityProperties.getDisplayTransform() != ItemDisplay.ItemDisplayTransform.NONE && !isWall && !isRoof) {
            return correctedLocation;
        }
        float f = scale = this.displayEntityProperties.hasScale() ? this.displayEntityProperties.getScale().y() : 1.0f;
        if (isFixed && isWall) {
            correctedLocation.add((double)(-facing.getModX()) * (0.49 * (double)scale), 0.0, (double)(-facing.getModZ()) * (0.49 * (double)scale));
        }
        float heightCorrection = (this.hasHitbox() ? this.hitbox.height : 1.0f) - 1.0f;
        return correctedLocation.add(0.0, 0.5 * (double)scale + (isRoof ? (isFixed ? 0.49 : (double)(-1.0f * heightCorrection)) : 0.0), 0.0);
    }

    public void setEntityData(Entity entity, float yaw, BlockFace facing) {
        this.setEntityData(entity, yaw, FurnitureMechanic.getFurnitureItem(entity), facing);
    }

    public void setEntityData(Entity entity, float yaw, ItemStack item, BlockFace facing) {
        this.setBaseFurnitureData(entity);
        Location location = entity.getLocation();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            this.setFrameData(frame, item, yaw, facing);
            if (this.hasBarriers()) {
                this.setBarrierHitbox(entity, location, yaw);
            } else {
                float width = this.hasHitbox() ? this.hitbox.width : 1.0f;
                float height = this.hasHitbox() ? this.hitbox.height : 1.0f;
                Interaction interaction = this.spawnInteractionEntity((Entity)frame, location, width, height);
                Block block = location.getBlock();
                if (this.hasSeat() && interaction != null) {
                    UUID seatUuid = this.spawnSeat(block, this.hasSeatYaw ? this.seatYaw : FurnitureMechanic.getFurnitureYaw((Entity)frame));
                    interaction.getPersistentDataContainer().set(SEAT_KEY, DataType.UUID, (Object)seatUuid);
                    frame.getPersistentDataContainer().set(SEAT_KEY, DataType.UUID, (Object)seatUuid);
                }
                if (this.light.hasLightLevel()) {
                    this.light.createBlockLight(block);
                }
            }
        } else if (entity instanceof ItemDisplay) {
            Location barrierLoc;
            ItemDisplay itemDisplay = (ItemDisplay)entity;
            this.setItemDisplayData(itemDisplay, item, Float.valueOf(yaw), this.displayEntityProperties);
            float width = this.hasHitbox() ? this.hitbox.width : this.displayEntityProperties.getDisplayWidth();
            float height = this.hasHitbox() ? this.hitbox.height : this.displayEntityProperties.getDisplayHeight();
            boolean isFixed = this.displayEntityProperties.getDisplayTransform() == ItemDisplay.ItemDisplayTransform.FIXED;
            Location interactionLoc = location.clone().subtract(0.0, this.hasLimitedPlacing() && this.limitedPlacing.isRoof() && isFixed ? 1.5 * (double)(height - 1.0f) : 0.0, 0.0);
            Interaction interaction = this.spawnInteractionEntity((Entity)itemDisplay, interactionLoc, width, height);
            Location location2 = barrierLoc = EntityUtils.isNone(itemDisplay) && this.displayEntityProperties.hasScale() ? location.clone().subtract(0.0, 0.5 * (double)this.displayEntityProperties.getScale().y(), 0.0) : location;
            if (this.hasBarriers()) {
                this.setBarrierHitbox(entity, barrierLoc, yaw);
            } else if (this.hasSeat() && interaction != null) {
                UUID seatUuid = this.spawnSeat(location.getBlock(), this.hasSeatYaw ? this.seatYaw : yaw);
                interaction.getPersistentDataContainer().set(SEAT_KEY, DataType.UUID, (Object)seatUuid);
                itemDisplay.getPersistentDataContainer().set(SEAT_KEY, DataType.UUID, (Object)seatUuid);
            }
            if (this.light.hasLightLevel()) {
                this.light.createBlockLight(location.getBlock());
            }
        }
    }

    private Interaction spawnInteractionEntity(Entity entity, Location location, float width, float height) {
        Entity existingInteraction;
        if (!OraxenPlugin.supportsDisplayEntities || width <= 0.0f || height <= 0.0f) {
            return null;
        }
        UUID existingInteractionUUID = (UUID)entity.getPersistentDataContainer().get(INTERACTION_KEY, DataType.UUID);
        if (existingInteractionUUID != null && (existingInteraction = Bukkit.getEntity((UUID)existingInteractionUUID)) instanceof Interaction) {
            Interaction interaction = (Interaction)existingInteraction;
            return interaction;
        }
        Interaction interaction = EntityUtils.spawnEntity(BlockHelpers.toCenterBlockLocation(location), Interaction.class, i -> {
            i.setInteractionWidth(width);
            i.setInteractionHeight(height);
            i.setPersistent(true);
        });
        PersistentDataContainer pdc = interaction.getPersistentDataContainer();
        pdc.set(FURNITURE_KEY, DataType.STRING, (Object)this.getItemID());
        pdc.set(BASE_ENTITY_KEY, DataType.UUID, (Object)entity.getUniqueId());
        entity.getPersistentDataContainer().set(INTERACTION_KEY, DataType.UUID, (Object)interaction.getUniqueId());
        return interaction;
    }

    private void setBaseFurnitureData(Entity entity) {
        entity.setPersistent(true);
        entity.setCustomNameVisible(false);
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        pdc.set(FURNITURE_KEY, PersistentDataType.STRING, (Object)this.getItemID());
        pdc.set(BARRIER_KEY, DataType.asList(BlockLocation.dataType), this.barriers);
        if (this.hasEvolution()) {
            pdc.set(EVOLUTION_KEY, PersistentDataType.INTEGER, (Object)0);
        }
        if (this.isStorage() && this.getStorage().getStorageType() == StorageMechanic.StorageType.STORAGE) {
            pdc.set(StorageMechanic.STORAGE_KEY, DataType.ITEM_STACK_ARRAY, (Object)new ItemStack[0]);
        }
    }

    private void setItemDisplayData(ItemDisplay itemDisplay, ItemStack item, Float yaw, DisplayEntityProperties properties) {
        itemDisplay.setItemDisplayTransform(properties.getDisplayTransform());
        if (properties.hasSpecifiedViewRange()) {
            itemDisplay.setViewRange((float)properties.getViewRange());
        }
        if (properties.hasInterpolationDuration()) {
            itemDisplay.setInterpolationDuration(properties.getInterpolationDuration());
        }
        if (properties.hasInterpolationDelay()) {
            itemDisplay.setInterpolationDelay(properties.getInterpolationDelay());
        }
        if (properties.hasTrackingRotation()) {
            itemDisplay.setBillboard(properties.getTrackingRotation());
        }
        if (properties.hasShadowRadius()) {
            itemDisplay.setShadowRadius(properties.getShadowRadius());
        }
        if (properties.hasShadowStrength()) {
            itemDisplay.setShadowStrength(properties.getShadowStrength());
        }
        if (properties.hasBrightness()) {
            itemDisplay.setBrightness(this.displayEntityProperties.getBrightness());
        }
        itemDisplay.setDisplayWidth(properties.getDisplayWidth());
        itemDisplay.setDisplayHeight(properties.getDisplayHeight());
        itemDisplay.setItemStack(item);
        boolean isFixed = properties.getDisplayTransform().equals((Object)ItemDisplay.ItemDisplayTransform.FIXED);
        Transformation transform = itemDisplay.getTransformation();
        if (properties.hasScale()) {
            transform.getScale().set((Vector3fc)properties.getScale());
        } else {
            transform.getScale().set((Vector3fc)(isFixed ? new Vector3f(0.5f, 0.5f, 0.5f) : new Vector3f(1.0f, 1.0f, 1.0f)));
        }
        yaw = Float.valueOf(VersionUtil.atOrAbove("1.20.1") && (!this.hasLimitedPlacing() || !this.limitedPlacing.isRoof() || !isFixed) ? yaw.floatValue() : yaw.floatValue() - 180.0f);
        float pitch = VersionUtil.atOrAbove("1.20.1") ? (this.hasLimitedPlacing() && isFixed ? (this.limitedPlacing.isFloor() ? -90.0f : (this.limitedPlacing.isRoof() ? 90.0f : 0.0f)) : 0.0f) : (isFixed && this.hasLimitedPlacing() ? (this.limitedPlacing.isFloor() ? 90.0f : (this.limitedPlacing.isWall() ? 0.0f : (this.limitedPlacing.isRoof() ? -90.0f : 0.0f))) : 0.0f);
        itemDisplay.setTransformation(transform);
        itemDisplay.setRotation(yaw.floatValue(), pitch);
    }

    private void setFrameData(ItemFrame frame, ItemStack item, float yaw, BlockFace facing) {
        frame.setVisible(false);
        frame.setItemDropChance(0.0f);
        frame.setFacingDirection(facing, true);
        frame.setItem(item, false);
        frame.setRotation(FurnitureMechanic.yawToRotation(yaw));
        if (this.hasLimitedPlacing()) {
            if (this.limitedPlacing.isFloor() && !this.limitedPlacing.isWall() && frame.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isSolid()) {
                frame.setFacingDirection(BlockFace.UP, true);
            } else if (this.limitedPlacing.isWall() && facing.getModY() == 0) {
                frame.setRotation(Rotation.NONE);
            } else if (this.limitedPlacing.isRoof() && facing == BlockFace.DOWN) {
                frame.setFacingDirection(BlockFace.DOWN, true);
            }
        }
    }

    private void setBarrierHitbox(Entity entity, Location location, float yaw) {
        List<Location> barrierLocations = this.getLocations(yaw, BlockHelpers.toCenterBlockLocation(location), this.barriers);
        for (Location barrierLocation : barrierLocations) {
            Block block = barrierLocation.getBlock();
            block.setType(Material.BARRIER);
            PersistentDataContainer data = BlockHelpers.getPDC(block);
            data.set(FURNITURE_KEY, PersistentDataType.STRING, (Object)this.getItemID());
            if (this.hasSeat) {
                data.set(SEAT_KEY, DataType.UUID, (Object)this.spawnSeat(block, this.hasSeatYaw ? this.seatYaw : yaw));
            }
            data.set(ROOT_KEY, PersistentDataType.STRING, (Object)new BlockLocation(location.clone()).toString());
            data.set(ORIENTATION_KEY, PersistentDataType.FLOAT, (Object)Float.valueOf(yaw));
            data.set(BASE_ENTITY_KEY, DataType.UUID, (Object)entity.getUniqueId());
            if (!this.light.hasLightLevel()) continue;
            this.light.createBlockLight(block);
        }
    }

    void spawnModelEngineFurniture(Entity entity) {
        ModeledEntity modelEntity = ModelEngineAPI.getOrCreateModeledEntity((Entity)entity);
        ActiveModel activeModel = ModelEngineAPI.createActiveModel((String)this.getModelEngineID());
        ModelEngineUtils.addModel(modelEntity, activeModel, false);
        ModelEngineUtils.setRotationLock(modelEntity, false);
        modelEntity.setBaseEntityVisible(false);
    }

    public static ItemStack getFurnitureItem(Entity entity) {
        return switch (entity.getType()) {
            case EntityType.ARMOR_STAND -> ((ArmorStand)entity).getEquipment().getHelmet();
            case EntityType.ITEM_DISPLAY -> {
                if (OraxenPlugin.supportsDisplayEntities) {
                    yield ((ItemDisplay)entity).getItemStack();
                }
                yield null;
            }
            default -> ((ItemFrame)entity).getItem();
        };
    }

    public static void setFurnitureItem(Entity entity, ItemStack item) {
        switch (entity.getType()) {
            case ITEM_FRAME: 
            case GLOW_ITEM_FRAME: {
                ((ItemFrame)entity).setItem(item, false);
                break;
            }
            case ARMOR_STAND: {
                ((ArmorStand)entity).getEquipment().setHelmet(item);
                break;
            }
            case ITEM_DISPLAY: {
                if (!OraxenPlugin.supportsDisplayEntities) break;
                ((ItemDisplay)entity).setItemStack(item);
                break;
            }
        }
    }

    public void removeSolid(Entity baseEntity, Location rootLocation, float orientation) {
        List<BlockLocation> blockLocations = (List<BlockLocation>)baseEntity.getPersistentDataContainer().getOrDefault(BARRIER_KEY, DataType.asList(BlockLocation.dataType), new ArrayList());
        List<Location> barrierLocations = this.getLocations(orientation, rootLocation, blockLocations.isEmpty() ? this.getBarriers() : blockLocations);
        for (Location location : barrierLocations) {
            Block block = location.getBlock();
            if (this.hasSeat) {
                this.removeFurnitureSeat(location);
            }
            if (block.getType() != Material.BARRIER || !((UUID)BlockHelpers.getPDC(block).getOrDefault(BASE_ENTITY_KEY, DataType.UUID, (Object)UUID.randomUUID())).equals(baseEntity.getUniqueId())) continue;
            block.setType(Material.AIR);
            new CustomBlockData(location.getBlock(), (Plugin)OraxenPlugin.get()).clear();
            if (!this.light.hasLightLevel()) continue;
            this.light.removeBlockLight(block);
        }
        this.removeBaseEntity(baseEntity);
    }

    public void removeNonSolidFurniture(Entity baseEntity) {
        this.removeBaseEntity(baseEntity);
    }

    private void removeBaseEntity(Entity baseEntity) {
        if (baseEntity == null) {
            return;
        }
        this.removeSubEntitiesOfFurniture(baseEntity);
        if (this.light.hasLightLevel()) {
            this.light.removeBlockLight(baseEntity.getLocation().getBlock());
        }
        if (!baseEntity.isDead()) {
            baseEntity.remove();
        }
    }

    private void removeSubEntitiesOfFurniture(Entity baseEntity) {
        Interaction interaction;
        if (this.light.hasLightLevel()) {
            this.light.removeBlockLight(baseEntity.getLocation().getBlock());
        }
        if (this.hasSeat) {
            this.removeFurnitureSeat(baseEntity.getLocation());
        }
        if (OraxenPlugin.supportsDisplayEntities && (interaction = this.getInteractionEntity(baseEntity)) != null && !interaction.isDead()) {
            interaction.remove();
        }
    }

    private void removeFurnitureSeat(Location location) {
        ArmorStand seat = FurnitureMechanic.getSeat(location);
        if (seat != null) {
            seat.getPassengers().forEach(arg_0 -> ((ArmorStand)seat).removePassenger(arg_0));
            if (!seat.isDead()) {
                seat.remove();
            }
        }
    }

    public List<Location> getLocations(float rotation, Location center, List<BlockLocation> relativeCoordinates) {
        ArrayList<Location> output = new ArrayList<Location>();
        for (BlockLocation modifier : relativeCoordinates) {
            output.add(modifier.groundRotate(rotation).add(center));
        }
        return output;
    }

    public boolean notEnoughSpace(float yaw, Location rootLocation) {
        if (!this.hasBarriers()) {
            return false;
        }
        return !this.getLocations(yaw, rootLocation, this.getBarriers()).stream().map(l -> l.getBlock().getType()).allMatch(BlockHelpers.REPLACEABLE_BLOCKS::contains);
    }

    public static float getFurnitureYaw(Entity entity) {
        FurnitureMechanic mechanic = OraxenFurniture.getFurnitureMechanic(entity);
        if (mechanic == null) {
            return entity.getLocation().getYaw();
        }
        if (entity instanceof ItemFrame) {
            ItemFrame itemFrame = (ItemFrame)entity;
            if (mechanic.hasLimitedPlacing() && mechanic.limitedPlacing.isWall() && itemFrame.getFacing().getModY() == 0) {
                return entity.getLocation().getYaw();
            }
            return FurnitureMechanic.rotationToYaw(itemFrame.getRotation());
        }
        return entity.getLocation().getYaw();
    }

    public static float rotationToYaw(Rotation rotation) {
        return (float)Arrays.asList(Rotation.values()).indexOf(rotation) * 360.0f / 8.0f;
    }

    public static Rotation yawToRotation(float yaw) {
        return Rotation.values()[Math.round(yaw / 45.0f) & 7];
    }

    public boolean hasClickActions() {
        return !this.clickActions.isEmpty();
    }

    public void runClickActions(Player player) {
        for (ClickAction action : this.clickActions) {
            if (!action.canRun(player)) continue;
            action.performActions(player);
        }
    }

    private UUID spawnSeat(Block target, float yaw) {
        ArmorStand seat = EntityUtils.spawnEntity(target.getLocation().add(0.5, (double)(this.seatHeight - 1.0f), 0.5), ArmorStand.class, stand -> {
            stand.setVisible(false);
            stand.setRotation(yaw, 0.0f);
            stand.setInvulnerable(true);
            stand.setPersistent(true);
            stand.setAI(false);
            stand.setCollidable(false);
            stand.setGravity(false);
            stand.setSilent(true);
            stand.setCustomNameVisible(false);
            stand.setCanPickupItems(false);
            stand.addEquipmentLock(EquipmentSlot.HEAD, ArmorStand.LockType.ADDING_OR_CHANGING);
            stand.addEquipmentLock(EquipmentSlot.HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            stand.addEquipmentLock(EquipmentSlot.OFF_HAND, ArmorStand.LockType.ADDING_OR_CHANGING);
            stand.addEquipmentLock(EquipmentSlot.CHEST, ArmorStand.LockType.ADDING_OR_CHANGING);
            stand.addEquipmentLock(EquipmentSlot.LEGS, ArmorStand.LockType.ADDING_OR_CHANGING);
            stand.addEquipmentLock(EquipmentSlot.FEET, ArmorStand.LockType.ADDING_OR_CHANGING);
            stand.getPersistentDataContainer().set(FURNITURE_KEY, PersistentDataType.STRING, (Object)this.getItemID());
        });
        return seat.getUniqueId();
    }

    @Nullable
    public Entity getBaseEntity(Block block) {
        PersistentDataContainer pdc = BlockHelpers.getPDC(block);
        if (pdc.isEmpty()) {
            return null;
        }
        BlockLocation blockLoc = new BlockLocation(Objects.requireNonNull((String)pdc.get(ROOT_KEY, PersistentDataType.STRING)));
        Location originLoc = blockLoc.toLocation(block.getWorld());
        if (pdc.has(BASE_ENTITY_KEY, DataType.UUID)) {
            return Bukkit.getEntity((UUID)((UUID)pdc.getOrDefault(BASE_ENTITY_KEY, DataType.UUID, (Object)UUID.randomUUID())));
        }
        if (this.hasBarriers()) {
            for (Entity entity : block.getWorld().getNearbyEntities(originLoc, 1.0, 1.0, 1.0)) {
                if (entity.getType() != this.getFurnitureEntityType() || entity.getLocation().getBlockX() != originLoc.getBlockX() || entity.getLocation().getBlockY() != originLoc.getBlockY() || entity.getLocation().getBlockZ() != originLoc.getBlockZ() || !OraxenFurniture.isFurniture(block)) continue;
                return this.getBaseEntity(entity);
            }
        }
        return null;
    }

    @Nullable
    public Entity getBaseEntity(Entity entity) {
        if (this.getFurnitureEntityType() == entity.getType()) {
            return entity;
        }
        UUID baseEntityUUID = (UUID)entity.getPersistentDataContainer().get(BASE_ENTITY_KEY, DataType.UUID);
        if (baseEntityUUID == null && OraxenFurniture.isFurniture(entity) && !OraxenFurniture.isInteractionEntity(entity)) {
            return entity;
        }
        return baseEntityUUID != null && Bukkit.getEntity((UUID)baseEntityUUID) != null ? Bukkit.getEntity((UUID)baseEntityUUID) : this.getBaseEntityAlter(entity);
    }

    @Nullable
    private Entity getBaseEntityAlter(Entity entity) {
        if (this.getFurnitureEntityType() == entity.getType()) {
            return entity;
        }
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        Location location = (Location)pdc.get(ROOT_KEY, DataType.LOCATION);
        if (location == null || !location.isWorldLoaded()) {
            return null;
        }
        assert (location.getWorld() != null);
        for (Entity baseEntity : location.getWorld().getNearbyEntities(location, 0.1, 0.1, 0.1)) {
            if (baseEntity.getType() != this.getFurnitureEntityType() || !OraxenFurniture.isFurniture(baseEntity)) continue;
            entity.getPersistentDataContainer().set(BASE_ENTITY_KEY, DataType.UUID, (Object)baseEntity.getUniqueId());
            return baseEntity;
        }
        return null;
    }

    @Nullable
    public Interaction getInteractionEntity(@NotNull Entity baseEntity) {
        Interaction interaction;
        Entity entity;
        UUID interactionUUID = (UUID)baseEntity.getPersistentDataContainer().get(INTERACTION_KEY, DataType.UUID);
        return OraxenPlugin.supportsDisplayEntities && interactionUUID != null && (entity = Bukkit.getEntity((UUID)interactionUUID)) instanceof Interaction ? (interaction = (Interaction)entity) : this.getInteractionEntityAlter(baseEntity);
    }

    @Nullable
    private Interaction getInteractionEntityAlter(Entity baseEntity) {
        if (OraxenPlugin.supportsDisplayEntities) {
            for (Entity entity : baseEntity.getNearbyEntities(0.1, 0.1, 0.1)) {
                Interaction interaction;
                PersistentDataContainer pdc;
                if (!(entity instanceof Interaction) || !(pdc = (interaction = (Interaction)entity).getPersistentDataContainer()).has(FURNITURE_KEY, DataType.STRING) || !((String)pdc.getOrDefault(FURNITURE_KEY, DataType.STRING, (Object)"")).equals(this.getItemID()) || !pdc.has(ROOT_KEY, DataType.LOCATION) || !Objects.equals(pdc.get(ROOT_KEY, DataType.LOCATION), baseEntity.getLocation())) continue;
                baseEntity.getPersistentDataContainer().set(INTERACTION_KEY, DataType.UUID, (Object)interaction.getUniqueId());
                return interaction;
            }
        }
        return null;
    }

    public FurnitureType getFurnitureType() {
        return this.furnitureType;
    }

    public EntityType getFurnitureEntityType() {
        return switch (this.furnitureType) {
            default -> throw new IncompatibleClassChangeError();
            case FurnitureType.ITEM_FRAME -> EntityType.ITEM_FRAME;
            case FurnitureType.GLOW_ITEM_FRAME -> EntityType.GLOW_ITEM_FRAME;
            case FurnitureType.DISPLAY_ENTITY -> OraxenPlugin.supportsDisplayEntities ? EntityType.ITEM_DISPLAY : EntityType.ITEM_FRAME;
        };
    }

    public Class<? extends Entity> getFurnitureEntityClass() {
        return switch (this.furnitureType) {
            default -> throw new IncompatibleClassChangeError();
            case FurnitureType.ITEM_FRAME -> ItemFrame.class;
            case FurnitureType.GLOW_ITEM_FRAME -> GlowItemFrame.class;
            case FurnitureType.DISPLAY_ENTITY -> OraxenPlugin.supportsDisplayEntities ? ItemDisplay.class : ItemFrame.class;
        };
    }

    public boolean hasDisplayEntityProperties() {
        return this.displayEntityProperties != null;
    }

    public DisplayEntityProperties getDisplayEntityProperties() {
        return this.displayEntityProperties;
    }

    public static void sitOnSeat(PersistentDataContainer pdc, Player player) {
        Entity stand;
        UUID entityUuid;
        UUID uUID = entityUuid = pdc.has(SEAT_KEY, DataType.UUID) ? (UUID)pdc.get(SEAT_KEY, DataType.UUID) : null;
        if (entityUuid == null) {
            String oldUUID;
            String string = oldUUID = pdc.has(SEAT_KEY, PersistentDataType.STRING) ? (String)pdc.get(SEAT_KEY, PersistentDataType.STRING) : null;
            if (oldUUID != null) {
                entityUuid = UUID.fromString(oldUUID);
                pdc.remove(SEAT_KEY);
                pdc.set(SEAT_KEY, DataType.UUID, (Object)entityUuid);
            }
        }
        if (entityUuid != null && (stand = Bukkit.getEntity((UUID)entityUuid)) != null && stand.getPassengers().isEmpty()) {
            stand.addPassenger((Entity)player);
        }
    }

    public RestrictedRotation getRestrictedRotation() {
        return this.restrictedRotation;
    }

    public void rotateFurniture(Entity baseEntity) {
        float yaw = FurnitureMechanic.getFurnitureYaw(baseEntity);
        Rotation newRotation = this.rotateClockwise(FurnitureMechanic.yawToRotation(yaw));
        if (baseEntity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)baseEntity;
            frame.setRotation(newRotation);
        } else {
            baseEntity.setRotation(FurnitureMechanic.rotationToYaw(newRotation), baseEntity.getLocation().getPitch());
        }
    }

    private Rotation rotateClockwise(Rotation rotation) {
        int offset = this.restrictedRotation == RestrictedRotation.VERY_STRICT ? 2 : 1;
        return Rotation.values()[rotation.ordinal() + offset & 7];
    }

    public BlockLockerMechanic getBlockLocker() {
        return this.blockLocker;
    }

    public boolean hasLight() {
        return this.light.hasLightLevel();
    }

    public LightMechanic getLight() {
        return this.light;
    }

    public static enum RestrictedRotation {
        NONE,
        STRICT,
        VERY_STRICT;


        public static RestrictedRotation fromString(String string) {
            try {
                return RestrictedRotation.valueOf(string);
            }
            catch (IllegalArgumentException e) {
                Logs.logError("Invalid restricted rotation: " + string);
                Logs.logError("Allowed ones are: " + Arrays.toString((Object[])RestrictedRotation.values()));
                Logs.logWarning("Setting to STRICT");
                return STRICT;
            }
        }
    }

    public static enum FurnitureType {
        ITEM_FRAME,
        GLOW_ITEM_FRAME,
        DISPLAY_ENTITY;


        public static List<Class<? extends Entity>> furnitureEntityClasses() {
            ArrayList<Class<? extends Entity>> list = new ArrayList<Class<? extends Entity>>(List.of(ItemFrame.class, GlowItemFrame.class, ArmorStand.class));
            if (OraxenPlugin.supportsDisplayEntities) {
                list.add(ItemDisplay.class);
            }
            return list;
        }

        public static FurnitureType getType(String type) {
            try {
                return FurnitureType.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                Logs.logError("Invalid furniture type: " + type + ", set in mechanics.yml.");
                Logs.logWarning("Using default " + (OraxenPlugin.supportsDisplayEntities ? "DISPLAY_ENTITY" : "ITEM_FRAME"), true);
                return OraxenPlugin.supportsDisplayEntities ? DISPLAY_ENTITY : ITEM_FRAME;
            }
        }
    }

    public record FurnitureHitbox(float width, float height) {
    }
}

