/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane;

import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.exception.XMLReflectionException;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.OutlinePane;
import com.github.stefvanschie.inventoryframework.pane.util.Mask;
import com.github.stefvanschie.inventoryframework.pane.util.Slot;
import com.github.stefvanschie.inventoryframework.util.SkullUtil;
import com.github.stefvanschie.inventoryframework.util.UUIDTagType;
import com.github.stefvanschie.inventoryframework.util.XMLUtil;
import com.google.common.primitives.Primitives;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Pane {
    @Deprecated
    protected int x = 0;
    @Deprecated
    protected int y = 0;
    @NotNull
    protected Slot slot = Slot.fromXY(0, 0);
    protected int length;
    protected int height;
    private boolean visible;
    @NotNull
    private Priority priority;
    @Nullable
    protected Consumer<InventoryClickEvent> onClick;
    protected UUID uuid;
    @NotNull
    private static final Map<String, Function<String, Object>> PROPERTY_MAPPINGS = new HashMap<String, Function<String, Object>>();

    protected Pane(@NotNull Slot slot, int length, int height, @NotNull Priority priority) {
        if (length == 0 || height == 0) {
            throw new IllegalArgumentException("Length and height of pane must be greater than zero");
        }
        this.setSlot(slot);
        this.length = length;
        this.height = height;
        this.priority = priority;
        this.visible = true;
        this.uuid = UUID.randomUUID();
    }

    protected Pane(int x, int y, int length, int height, @NotNull Priority priority) {
        this(Slot.fromXY(x, y), length, height, priority);
    }

    protected Pane(int length, int height) {
        if (length == 0 || height == 0) {
            throw new IllegalArgumentException("Length and height of pane must be greater than zero");
        }
        this.length = length;
        this.height = height;
        this.priority = Priority.NORMAL;
        this.visible = true;
        this.uuid = UUID.randomUUID();
    }

    protected Pane(Slot slot, int length, int height) {
        this(slot, length, height, Priority.NORMAL);
    }

    protected Pane(int x, int y, int length, int height) {
        this(x, y, length, height, Priority.NORMAL);
    }

    @NotNull
    @Contract(pure=true)
    public Pane copy() {
        throw new UnsupportedOperationException("The implementing pane hasn't overridden the copy method");
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSlot(@NotNull Slot slot) {
        this.slot = slot;
        this.x = slot.getX(1);
        this.y = slot.getY(1);
    }

    public void setX(int x) {
        this.x = x;
        this.slot = Slot.fromXY(x, this.getY());
    }

    public void setY(int y) {
        this.y = y;
        this.slot = Slot.fromXY(this.getX(), y);
    }

    @Contract(pure=true)
    public int getLength() {
        return this.length;
    }

    @Contract(pure=true)
    public int getHeight() {
        return this.height;
    }

    @NotNull
    @Contract(pure=true)
    public UUID getUUID() {
        return this.uuid;
    }

    @NotNull
    @Contract(pure=true)
    public Slot getSlot() {
        return this.slot;
    }

    @Deprecated
    @Contract(pure=true)
    public int getX() {
        return this.x;
    }

    @Deprecated
    @Contract(pure=true)
    public int getY() {
        return this.y;
    }

    public abstract void display(@NotNull InventoryComponent var1, int var2, int var3, int var4, int var5);

    @Contract(pure=true)
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public abstract boolean click(@NotNull Gui var1, @NotNull InventoryComponent var2, @NotNull InventoryClickEvent var3, int var4, int var5, int var6, int var7, int var8);

    public void setPriority(@NotNull Priority priority) {
        this.priority = priority;
    }

    @NotNull
    @Contract(pure=true)
    public static GuiItem loadItem(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        String id = element.getAttribute("id");
        Material material = Material.matchMaterial((String)id.toUpperCase(Locale.getDefault()));
        if (material == null) {
            throw new XMLLoadException("Can't find material for '" + id + "'");
        }
        boolean hasAmount = element.hasAttribute("amount");
        boolean hasDamage = element.hasAttribute("damage");
        int amount = hasAmount ? Integer.parseInt(element.getAttribute("amount")) : 1;
        short damage = hasDamage ? Short.parseShort(element.getAttribute("damage")) : (short)0;
        ItemStack itemStack = new ItemStack(material, amount, damage);
        ArrayList<Object> properties = new ArrayList<Object>();
        if (element.hasChildNodes()) {
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                ItemMeta itemMeta;
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1) continue;
                Element elementItem = (Element)item;
                String nodeName = item.getNodeName();
                if (nodeName.equals("properties") || nodeName.equals("lore") || nodeName.equals("enchantments")) {
                    Element innerElement = (Element)item;
                    NodeList innerChildNodes = innerElement.getChildNodes();
                    block11: for (int j = 0; j < innerChildNodes.getLength(); ++j) {
                        Node innerNode = innerChildNodes.item(j);
                        if (innerNode.getNodeType() != 1) continue;
                        Element innerElementChild = (Element)innerNode;
                        ItemMeta itemMeta2 = Objects.requireNonNull(itemStack.getItemMeta());
                        switch (nodeName) {
                            case "properties": {
                                if (!innerNode.getNodeName().equals("property")) continue block11;
                                String propertyType = innerElementChild.hasAttribute("type") ? innerElementChild.getAttribute("type") : "string";
                                properties.add(PROPERTY_MAPPINGS.get(propertyType).apply(innerElementChild.getTextContent()));
                                continue block11;
                            }
                            case "lore": {
                                if (!innerNode.getNodeName().equals("line")) continue block11;
                                TextHolder.deserialize(innerNode.getTextContent()).asItemLoreAtEnd(itemMeta2);
                                itemStack.setItemMeta(itemMeta2);
                                continue block11;
                            }
                            case "enchantments": {
                                if (!innerNode.getNodeName().equals("enchantment")) continue block11;
                                Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)innerElementChild.getAttribute("id").toUpperCase(Locale.getDefault())));
                                if (enchantment == null) {
                                    throw new XMLLoadException("Enchantment cannot be found");
                                }
                                int level = Integer.parseInt(innerElementChild.getAttribute("level"));
                                itemMeta2.addEnchant(enchantment, level, true);
                                itemStack.setItemMeta(itemMeta2);
                            }
                        }
                    }
                    continue;
                }
                if (nodeName.equals("displayname")) {
                    itemMeta = Objects.requireNonNull(itemStack.getItemMeta());
                    TextHolder.deserialize(item.getTextContent()).asItemDisplayName(itemMeta);
                    itemStack.setItemMeta(itemMeta);
                    continue;
                }
                if (nodeName.equals("modeldata")) {
                    itemMeta = Objects.requireNonNull(itemStack.getItemMeta());
                    itemMeta.setCustomModelData(Integer.valueOf(Integer.parseInt(item.getTextContent())));
                    itemStack.setItemMeta(itemMeta);
                    continue;
                }
                if (!nodeName.equals("skull") || !(itemStack.getItemMeta() instanceof SkullMeta)) continue;
                SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                if (elementItem.hasAttribute("owner")) {
                    skullMeta.setOwner(elementItem.getAttribute("owner"));
                } else if (elementItem.hasAttribute("id")) {
                    SkullUtil.setSkull((ItemMeta)skullMeta, elementItem.getAttribute("id"));
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
            }
        }
        Consumer<InventoryClickEvent> action = null;
        if (element.hasAttribute("onClick")) {
            String methodName = element.getAttribute("onClick");
            for (Method method : instance.getClass().getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                int parameterCount = method.getParameterCount();
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterCount == 0) {
                    action = event -> {
                        try {
                            method.setAccessible(true);
                            method.invoke(instance, new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException exception) {
                            throw new XMLReflectionException(exception);
                        }
                    };
                    break;
                }
                if (!parameterTypes[0].isAssignableFrom(InventoryClickEvent.class)) break;
                if (parameterCount == 1) {
                    action = event -> {
                        try {
                            method.setAccessible(true);
                            method.invoke(instance, event);
                        }
                        catch (IllegalAccessException | InvocationTargetException exception) {
                            throw new XMLReflectionException(exception);
                        }
                    };
                    break;
                }
                if (parameterCount != properties.size() + 1) break;
                boolean correct = true;
                for (int i = 0; i < properties.size(); ++i) {
                    Object attribute = properties.get(i);
                    if (parameterTypes[1 + i].isPrimitive() && parameterTypes[1 + i].isAssignableFrom(Primitives.unwrap(attribute.getClass())) || parameterTypes[1 + i].isAssignableFrom(attribute.getClass())) continue;
                    correct = false;
                }
                if (!correct) break;
                action = event -> {
                    try {
                        properties.add(0, event);
                        method.setAccessible(true);
                        method.invoke(instance, properties.toArray(new Object[0]));
                        properties.remove(0);
                    }
                    catch (IllegalAccessException | InvocationTargetException exception) {
                        throw new XMLReflectionException(exception);
                    }
                };
                break;
            }
        }
        GuiItem item = new GuiItem(itemStack, action, plugin);
        if (element.hasAttribute("field")) {
            XMLUtil.loadFieldAttribute(instance, element, item);
        }
        if (element.hasAttribute("populate")) {
            XMLUtil.invokeMethod(instance, element.getAttribute("populate"), item, GuiItem.class);
        }
        item.setProperties(properties);
        return item;
    }

    @NotNull
    @Contract(pure=true)
    public static GuiItem loadItem(@NotNull Object instance, @NotNull Element element) {
        return Pane.loadItem(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(Pane.class));
    }

    public static void load(@NotNull Pane pane, @NotNull Object instance, @NotNull Element element) {
        pane.setSlot(Slot.deserialize(element));
        if (element.hasAttribute("priority")) {
            pane.setPriority(Priority.valueOf(element.getAttribute("priority").toUpperCase()));
        }
        if (element.hasAttribute("visible")) {
            pane.setVisible(Boolean.parseBoolean(element.getAttribute("visible")));
        }
        if (element.hasAttribute("field")) {
            XMLUtil.loadFieldAttribute(instance, element, pane);
        }
        if (element.hasAttribute("onClick")) {
            pane.setOnClick(XMLUtil.loadOnEventAttribute(instance, element, InventoryClickEvent.class, "onClick"));
        }
        if (element.hasAttribute("populate")) {
            String attribute = element.getAttribute("populate");
            for (Method method : instance.getClass().getMethods()) {
                if (!method.getName().equals(attribute)) continue;
                try {
                    method.setAccessible(true);
                    method.invoke(instance, pane);
                }
                catch (IllegalAccessException | InvocationTargetException exception) {
                    throw new XMLLoadException(exception);
                }
            }
        }
    }

    @Nullable
    @Contract(pure=true)
    protected static <T extends GuiItem> T findMatchingItem(@NotNull Collection<T> items, @NotNull ItemStack item) {
        for (GuiItem guiItem : items) {
            ItemMeta meta = item.getItemMeta();
            if (meta == null) {
                return null;
            }
            UUID uuid = (UUID)meta.getPersistentDataContainer().get(guiItem.getKey(), (PersistentDataType)UUIDTagType.INSTANCE);
            if (!guiItem.getUUID().equals(uuid)) continue;
            return (T)guiItem;
        }
        return null;
    }

    @NotNull
    public Priority getPriority() {
        return this.priority;
    }

    @NotNull
    @Contract(pure=true)
    public abstract Collection<GuiItem> getItems();

    @NotNull
    @Contract(pure=true)
    public abstract Collection<Pane> getPanes();

    public abstract void clear();

    public void setOnClick(@Nullable Consumer<InventoryClickEvent> onClick) {
        this.onClick = onClick;
    }

    protected void callOnClick(@NotNull InventoryClickEvent event) {
        if (this.onClick == null) {
            return;
        }
        try {
            this.onClick.accept(event);
        }
        catch (Throwable t) {
            throw new RuntimeException("Exception while handling click event in inventory '" + event.getView().getTitle() + "', slot=" + event.getSlot() + ", for " + this.getClass().getSimpleName() + ", x=" + this.getX() + ", y=" + this.getY() + ", length=" + this.length + ", height=" + this.height, t);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static Pane createBorder(Slot slot, int length, int height, @NotNull GuiItem item) {
        if (length < 0) {
            throw new IllegalArgumentException("Length should be non-negative");
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height should be non-negative");
        }
        String[] mask = new String[height];
        if (height > 0) {
            mask[0] = Pane.createLine(length);
        }
        if (height > 1) {
            mask[height - 1] = Pane.createLine(length);
        }
        for (int yIndex = 1; yIndex < height - 1; ++yIndex) {
            StringBuilder builder = new StringBuilder("1");
            for (int i = 0; i < length - 2; ++i) {
                builder.append('0');
            }
            mask[yIndex] = builder.append('1').toString();
        }
        OutlinePane pane = new OutlinePane(slot, length, height);
        pane.applyMask(new Mask(mask));
        pane.addItem(item);
        pane.setRepeat(true);
        return pane;
    }

    @NotNull
    @Contract(pure=true)
    public static Pane createBorder(int x, int y, int length, int height, @NotNull GuiItem item) {
        return Pane.createBorder(Slot.fromXY(x, y), length, height, item);
    }

    public static void registerProperty(@NotNull String attributeName, @NotNull Function<String, Object> function) {
        if (PROPERTY_MAPPINGS.containsKey(attributeName)) {
            throw new IllegalArgumentException("property '" + attributeName + "' is already registered");
        }
        PROPERTY_MAPPINGS.put(attributeName, function);
    }

    @NotNull
    @Contract(pure=true)
    private static String createLine(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Length should be non-negative");
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append('1');
        }
        return builder.toString();
    }

    static {
        PROPERTY_MAPPINGS.put("boolean", Boolean::parseBoolean);
        PROPERTY_MAPPINGS.put("byte", Byte::parseByte);
        PROPERTY_MAPPINGS.put("character", value -> Character.valueOf(value.charAt(0)));
        PROPERTY_MAPPINGS.put("double", Double::parseDouble);
        PROPERTY_MAPPINGS.put("float", Float::parseFloat);
        PROPERTY_MAPPINGS.put("integer", Integer::parseInt);
        PROPERTY_MAPPINGS.put("long", Long::parseLong);
        PROPERTY_MAPPINGS.put("short", Short::parseShort);
        PROPERTY_MAPPINGS.put("string", value -> value);
    }

    public static enum Priority {
        LOWEST{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority != this;
            }
        }
        ,
        LOW{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority != this && priority != LOWEST;
            }
        }
        ,
        NORMAL{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority != this && priority != LOW && priority != LOWEST;
            }
        }
        ,
        HIGH{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority == HIGHEST || priority == MONITOR;
            }
        }
        ,
        HIGHEST{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return priority == MONITOR;
            }
        }
        ,
        MONITOR{

            @Override
            public boolean isLessThan(@NotNull Priority priority) {
                return false;
            }
        };


        @Contract(pure=true)
        public abstract boolean isLessThan(@NotNull Priority var1);

        @Contract(pure=true)
        public boolean isGreaterThan(@NotNull Priority priority) {
            return !this.isLessThan(priority) && this != priority;
        }
    }
}

