/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.inventories;

import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.pane.PaginatedPane;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import com.github.stefvanschie.inventoryframework.pane.util.Slot;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.items.ItemBuilder;
import io.th0rgal.oraxen.items.ItemParser;
import io.th0rgal.oraxen.items.ItemUpdater;
import io.th0rgal.oraxen.utils.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;

public class ItemsView {
    private final YamlConfiguration settings = OraxenPlugin.get().getResourceManager().getSettings();
    ChestGui mainGui;

    public ChestGui create() {
        HashMap<File, ChestGui> files = new HashMap<File, ChestGui>();
        for (File file : OraxenItems.getMap().keySet()) {
            List<ItemBuilder> unexcludedItems = OraxenItems.getUnexcludedItems(file);
            if (unexcludedItems.isEmpty()) continue;
            files.put(file, this.createSubGUI(file.getName(), unexcludedItems));
        }
        this.mainGui = new ChestGui((int)((Integer)Settings.ORAXEN_INV_ROWS.getValue()), Settings.ORAXEN_INV_TITLE.toString());
        StaticPane filesPane = new StaticPane(0, 0, 9, this.mainGui.getRows());
        int i = 0;
        Set<Integer> usedSlots = files.keySet().stream().map(e -> (Integer)this.getItemStack((File)e).getRight()).filter(e -> e > -1).collect(Collectors.toSet());
        for (Map.Entry entry : files.entrySet()) {
            Pair<ItemStack, Integer> itemSlotPair = this.getItemStack((File)entry.getKey());
            ItemStack itemStack = (ItemStack)itemSlotPair.getLeft();
            int slot = (Integer)itemSlotPair.getRight() > -1 ? ((Integer)itemSlotPair.getRight()).intValue() : this.getUnusedSlot(i, usedSlots);
            GuiItem item = new GuiItem(itemStack, event -> ((ChestGui)entry.getValue()).show(event.getWhoClicked()));
            filesPane.addItem(item, Slot.fromXY(slot % 9, slot / 9));
            ++i;
        }
        this.mainGui.addPane(filesPane);
        this.mainGui.setOnTopClick(event -> event.setCancelled(true));
        return this.mainGui;
    }

    private int getUnusedSlot(int i, Set<Integer> usedSlots) {
        int slot = usedSlots.contains(i) ? this.getUnusedSlot(i + 1, usedSlots) : i;
        usedSlots.add(slot);
        return slot;
    }

    private ChestGui createSubGUI(String fileName, List<ItemBuilder> items) {
        int rows = Math.min((items.size() - 1) / 9 + 2, 6);
        ChestGui gui = new ChestGui(6, this.settings.getString(String.format("oraxen_inventory.menu_layout.%s.title", Utils.removeExtension(fileName)), Settings.ORAXEN_INV_TITLE.toString()).replace("<main_menu_title>", Settings.ORAXEN_INV_TITLE.toString()));
        PaginatedPane pane = new PaginatedPane(9, rows);
        for (int i = 0; i < (items.size() - 1) / 45 + 1; ++i) {
            List<ItemStack> itemStackList = this.extractPageItems(items, i);
            StaticPane staticPane = new StaticPane(9, Math.min((itemStackList.size() - 1) / 9 + 1, 5));
            for (int itemIndex = 0; itemIndex < itemStackList.size(); ++itemIndex) {
                ItemStack oraxenItem = itemStackList.get(itemIndex);
                staticPane.addItem(new GuiItem(oraxenItem, event -> event.getWhoClicked().getInventory().addItem(new ItemStack[]{ItemUpdater.updateItem(oraxenItem)})), itemIndex % 9, itemIndex / 9);
            }
            pane.addPane(i, staticPane);
        }
        StaticPane back = new StaticPane(2, 5, 1, 1);
        StaticPane forward = new StaticPane(6, 5, 1, 1);
        StaticPane exit = new StaticPane(4, 5, 9, 1);
        back.addItem(new GuiItem((OraxenItems.getItemById("arrow_previous_icon") == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById("arrow_previous_icon")).build(), event -> {
            pane.setPage(pane.getPage() - 1);
            if (pane.getPage() == 0) {
                back.setVisible(false);
            }
            forward.setVisible(true);
            gui.update();
        }), 0, 0);
        back.setVisible(false);
        forward.addItem(new GuiItem((OraxenItems.getItemById("arrow_next_icon") == null ? new ItemBuilder(Material.ARROW) : OraxenItems.getItemById("arrow_next_icon")).build(), event -> {
            pane.setPage(pane.getPage() + 1);
            if (pane.getPage() == pane.getPages() - 1) {
                forward.setVisible(false);
            }
            back.setVisible(true);
            gui.update();
        }), 0, 0);
        if (pane.getPages() <= 1) {
            forward.setVisible(false);
        }
        exit.addItem(new GuiItem((OraxenItems.getItemById("exit_icon") == null ? new ItemBuilder(Material.BARRIER) : OraxenItems.getItemById("exit_icon")).build(), event -> this.mainGui.show(event.getWhoClicked())), 0, 0);
        gui.addPane(back);
        gui.addPane(forward);
        gui.addPane(exit);
        gui.addPane(pane);
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        return gui;
    }

    private List<ItemStack> extractPageItems(List<ItemBuilder> items, int page) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (int i = page * 45; i < (page + 1) * 45 && i < items.size(); ++i) {
            output.add(items.get(i).build());
        }
        return output;
    }

    private Pair<ItemStack, Integer> getItemStack(File file) {
        ItemStack itemStack;
        String fileName = Utils.removeExtension(file.getName());
        String material = this.settings.getString(String.format("oraxen_inventory.menu_layout.%s.icon", fileName), "PAPER");
        String displayName = ItemParser.parseComponentDisplayName(this.settings.getString(String.format("oraxen_inventory.menu_layout.%s.displayname", fileName), "<green>" + file.getName()));
        try {
            itemStack = new ItemBuilder(OraxenItems.getItemById(material).getReferenceClone()).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setDisplayName(displayName).setLore(new ArrayList<String>()).build();
        }
        catch (Exception e) {
            try {
                itemStack = new ItemBuilder(Material.getMaterial((String)material.toUpperCase())).addItemFlags(ItemFlag.HIDE_ATTRIBUTES).setDisplayName(displayName).build();
            }
            catch (Exception ignored) {
                itemStack = new ItemBuilder(Material.PAPER).setDisplayName(displayName).build();
            }
        }
        if (itemStack == null) {
            itemStack = new ItemBuilder(Material.PAPER).setDisplayName(displayName).build();
        }
        return Pair.of((Object)itemStack, (Object)(this.settings.getInt(String.format("oraxen_inventory.menu_layout.%s.slot", Utils.removeExtension(file.getName())), -1) - 1));
    }
}

