/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.playeranimator.nms.v1_19_R3;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.ticxo.playeranimator.api.nms.INMSHandler;
import com.ticxo.playeranimator.api.nms.IRangeManager;
import com.ticxo.playeranimator.api.nms.IRenderer;
import com.ticxo.playeranimator.api.texture.TextureWrapper;
import com.ticxo.playeranimator.nms.v1_19_R3.entity.RangeManager;
import com.ticxo.playeranimator.nms.v1_19_R3.entity.RendererImpl;
import com.ticxo.playeranimator.nms.v1_19_R3.network.PAChannelHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class NMSHandler_v1_19_R3
implements INMSHandler {
    private NetworkManager getConnection(EntityPlayer player) {
        try {
            Field f = PlayerConnection.class.getDeclaredField("h");
            f.setAccessible(true);
            return (NetworkManager)f.get(player.b);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    @Override
    public void injectPlayer(Player player) {
        EntityPlayer ply = ((CraftPlayer)player).getHandle();
        PAChannelHandler cdh = new PAChannelHandler(ply);
        NetworkManager connection = this.getConnection(ply);
        if (connection == null) {
            return;
        }
        ChannelPipeline pipeline = connection.m.pipeline();
        for (String name : pipeline.toMap().keySet()) {
            if (!(pipeline.get(name) instanceof NetworkManager)) continue;
            pipeline.addBefore(name, "player_animator_packet_handler", (ChannelHandler)cdh);
            break;
        }
    }

    @Override
    public void removePlayer(Player player) {
        NetworkManager connection = this.getConnection(((CraftPlayer)player).getHandle());
        if (connection == null) {
            return;
        }
        Channel channel = connection.m;
        channel.eventLoop().submit(() -> {
            channel.pipeline().remove("player_animator_packet_handler");
            return null;
        });
    }

    @Override
    public IRangeManager createRangeManager(Entity entity) {
        WorldServer level = ((CraftWorld)entity.getWorld()).getHandle();
        PlayerChunkMap.EntityTracker trackedEntity = (PlayerChunkMap.EntityTracker)level.k().a.L.get(entity.getEntityId());
        return new RangeManager(trackedEntity);
    }

    @Override
    public IRenderer createRenderer() {
        return new RendererImpl();
    }

    @Override
    public String getTexture(Player player) {
        return ((Property)((CraftPlayer)player).getHandle().fI().getProperties().get((Object)"textures").iterator().next()).getValue();
    }

    @Override
    public ItemStack setSkullTexture(ItemStack skull, TextureWrapper texture) {
        if (skull == null) {
            skull = new ItemStack(Material.PLAYER_HEAD);
        }
        net.minecraft.world.item.ItemStack nmsSkull = CraftItemStack.asNMSCopy((ItemStack)skull);
        NBTTagCompound tag = nmsSkull.v();
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", texture.toBase64()));
        tag.a("SkullOwner", (NBTBase)GameProfileSerializer.a((NBTTagCompound)new NBTTagCompound(), (GameProfile)profile));
        nmsSkull.c(tag);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsSkull);
    }
}

