/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.recipes.builders;

import io.th0rgal.oraxen.recipes.builders.WorkbenchBuilder;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ShapedBuilder
extends WorkbenchBuilder {
    public ShapedBuilder(Player player) {
        super(player, "shaped");
    }

    @Override
    public void saveRecipe(String name) {
        this.saveRecipe(name, null);
    }

    @Override
    public void saveRecipe(String name, String permission) {
        ConfigurationSection ingredients;
        ConfigurationSection resultSection;
        ConfigurationSection newCraftSection;
        HashMap<ItemStack, Character> letterByItem = new HashMap<ItemStack, Character>();
        char letter = 'A';
        String[] shapes = new String[3];
        StringBuilder shape = new StringBuilder();
        Inventory inventory = this.getInventory();
        for (int i = 1; i < inventory.getSize(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item == null) {
                shape.append("_");
            } else if (letterByItem.containsKey(item)) {
                shape.append(letterByItem.get(item));
            } else {
                shape.append(letter);
                letterByItem.put(inventory.getItem(i), Character.valueOf(letter));
                letter = (char)(letter + '\u0001');
            }
            if (shape.length() != 3) continue;
            shapes[(i + 1) / 3 - 1] = shape.toString();
            shape = new StringBuilder();
        }
        if (this.getConfig().isConfigurationSection(name)) {
            newCraftSection = this.getConfig().getConfigurationSection(name);
            resultSection = newCraftSection.getConfigurationSection("result");
            ingredients = newCraftSection.getConfigurationSection("ingredients");
        } else {
            newCraftSection = this.getConfig().createSection(name);
            resultSection = newCraftSection.createSection("result");
            ingredients = newCraftSection.createSection("ingredients");
        }
        newCraftSection.set("shape", (Object)shapes);
        this.setSerializedItem(resultSection, inventory.getItem(0));
        for (Map.Entry entry : letterByItem.entrySet()) {
            ConfigurationSection ingredientSection = ingredients.createSection(String.valueOf(entry.getValue()));
            this.setSerializedItem(ingredientSection, (ItemStack)entry.getKey());
        }
        if (permission != null) {
            newCraftSection.set("permission", (Object)permission);
        }
        this.saveConfig();
        this.close();
    }
}

