/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.sapling;

import com.jeff_media.customblockdata.CustomBlockData;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenBlocks;
import io.th0rgal.oraxen.compatibilities.provided.worldedit.WrappedWorldEdit;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.StringBlockMechanic;
import io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.sapling.SaplingMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.PluginUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SaplingTask
extends BukkitRunnable {
    private final int delay;

    public SaplingTask(int delay) {
        this.delay = delay;
    }

    public void run() {
        if (!PluginUtils.isEnabled("WorldEdit")) {
            return;
        }
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                for (Block block : CustomBlockData.getBlocksWithCustomData((Plugin)OraxenPlugin.get(), (Chunk)chunk)) {
                    PersistentDataContainer pdc = BlockHelpers.getPDC(block);
                    if (pdc.has(SaplingMechanic.SAPLING_KEY, PersistentDataType.INTEGER) && block.getType() == Material.TRIPWIRE) {
                        StringBlockMechanic string = OraxenBlocks.getStringMechanic(block);
                        if (string == null || !string.isSapling()) {
                            return;
                        }
                        SaplingMechanic sapling = string.getSaplingMechanic();
                        if (sapling == null || !sapling.hasSchematic() || !sapling.canGrowNaturally() || sapling.requiresWaterSource() && !sapling.isInWater(block) || sapling.requiresLight() && block.getLightLevel() < sapling.getMinLightLevel() || !sapling.replaceBlocks() && !WrappedWorldEdit.getBlocksInSchematic(block.getLocation(), sapling.getSchematic()).isEmpty()) continue;
                        int growthTimeRemains = (Integer)pdc.getOrDefault(SaplingMechanic.SAPLING_KEY, PersistentDataType.INTEGER, (Object)0) - this.delay;
                        if (growthTimeRemains <= 0) {
                            block.setType(Material.AIR, false);
                            if (sapling.hasGrowSound()) {
                                block.getWorld().playSound(block.getLocation(), sapling.getGrowSound(), 1.0f, 0.8f);
                            }
                            WrappedWorldEdit.pasteSchematic(block.getLocation(), sapling.getSchematic(), sapling.replaceBlocks(), sapling.copyBiomes(), sapling.copyEntities());
                            continue;
                        }
                        pdc.set(SaplingMechanic.SAPLING_KEY, PersistentDataType.INTEGER, (Object)growthTimeRemains);
                        continue;
                    }
                    if (!pdc.has(SaplingMechanic.SAPLING_KEY, PersistentDataType.INTEGER) || block.getType() == Material.TRIPWIRE) continue;
                    pdc.remove(SaplingMechanic.SAPLING_KEY);
                }
            }
        }
    }
}

