/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.stringblock.sapling;

import io.th0rgal.oraxen.OraxenPlugin;
import java.io.File;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class SaplingMechanic {
    public static final NamespacedKey SAPLING_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "sapling");
    private final boolean canGrowNaturally;
    private final int naturalGrowthTime;
    private final boolean canGrowFromBoneMeal;
    private final int boneMealGrowthSpeedup;
    private final String growSound;
    private final int minLightLevel;
    private final boolean requiresWaterSource;
    private final String schematicName;
    private final boolean shouldReplaceBlocks;
    private final boolean shouldCopyBiomes;
    private final boolean shouldCopyEntities;

    public SaplingMechanic(String itemId, ConfigurationSection section) {
        this.canGrowNaturally = section.getBoolean("canGrowNaturally", true);
        this.naturalGrowthTime = section.getInt("naturalGrowthTime", 6000);
        this.canGrowFromBoneMeal = section.getBoolean("canGrowFromBoneMeal", true);
        this.boneMealGrowthSpeedup = Math.min(section.getInt("boneMealGrowthSpeedup", this.naturalGrowthTime / 5), this.naturalGrowthTime);
        this.growSound = section.getString("growSound", null);
        this.minLightLevel = section.getInt("minLightLevel", 0);
        this.requiresWaterSource = section.getBoolean("requiresWaterSource", false);
        this.schematicName = section.getString("schematicName", null);
        this.shouldReplaceBlocks = section.getBoolean("shouldReplaceBlocks", false);
        this.shouldCopyBiomes = section.getBoolean("shouldCopyBiomes", false);
        this.shouldCopyEntities = section.getBoolean("shouldCopyEntities", false);
    }

    public boolean requiresWaterSource() {
        return this.requiresWaterSource;
    }

    public boolean requiresLight() {
        return this.minLightLevel != 0;
    }

    public int getMinLightLevel() {
        return this.minLightLevel;
    }

    public boolean canGrowNaturally() {
        return this.canGrowNaturally;
    }

    public int getNaturalGrowthTime() {
        return this.naturalGrowthTime;
    }

    public boolean canGrowFromBoneMeal() {
        return this.canGrowFromBoneMeal;
    }

    public int getBoneMealGrowthSpeedup() {
        return this.boneMealGrowthSpeedup;
    }

    public boolean hasGrowSound() {
        return this.growSound != null;
    }

    public String getGrowSound() {
        return this.growSound;
    }

    public boolean hasSchematic() {
        return this.schematicName != null && this.getSchematic() != null;
    }

    public String getSchematicName() {
        if (this.schematicName.endsWith(".schem")) {
            return this.schematicName;
        }
        return this.schematicName + ".schem";
    }

    public File getSchematic() {
        File schem = new File(OraxenPlugin.get().getConfigsManager().getSchematicsFolder().getAbsolutePath() + "/" + this.getSchematicName());
        if (!schem.exists()) {
            return null;
        }
        return schem;
    }

    public boolean replaceBlocks() {
        return this.shouldReplaceBlocks;
    }

    public boolean copyBiomes() {
        return this.shouldCopyBiomes;
    }

    public boolean copyEntities() {
        return this.shouldCopyEntities;
    }

    public boolean isInWater(Block block) {
        return block.getRelative(BlockFace.DOWN).getType() == Material.WATER;
    }
}

