/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.compatibilities.provided.blocklocker.BlockLockerMechanic;
import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.limitedplacing.LimitedPlacing;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.NoteBlockMechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.directional.DirectionalBlock;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.farmblock.FarmBlockDryout;
import io.th0rgal.oraxen.mechanics.provided.gameplay.noteblock.logstrip.LogStripping;
import io.th0rgal.oraxen.mechanics.provided.gameplay.storage.StorageMechanic;
import io.th0rgal.oraxen.utils.actions.ClickAction;
import io.th0rgal.oraxen.utils.blocksounds.BlockSounds;
import io.th0rgal.oraxen.utils.drops.Drop;
import io.th0rgal.oraxen.utils.drops.Loot;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NoteBlockMechanic
extends Mechanic {
    public static final NamespacedKey FARMBLOCK_KEY = new NamespacedKey((Plugin)OraxenPlugin.get(), "farmblock");
    private final int customVariation;
    private final Drop drop;
    private final LimitedPlacing limitedPlacing;
    private final StorageMechanic storage;
    private final BlockSounds blockSounds;
    private String model;
    private final int hardness;
    private final int light;
    private final boolean canIgnite;
    private final boolean isFalling;
    private final FarmBlockDryout farmBlockDryout;
    private final LogStripping logStripping;
    private final DirectionalBlock directionalBlock;
    private final List<ClickAction> clickActions;
    private final BlockLockerMechanic blockLocker;

    public NoteBlockMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        ConfigurationSection logStripSection;
        this.model = section.getString("model");
        this.customVariation = section.getInt("custom_variation");
        this.hardness = section.getInt("hardness", 1);
        this.light = Math.min(section.getInt("light", -1), 15);
        this.clickActions = ClickAction.parseList(section);
        this.canIgnite = section.getBoolean("can_ignite", false);
        this.isFalling = section.getBoolean("is_falling", false);
        ConfigurationSection dropSection = section.getConfigurationSection("drop");
        this.drop = dropSection != null ? Drop.createDrop(NoteBlockMechanicFactory.getInstance().toolTypes, dropSection, this.getItemID()) : new Drop(new ArrayList<Loot>(), false, false, this.getItemID());
        ConfigurationSection farmBlockSection = section.getConfigurationSection("farmblock");
        FarmBlockDryout farmBlockDryout = this.farmBlockDryout = farmBlockSection != null ? new FarmBlockDryout(this.getItemID(), farmBlockSection) : null;
        if (this.farmBlockDryout != null) {
            ((NoteBlockMechanicFactory)this.getFactory()).registerFarmBlock();
        }
        this.logStripping = (logStripSection = section.getConfigurationSection("logStrip")) != null ? new LogStripping(logStripSection) : null;
        ConfigurationSection directionalSection = section.getConfigurationSection("directional");
        this.directionalBlock = directionalSection != null ? new DirectionalBlock(directionalSection) : null;
        ConfigurationSection limitedPlacingSection = section.getConfigurationSection("limited_placing");
        this.limitedPlacing = limitedPlacingSection != null ? new LimitedPlacing(limitedPlacingSection) : null;
        ConfigurationSection storageSection = section.getConfigurationSection("storage");
        this.storage = storageSection != null ? new StorageMechanic(storageSection) : null;
        ConfigurationSection blockSoundsSection = section.getConfigurationSection("block_sounds");
        this.blockSounds = blockSoundsSection != null ? new BlockSounds(blockSoundsSection) : null;
        ConfigurationSection blockLockerSection = section.getConfigurationSection("blocklocker");
        this.blockLocker = blockLockerSection != null ? new BlockLockerMechanic(blockLockerSection) : null;
    }

    public boolean hasLimitedPlacing() {
        return this.limitedPlacing != null;
    }

    public LimitedPlacing getLimitedPlacing() {
        return this.limitedPlacing;
    }

    public boolean isStorage() {
        return this.storage != null;
    }

    public StorageMechanic getStorage() {
        return this.storage;
    }

    public boolean hasBlockSounds() {
        return this.blockSounds != null;
    }

    public BlockSounds getBlockSounds() {
        return this.blockSounds;
    }

    public boolean hasDryout() {
        return this.farmBlockDryout != null;
    }

    public FarmBlockDryout getDryout() {
        return this.farmBlockDryout;
    }

    public boolean isLog() {
        if (this.isDirectional() && !this.getDirectional().isParentBlock()) {
            return this.logStripping != null || this.directionalBlock.getParentMechanic().isLog();
        }
        return this.logStripping != null;
    }

    public LogStripping getLog() {
        return this.logStripping;
    }

    public boolean isFalling() {
        if (this.isDirectional() && !this.directionalBlock.isParentBlock()) {
            return this.isFalling || this.directionalBlock.getParentMechanic().isFalling();
        }
        return this.isFalling;
    }

    public boolean isDirectional() {
        return this.directionalBlock != null;
    }

    public DirectionalBlock getDirectional() {
        return this.directionalBlock;
    }

    public String getModel(ConfigurationSection section) {
        if (this.model != null) {
            return this.model;
        }
        return section.getString("Pack.model");
    }

    public int getCustomVariation() {
        return this.customVariation;
    }

    public Drop getDrop() {
        return this.drop;
    }

    public boolean hasHardness() {
        if (this.isDirectional() && !this.getDirectional().isParentBlock()) {
            return this.hardness != -1 || this.directionalBlock.getParentMechanic().hasHardness();
        }
        return this.hardness != -1;
    }

    public int getHardness() {
        return this.hardness;
    }

    public boolean hasLight() {
        if (this.isDirectional() && !this.getDirectional().isParentBlock()) {
            return this.light != -1 || this.directionalBlock.getParentMechanic().hasLight();
        }
        return this.light != -1;
    }

    public int getLight() {
        return this.light;
    }

    public boolean canIgnite() {
        if (this.isDirectional() && !this.getDirectional().isParentBlock()) {
            return this.canIgnite || this.directionalBlock.getParentMechanic().canIgnite();
        }
        return this.canIgnite;
    }

    public boolean hasClickActions() {
        return !this.clickActions.isEmpty();
    }

    public void runClickActions(Player player) {
        for (ClickAction action : this.clickActions) {
            if (!action.canRun(player)) continue;
            action.performActions(player);
        }
    }

    public boolean isInteractable() {
        return this.hasClickActions() || this.isStorage();
    }

    public BlockLockerMechanic getBlockLocker() {
        return this.blockLocker;
    }
}

