/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.config;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Message;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.utils.OraxenYaml;
import io.th0rgal.oraxen.utils.ReflectionUtils;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ResourcesManager {
    final JavaPlugin plugin;
    private Map.Entry<File, YamlConfiguration> settings;
    private Map.Entry<File, YamlConfiguration> mechanics;

    public ResourcesManager(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    public YamlConfiguration getSettings() {
        return this.getSettingsEntry().getValue();
    }

    public Map.Entry<File, YamlConfiguration> getSettingsEntry() {
        return this.settings != null ? this.settings : (this.settings = this.getEntry("settings.yml"));
    }

    public YamlConfiguration getMechanics() {
        return this.getMechanicsEntry().getValue();
    }

    public Map.Entry<File, YamlConfiguration> getMechanicsEntry() {
        return this.mechanics != null ? this.mechanics : (this.mechanics = this.getEntry("mechanics.yml"));
    }

    public Map.Entry<File, YamlConfiguration> getEntry(String fileName) {
        File file = this.extractConfiguration(fileName);
        return new AbstractMap.SimpleEntry<File, YamlConfiguration>(file, OraxenYaml.loadConfiguration(file));
    }

    public File extractConfiguration(String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            this.plugin.saveResource(fileName, false);
        }
        return file;
    }

    public void extractConfigsInFolder(String folder, String fileExtension) {
        ZipInputStream zip = ResourcesManager.browse();
        try {
            this.extractConfigsInFolder(zip, folder, fileExtension);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void extractConfigsInFolder(ZipInputStream zip, String folder, String fileExtension) throws IOException {
        ZipEntry entry = zip.getNextEntry();
        while (entry != null) {
            this.extractFileAccordingToExtension(entry, folder, fileExtension);
            entry = zip.getNextEntry();
        }
        zip.closeEntry();
        zip.close();
    }

    public void extractFileIfTrue(ZipEntry entry, boolean isSuitable) {
        if (entry.isDirectory()) {
            return;
        }
        if (isSuitable) {
            if (!Settings.GENERATE_CUSTOM_ARMOR_TEXTURES.toBool().booleanValue() && entry.getName().startsWith("pack/textures/models/armor/leather_layer")) {
                return;
            }
            this.plugin.saveResource(entry.getName(), true);
        }
    }

    private void extractFileAccordingToExtension(ZipEntry entry, String folder, String fileExtension) {
        boolean isSuitable = entry.getName().startsWith(folder + "/") && entry.getName().endsWith("." + fileExtension);
        this.extractFileIfTrue(entry, isSuitable);
    }

    public static ZipInputStream browse() {
        return ReflectionUtils.getJarStream(OraxenPlugin.class).orElseThrow(() -> {
            Message.ZIP_BROWSE_ERROR.log(new TagResolver[0]);
            return new RuntimeException("OraxenResources not found!");
        });
    }
}

