/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils;

import io.th0rgal.oraxen.utils.VersionUtil;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class EntityUtils {
    private static Method spawnMethod;

    public static boolean isFixed(ItemDisplay itemDisplay) {
        return itemDisplay.getItemDisplayTransform() == ItemDisplay.ItemDisplayTransform.FIXED;
    }

    public static boolean isNone(ItemDisplay itemDisplay) {
        return itemDisplay.getItemDisplayTransform() == ItemDisplay.ItemDisplayTransform.NONE;
    }

    public void teleport(@NotNull Location location, @NotNull Entity entity, PlayerTeleportEvent.TeleportCause cause) {
        if (VersionUtil.isPaperServer() || VersionUtil.isFoliaServer() && VersionUtil.atOrAbove("1.19.4")) {
            entity.teleportAsync(location, cause);
        } else {
            entity.teleport(location);
        }
    }

    public static void teleport(@NotNull Location location, @NotNull Entity entity) {
        if (VersionUtil.atOrAbove("1.19.4") && (VersionUtil.isPaperServer() || VersionUtil.isFoliaServer())) {
            entity.teleportAsync(location);
        } else {
            entity.teleport(location);
        }
    }

    public static <T> T spawnEntity(@NotNull Location location, @NotNull Class<T> clazz, EntityConsumer<T> consumer) {
        try {
            World world = location.getWorld();
            Object wrappedConsumer = VersionUtil.atOrAbove("1.20.2") ? new JavaConsumerWrapper<T>(consumer) : new BukkitConsumerWrapper<T>(consumer);
            Object entity = spawnMethod.invoke((Object)world, location, clazz, wrappedConsumer);
            return (T)entity;
        }
        catch (Exception e) {
            Logs.logWarning(e.getMessage());
            return null;
        }
    }

    static {
        try {
            Class<?> entitySpawnerClass = Class.forName("org.bukkit.RegionAccessor");
            spawnMethod = VersionUtil.atOrAbove("1.20.2") ? entitySpawnerClass.getDeclaredMethod("spawn", Location.class, Class.class, Consumer.class) : entitySpawnerClass.getDeclaredMethod("spawn", Location.class, Class.class, org.bukkit.util.Consumer.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Logs.logWarning(e.getMessage());
        }
    }

    public static class JavaConsumerWrapper<T>
    implements Consumer<T> {
        private final EntityConsumer<T> entityConsumer;

        public JavaConsumerWrapper(EntityConsumer<T> entityConsumer) {
            this.entityConsumer = entityConsumer;
        }

        @Override
        public void accept(T entity) {
            this.entityConsumer.accept(entity);
        }
    }

    public static interface EntityConsumer<T> {
        public void accept(T var1);
    }

    public static class BukkitConsumerWrapper<T>
    implements org.bukkit.util.Consumer<T> {
        private final EntityConsumer<T> entityConsumer;

        public BukkitConsumerWrapper(EntityConsumer<T> entityConsumer) {
            this.entityConsumer = entityConsumer;
        }

        public void accept(T entity) {
            this.entityConsumer.accept(entity);
        }
    }
}

