/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.pack.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.pack.generation.PackSlicer;
import io.th0rgal.oraxen.utils.Utils;
import io.th0rgal.oraxen.utils.VirtualFile;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class AtlasGenerator {
    public static void generateAtlasFile(List<VirtualFile> output, Set<String> malformedTextures) {
        Logs.logSuccess("Generating atlas-file for 1.19.3+ Resource Pack format");
        if (Settings.EXCLUDE_MALFORMED_ATLAS.toBool().booleanValue() && !malformedTextures.isEmpty()) {
            Logs.logWarning("Attempting to exclude malformed textures from atlas-file");
        }
        JsonObject atlas = new JsonObject();
        JsonArray atlasContent = new JsonArray();
        LinkedHashMap<VirtualFile, String> textureSubFolders = new LinkedHashMap<VirtualFile, String>();
        for (VirtualFile v2 : output.stream().filter(v -> v.getPath().split("/").length > 3 && v.getPath().split("/")[2].equals("textures") && v.getPath().endsWith(".png") && !v.getPath().endsWith("_layer_1.png") && !v.getPath().endsWith("_layer_2.png") && PackSlicer.INPUTS.stream().noneMatch(input -> v.getPath().endsWith(input.path)) && PackSlicer.OUTPUT_PATHS.stream().noneMatch(outPath -> v.getPath().endsWith((String)outPath))).sorted().collect(Collectors.toCollection(LinkedHashSet::new))) {
            textureSubFolders.put(v2, Utils.removeExtensionOnly(v2.getPath().replaceFirst("assets/.*/textures/", "")));
        }
        HashSet itemTextures = new HashSet();
        OraxenItems.getItems().stream().filter(builder -> builder.hasOraxenMeta() && builder.getOraxenMeta().hasLayers()).forEach(builder -> itemTextures.addAll(builder.getOraxenMeta().getLayers()));
        LinkedHashSet glyphTextures = new LinkedHashSet();
        OraxenPlugin.get().getFontManager().getGlyphs().forEach(glyph -> glyphTextures.add(glyph.getTexture().replace(".png", "")));
        for (Map.Entry entry : textureSubFolders.entrySet()) {
            VirtualFile virtual = (VirtualFile)entry.getKey();
            String path = (String)entry.getValue();
            if (glyphTextures.contains(path) && !itemTextures.contains(path)) continue;
            JsonObject atlasEntry = new JsonObject();
            String namespace = virtual.getPath().replaceFirst("assets/", "").split("/")[0];
            String malformPathCheck = "assets/" + namespace + "/textures/" + path + ".png";
            if (Settings.EXCLUDE_MALFORMED_ATLAS.toBool().booleanValue()) {
                if (malformedTextures.stream().anyMatch(malformPathCheck::startsWith)) {
                    Logs.logWarning("Excluding malformed texture from atlas-file: <gold>" + malformPathCheck);
                    continue;
                }
            }
            if (Settings.ATLAS_GENERATION_TYPE.toString().equals("DIRECTORY")) {
                path = StringUtils.substringBeforeLast((String)path, (String)"/");
                atlasEntry.addProperty("type", "directory");
                atlasEntry.addProperty("source", path);
                atlasEntry.addProperty("prefix", path + "/");
            } else {
                String sprite = namespace + ":" + path;
                atlasEntry.addProperty("type", "single");
                atlasEntry.addProperty("resource", sprite);
                atlasEntry.addProperty("sprite", sprite);
            }
            if (atlasContent.contains((JsonElement)atlasEntry)) continue;
            atlasContent.add((JsonElement)atlasEntry);
        }
        AtlasGenerator.removeChildEntriesInDirectoryAtlas(atlasContent);
        atlas.add("sources", (JsonElement)atlasContent);
        VirtualFile atlasFile = new VirtualFile("assets/minecraft/atlases", "blocks.json", new ByteArrayInputStream(atlas.toString().getBytes(StandardCharsets.UTF_8)));
        output.removeIf(v -> v.getPath().equals(atlasFile.getPath()));
        output.add(atlasFile);
        Logs.newline();
    }

    private static void removeChildEntriesInDirectoryAtlas(JsonArray atlasContent) {
        if (Settings.ATLAS_GENERATION_TYPE.toString().equals("DIRECTORY")) {
            HashSet remove = new HashSet();
            atlasContent.forEach(element -> {
                String source = element.getAsJsonObject().get("source").getAsString();
                if (source.contains("/")) {
                    JsonObject parentObject = new JsonObject();
                    parentObject.addProperty("type", "directory");
                    parentObject.addProperty("source", source);
                    parentObject.addProperty("prefix", source + "/");
                    if (atlasContent.contains((JsonElement)parentObject)) {
                        remove.add(element);
                    }
                }
            });
            remove.forEach(arg_0 -> ((JsonArray)atlasContent).remove(arg_0));
        }
    }
}

