/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.nms;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.config.Settings;
import io.th0rgal.oraxen.font.Glyph;
import io.th0rgal.oraxen.utils.AdventureUtils;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.translation.GlobalTranslator;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlyphHandlers {
    private static final Key randomKey = Key.key((String)"random");
    private static final Pattern colorableRegex = Pattern.compile("<glyph:.*:(c|colorable)>");

    public static boolean isNms() {
        return GlyphHandler.get() == GlyphHandler.NMS;
    }

    public static Component transform(Component component, @Nullable Player player, boolean isUtf) {
        if (player != null) {
            return GlyphHandlers.escapeGlyphs(component, player);
        }
        return GlyphHandlers.transformGlyphs(component, isUtf);
    }

    private static Component escapeGlyphs(Component component, @NotNull Player player) {
        component = GlobalTranslator.render((Component)component, (Locale)player.locale());
        String serialized = (String)AdventureUtils.MINI_MESSAGE.serialize(component);
        for (Glyph glyph : OraxenPlugin.get().getFontManager().getGlyphs()) {
            if (glyph.hasPermission(player)) continue;
            component = component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral(glyph.getCharacter()).replacement((ComponentLike)glyph.getGlyphComponent().font(randomKey)).build());
            Matcher matcher = glyph.baseRegex.matcher(serialized);
            while (matcher.find()) {
                component = component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().once().matchLiteral(matcher.group()).replacement((ComponentLike)AdventureUtils.MINI_MESSAGE.deserialize((Object)("\\" + matcher.group()))).build());
            }
        }
        return component;
    }

    private static Component transformGlyphs(Component component, boolean isUtf) {
        String serialized = (String)AdventureUtils.MINI_MESSAGE_EMPTY.serialize(component);
        for (Glyph glyph : OraxenPlugin.get().getFontManager().getGlyphs()) {
            Matcher matcher = glyph.baseRegex.matcher(serialized);
            while (matcher.find()) {
                component = component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().once().matchLiteral(matcher.group()).replacement((ComponentLike)glyph.getGlyphComponent()).build());
            }
            if (!isUtf) continue;
            matcher = glyph.escapedRegex.matcher(serialized);
            while (matcher.find()) {
                component = component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().once().matchLiteral(matcher.group()).replacement((ComponentLike)AdventureUtils.MINI_MESSAGE_EMPTY.deserialize((Object)StringUtils.removeStart((String)matcher.group(), (String)"\\"))).build());
            }
        }
        return component;
    }

    public static String formatJsonString(@NotNull JsonObject obj, @Nullable Player player) {
        if (obj.has("args") || obj.has("text") || obj.has("extra") || obj.has("translate")) {
            Component component = AdventureUtils.GSON_SERIALIZER.deserialize((Object)obj.toString());
            component = AdventureUtils.MINI_MESSAGE_EMPTY.deserialize((Object)((String)AdventureUtils.MINI_MESSAGE_EMPTY.serialize(component)));
            component = GlyphHandlers.transform(component, player, false);
            return (String)AdventureUtils.GSON_SERIALIZER.serialize(component);
        }
        return obj.toString();
    }

    public static Function<String, String> transformer(@Nullable Player player) {
        return string -> {
            try {
                JsonElement element = JsonParser.parseString((String)string);
                if (element.isJsonObject()) {
                    return GlyphHandlers.formatJsonString(element.getAsJsonObject(), player);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        };
    }

    private static enum GlyphHandler {
        NMS,
        VANILLA;


        public static GlyphHandler get() {
            try {
                return GlyphHandler.valueOf(Settings.GLYPH_HANDLER.toString());
            }
            catch (IllegalArgumentException e) {
                Logs.logError("Invalid glyph handler: " + Settings.GLYPH_HANDLER + ", defaulting to VANILLA", true);
                Logs.logError("Valid options are: NMS, VANILLA", true);
                return VANILLA;
            }
        }
    }
}

