/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.misc.consumablepotioneffects;

import io.th0rgal.oraxen.mechanics.Mechanic;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.utils.logs.Logs;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ConsumablePotionEffectsMechanic
extends Mechanic {
    private final Set<PotionEffect> effects = new HashSet<PotionEffect>();

    public ConsumablePotionEffectsMechanic(MechanicFactory mechanicFactory, ConfigurationSection section) {
        super(mechanicFactory, section, new Function[0]);
        for (String effectKey : section.getKeys(false)) {
            ConfigurationSection effectSection = section.getConfigurationSection(effectKey);
            if (effectSection == null) continue;
            this.registersEffectFromSection(effectSection);
        }
    }

    public void registersEffectFromSection(ConfigurationSection section) {
        String type = section.getName().toLowerCase();
        PotionEffectType effectType = PotionEffectType.getByName((String)type);
        if (effectType == null) {
            effectType = PotionEffectType.getByKey((NamespacedKey)(type.contains(":") ? NamespacedKey.fromString((String)type) : NamespacedKey.minecraft((String)type)));
        }
        if (effectType == null) {
            Logs.logError("Invalid potion effect: " + section.getName() + ", in " + StringUtils.substringBefore((String)section.getCurrentPath(), (String)".") + "!");
            return;
        }
        int amplifier = section.getInt("amplifier", 0);
        int duration = section.getInt("duration", 600);
        boolean ambient = section.getBoolean("ambient", false);
        boolean particles = section.getBoolean("particles", true);
        boolean icon = section.getBoolean("icon", true);
        PotionEffect potionEffect = new PotionEffect(effectType, duration, amplifier, ambient, particles, icon);
        this.effects.add(potionEffect);
    }

    public void onItemPlaced(Player player) {
        player.addPotionEffects(this.effects);
    }
}

