/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.combat.spell.energyblast;

import io.th0rgal.oraxen.OraxenPlugin;
import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.combat.spell.energyblast.EnergyBlastMechanic;
import io.th0rgal.oraxen.utils.BlockHelpers;
import io.th0rgal.oraxen.utils.EventUtils;
import io.th0rgal.oraxen.utils.VectorUtils;
import io.th0rgal.oraxen.utils.timers.Timer;
import io.th0rgal.protectionlib.ProtectionLib;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class EnergyBlastMechanicManager
implements Listener {
    private final MechanicFactory factory;

    public EnergyBlastMechanicManager(MechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerUse(PlayerInteractEvent event) {
        Location location;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        String itemID = OraxenItems.getIdByItem(item);
        EnergyBlastMechanic mechanic = (EnergyBlastMechanic)this.factory.getMechanic(item);
        Block block = event.getClickedBlock();
        Location location2 = location = block != null ? block.getLocation() : player.getLocation();
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (BlockHelpers.isInteractable(block) && event.useInteractedBlock() == Event.Result.ALLOW) {
            return;
        }
        if (!ProtectionLib.canUse(player, location)) {
            return;
        }
        if (this.factory.isNotImplementedIn(itemID)) {
            return;
        }
        if (mechanic == null) {
            return;
        }
        Timer playerTimer = mechanic.getTimer(player);
        if (!playerTimer.isFinished()) {
            mechanic.getTimer(player).sendToPlayer(player);
            return;
        }
        playerTimer.reset();
        Location origin = player.getEyeLocation();
        Vector direction = origin.getDirection();
        direction.normalize();
        direction.multiply(0.1);
        Location destination = origin.clone().add(direction);
        for (int i = 0; i < mechanic.getLength() * 10; ++i) {
            Location loc = destination.add(direction);
            this.spawnParticle(loc.getWorld(), loc, mechanic);
        }
        mechanic.removeCharge(item);
        this.playEffect(player, mechanic);
    }

    private void playEffect(final Player player, final EnergyBlastMechanic mechanic) {
        new BukkitRunnable(){
            final Vector dir;
            static final int circlePoints = 360;
            double radius;
            final Location playerLoc;
            final double pitch;
            final double yaw;
            final double increment = Math.PI / 180;
            double circlePointOffset;
            int beamLength;
            final double radiusShrinkage;
            {
                this.dir = player.getLocation().getDirection().normalize();
                this.radius = 2.0;
                this.playerLoc = player.getEyeLocation();
                this.pitch = (this.playerLoc.getPitch() + 90.0f) * ((float)Math.PI / 180);
                this.yaw = -this.playerLoc.getYaw() * ((float)Math.PI / 180);
                this.increment = Math.PI / 180;
                this.circlePointOffset = 0.0;
                this.beamLength = mechanic.getLength() * 2;
                this.radiusShrinkage = this.radius / ((double)(this.beamLength + 2) / 2.0);
            }

            public void run() {
                --this.beamLength;
                if (this.beamLength < 1) {
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 360; ++i) {
                    double angle = (double)i * (Math.PI / 180) + this.circlePointOffset;
                    double x = this.radius * Math.cos(angle);
                    double z = this.radius * Math.sin(angle);
                    Vector vec = new Vector(x, 0.0, z);
                    VectorUtils.rotateAroundAxisX(vec, this.pitch);
                    VectorUtils.rotateAroundAxisY(vec, this.yaw);
                    this.playerLoc.add(vec);
                    EnergyBlastMechanicManager.this.spawnParticle(this.playerLoc.getWorld(), this.playerLoc, mechanic);
                    this.playerLoc.subtract(vec);
                }
                this.circlePointOffset += 0.005817764173314432;
                if (this.circlePointOffset >= Math.PI / 180) {
                    this.circlePointOffset = 0.0;
                }
                this.radius -= this.radiusShrinkage;
                if (this.radius < 0.0) {
                    EnergyBlastMechanicManager.this.spawnParticle(this.playerLoc.getWorld(), this.playerLoc, mechanic, 1000, 0.3, 0.3, 0.3, 0.3);
                    for (Entity entity : this.playerLoc.getWorld().getNearbyEntities(this.playerLoc, 0.5, 0.5, 0.5)) {
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (entity == player) continue;
                        EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)player, entity, EntityDamageEvent.DamageCause.MAGIC, mechanic.getDamage() * 3.0);
                        if (entity.isDead() || EventUtils.callEvent((Event)event)) continue;
                        entity.setLastDamageCause((EntityDamageEvent)event);
                        livingEntity.damage(mechanic.getDamage() * 3.0, (Entity)player);
                    }
                    this.cancel();
                    return;
                }
                this.playerLoc.add(this.dir);
                for (Entity entity : this.playerLoc.getWorld().getNearbyEntities(this.playerLoc, this.radius, this.radius, this.radius)) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (entity == player) continue;
                    EntityDamageByEntityEvent event = new EntityDamageByEntityEvent((Entity)player, (Entity)livingEntity, EntityDamageEvent.DamageCause.MAGIC, mechanic.getDamage());
                    if (livingEntity.isDead() || !EventUtils.callEvent((Event)event)) continue;
                    livingEntity.setLastDamageCause((EntityDamageEvent)event);
                    livingEntity.damage(mechanic.getDamage(), (Entity)player);
                }
            }
        }.runTaskTimer((Plugin)OraxenPlugin.get(), 0L, 1L);
    }

    private void spawnParticle(World world, Location location, EnergyBlastMechanic mechanic) {
        if (mechanic.getParticle() == Particle.REDSTONE) {
            world.spawnParticle(Particle.REDSTONE, location, 1, 0.0, 0.0, 0.0, 0.0, (Object)mechanic.getParticleColor());
        } else {
            world.spawnParticle(mechanic.getParticle(), location, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void spawnParticle(World world, Location location, EnergyBlastMechanic mechanic, int amount, double offsetX, double offsetY, double offsetZ, double extra) {
        if (mechanic.getParticle() == Particle.REDSTONE) {
            world.spawnParticle(Particle.REDSTONE, location, amount, offsetX, offsetY, offsetZ, extra, (Object)mechanic.getParticleColor());
        } else {
            world.spawnParticle(mechanic.getParticle(), location, amount, offsetX, offsetY, offsetZ, extra);
        }
    }
}

