/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.mechanics.provided.combat.lifeleech;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.mechanics.MechanicFactory;
import io.th0rgal.oraxen.mechanics.provided.combat.lifeleech.LifeLeechMechanic;
import io.th0rgal.protectionlib.ProtectionLib;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class LifeLeechMechanicListener
implements Listener {
    private final MechanicFactory factory;

    public LifeLeechMechanicListener(MechanicFactory factory) {
        this.factory = factory;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCall(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player damager = (Player)entity;
        Entity entity2 = event.getEntity();
        if (!(entity2 instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity2;
        if (!ProtectionLib.canInteract(damager, event.getEntity().getLocation())) {
            return;
        }
        String itemID = OraxenItems.getIdByItem(damager.getInventory().getItemInMainHand());
        if (!OraxenItems.exists(itemID)) {
            return;
        }
        LifeLeechMechanic mechanic = (LifeLeechMechanic)this.factory.getMechanic(itemID);
        if (mechanic == null) {
            return;
        }
        double maxHealth = damager.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue();
        damager.setHealth(Math.min(damager.getHealth() + (double)mechanic.getAmount(), maxHealth));
        livingEntity.setHealth(Math.max(livingEntity.getHealth() - (double)mechanic.getAmount(), 0.0));
    }
}

