/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.drops;

import io.th0rgal.oraxen.api.OraxenItems;
import io.th0rgal.oraxen.compatibilities.provided.ecoitems.WrappedEcoItem;
import io.th0rgal.oraxen.compatibilities.provided.mythiccrucible.WrappedCrucibleItem;
import io.th0rgal.oraxen.items.ItemUpdater;
import java.util.LinkedHashMap;
import java.util.concurrent.ThreadLocalRandom;
import net.Indyuce.mmoitems.MMOItems;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class Loot {
    private ItemStack itemStack;
    private final int probability;
    private final int minAmount;
    private final int maxAmount;
    private LinkedHashMap<String, Object> config;

    public Loot(LinkedHashMap<String, Object> config) {
        this.probability = config.containsKey("probability") ? (int)(1.0 / (Double)config.get("probability")) : 1;
        this.minAmount = config.containsKey("min_amount") ? (Integer)config.get("min_amount") : 1;
        this.maxAmount = config.containsKey("max_amount") ? Math.max((Integer)config.get("max_amount"), this.minAmount) : this.minAmount;
        this.config = config;
    }

    public Loot(ItemStack itemStack, double probability) {
        this.itemStack = itemStack;
        this.probability = (int)(1.0 / probability);
        this.minAmount = 1;
        this.maxAmount = 1;
    }

    public Loot(ItemStack itemStack, double probability, int minAmount, int maxAmount) {
        this.itemStack = itemStack;
        this.probability = (int)(1.0 / probability);
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
    }

    public ItemStack getItemStack() {
        if (this.itemStack != null) {
            return ItemUpdater.updateItem(this.itemStack);
        }
        if (this.config.containsKey("oraxen_item")) {
            String itemId = this.config.get("oraxen_item").toString();
            this.itemStack = OraxenItems.getItemById(itemId).build();
        } else if (this.config.containsKey("crucible_item")) {
            this.itemStack = new WrappedCrucibleItem(this.config.get("crucible_item").toString()).build();
        } else if (this.config.containsKey("mmoitems_id") && this.config.containsKey("mmoitems_type")) {
            String type = this.config.get("mmoitems_type").toString();
            String id = this.config.get("mmoitems_id").toString();
            this.itemStack = MMOItems.plugin.getItem(type, id);
        } else {
            String itemType;
            Material material;
            this.itemStack = this.config.containsKey("ecoitem") ? new WrappedEcoItem(this.config.get("ecoitem").toString()).build() : (this.config.containsKey("minecraft_type") ? ((material = Material.getMaterial((String)(itemType = this.config.get("minecraft_type").toString()))) != null ? new ItemStack(material) : null) : (ItemStack)this.config.get("minecraft_item"));
        }
        return ItemUpdater.updateItem(this.itemStack);
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public int getProbability() {
        return this.probability;
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public void dropNaturally(Location location, int amountMultiplier) {
        if (ThreadLocalRandom.current().nextInt(this.probability) == 0) {
            this.dropItems(location, amountMultiplier);
        }
    }

    public ItemStack getItem(int amountMultiplier) {
        ItemStack stack = this.getItemStack().clone();
        int dropAmount = ThreadLocalRandom.current().nextInt(this.minAmount, this.maxAmount + 1);
        stack.setAmount(stack.getAmount() * amountMultiplier * dropAmount);
        return ItemUpdater.updateItem(stack);
    }

    private void dropItems(Location location, int amountMultiplier) {
        if (location.getWorld() != null) {
            location.getWorld().dropItemNaturally(location, this.getItem(amountMultiplier));
        }
    }
}

