/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.commands;

import io.th0rgal.oraxen.utils.AdventureUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class CommandsParser {
    private List<String> consoleCommands;
    private List<String> playerCommands;
    private List<String> oppedPlayerCommands;
    private boolean empty = false;

    public CommandsParser(ConfigurationSection section, TagResolver tagResolver) {
        if (section == null) {
            this.empty = true;
            return;
        }
        if (section.isList("console")) {
            this.consoleCommands = section.getStringList("console").stream().map(s -> AdventureUtils.parseMiniMessage(s, tagResolver)).collect(Collectors.toList());
        }
        if (section.isList("player")) {
            this.playerCommands = section.getStringList("player");
        }
        if (section.isList("opped_player")) {
            this.oppedPlayerCommands = section.getStringList("opped_player");
        }
    }

    public void perform(Player player) {
        if (this.empty) {
            return;
        }
        String playerName = player.getName();
        if (this.consoleCommands != null) {
            for (String command : this.consoleCommands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%p%", playerName));
            }
        }
        if (this.playerCommands != null) {
            for (String command : this.playerCommands) {
                Bukkit.dispatchCommand((CommandSender)player, (String)command.replace("%p%", playerName));
            }
        }
        if (this.oppedPlayerCommands != null) {
            for (String command : this.oppedPlayerCommands) {
                boolean wasOp = player.isOp();
                player.setOp(true);
                Bukkit.dispatchCommand((CommandSender)player, (String)command.replace("%p%", playerName));
                player.setOp(wasOp);
            }
        }
    }
}

