/*
 * Decompiled with CFR 0.152.
 */
package io.th0rgal.oraxen.utils.actions;

import io.th0rgal.oraxen.OraxenPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import me.gabytm.util.actions.actions.Action;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ClickAction {
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private final List<String> conditions;
    private final List<Action<Player>> actions;

    private ClickAction(List<String> conditions, List<Action<Player>> actions) {
        this.conditions = conditions;
        this.actions = actions;
    }

    private static ClickAction from(LinkedHashMap<String, Object> config) {
        List<String> conditions = config.getOrDefault("conditions", Collections.emptyList());
        List actions = OraxenPlugin.get().getClickActionManager().parse(Player.class, config.getOrDefault("actions", Collections.emptyList()));
        return actions.isEmpty() ? null : new ClickAction(conditions, actions);
    }

    public static ClickAction from(ConfigurationSection config) {
        List conditions = config.getStringList("conditions");
        List actions = OraxenPlugin.get().getClickActionManager().parse(Player.class, config.getStringList("actions"));
        if (actions.isEmpty()) {
            return null;
        }
        return new ClickAction(conditions, actions);
    }

    public static List<ClickAction> parseList(ConfigurationSection section) {
        List list = section.getList("clickActions", Collections.emptyList());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ClickAction> clickActions = new ArrayList<ClickAction>(list.size());
        for (LinkedHashMap actionConfig : list) {
            ClickAction clickAction = ClickAction.from(actionConfig);
            if (clickAction == null) continue;
            clickActions.add(clickAction);
        }
        return clickActions;
    }

    public boolean canRun(Player player) {
        if (this.conditions.isEmpty()) {
            return true;
        }
        if (this.actions.isEmpty()) {
            return false;
        }
        StandardEvaluationContext context = new StandardEvaluationContext((Object)player);
        context.setVariable("player", (Object)player);
        context.setVariable("server", (Object)Bukkit.getServer());
        for (String condition : this.conditions) {
            try {
                Boolean result = (Boolean)PARSER.parseExpression(condition).getValue((EvaluationContext)context, Boolean.class);
                if (result != null && result.booleanValue()) continue;
                return false;
            }
            catch (ParseException | SpelEvaluationException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void performActions(Player player) {
        OraxenPlugin.get().getClickActionManager().run(player, this.actions, false);
    }
}

